/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.typechecker;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.emf.EMFValidationHelper;
import org.eclipse.escet.common.java.exceptions.InputOutputException;
import org.eclipse.escet.common.typechecker.TypeChecker;

public abstract class EcoreTypeChecker<TIn, TOut extends EObject>
extends TypeChecker<TIn, TOut> {
    public boolean doEmfValidation = false;

    @Override
    public TOut typeCheck(TIn rootObj) {
        EObject rslt = (EObject)super.typeCheck(rootObj);
        if (rslt == null) {
            return null;
        }
        OutputStream stream = this.getXmlOutputStream();
        if (stream != null) {
            EMFHelper.printEObjectXML((EObject)rslt, (String)this.getEcoreFileExtension(), (OutputStream)stream);
            try {
                stream.close();
            }
            catch (IOException ex) {
                throw new InputOutputException("Failed to close stream.", (Throwable)ex);
            }
        }
        if (this.doEmfValidation) {
            EMFValidationHelper.validateObject((EObject)rslt);
        }
        return (TOut)rslt;
    }

    protected abstract String getEcoreFileExtension();

    protected OutputStream getXmlOutputStream() {
        return null;
    }
}

