/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.chi.codegen.ProcessTypeDefinition;
import org.eclipse.escet.chi.codegen.java.JavaClass;
import org.eclipse.escet.chi.codegen.java.JavaFile;
import org.eclipse.escet.chi.codegen.types.TypeID;
import org.eclipse.escet.chi.codegen.types.TypeIDCreation;
import org.eclipse.escet.chi.metamodel.chi.BehaviourDeclaration;
import org.eclipse.escet.chi.metamodel.chi.ProcessDeclaration;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CodeGeneratorContext {
    public final String specName;
    public List<JavaFile> files = Lists.list();
    private Map<PositionObject, String> globalScope = null;
    private Map<PositionObject, String> defScope = null;
    private Map<PositionObject, String> selectAltScope = null;
    private ActiveScope activeScope = ActiveScope.NONE;
    private int specUniqueNumber = 1;
    private int declUniqueNumber = -1;
    private Map<TypeID, String> classNames = Maps.map();
    private Map<TypeID, String> enumerateNames = Maps.map();
    public Set<TypeID> readParamFuncs = Sets.set();
    public Map<TypeID, ProcessTypeDefinition> processTypes = Maps.map();

    public CodeGeneratorContext(String specName) {
        this.specName = specName;
    }

    public JavaClass addJavaClass(String name, boolean isAbstract, String baseclassName, List<String> interfaces) {
        JavaClass jc = new JavaClass(null, isAbstract, name, baseclassName, interfaces);
        this.addClass(jc);
        return jc;
    }

    public void addClass(JavaFile newFile) {
        for (JavaFile jc : this.files) {
            Assert.check((jc.getFQclassname() != newFile.getFQclassname() ? 1 : 0) != 0);
        }
        this.files.add(newFile);
    }

    public void addTypeName(TypeID tid, String name) {
        this.classNames.put(tid, name);
    }

    public boolean hasTypeName(TypeID tid) {
        return this.classNames.containsKey(tid);
    }

    public String getTypeName(TypeID tid) {
        Assert.check((boolean)this.classNames.containsKey(tid));
        return this.classNames.get(tid);
    }

    public String getEnumerateName(TypeID tid) {
        return this.enumerateNames.get(tid);
    }

    public void addEnumerateName(TypeID tid, String name) {
        Assert.check((!this.enumerateNames.containsKey(tid) ? 1 : 0) != 0);
        this.enumerateNames.put(tid, name);
    }

    public void addProcessType(TypeID tid) {
        ProcessTypeDefinition ptd = this.processTypes.get(tid);
        if (ptd == null) {
            ptd = new ProcessTypeDefinition(tid);
            this.processTypes.put(tid, ptd);
        }
    }

    public void addProcessDefinition(ProcessDeclaration pd) {
        TypeID bdTid = TypeIDCreation.createProcessTypeID((BehaviourDeclaration)pd, this);
        ProcessTypeDefinition ptd = this.processTypes.get(bdTid);
        ptd.addProcess(pd);
    }

    public void generateProcessTypes() {
        for (Map.Entry<TypeID, ProcessTypeDefinition> entry : this.processTypes.entrySet()) {
            entry.getValue().generate(this);
        }
    }

    public String makeUniqueName(String prefix) {
        ++this.specUniqueNumber;
        return Strings.fmt((String)"%s_%d", (Object[])new Object[]{prefix, this.specUniqueNumber});
    }

    public void startNewDeclaration() {
        this.declUniqueNumber = 10;
    }

    public void stopNewDeclaration() {
        this.declUniqueNumber = -1;
    }

    public int getUniqueDeclNumber() {
        Assert.check((this.declUniqueNumber >= 0 ? 1 : 0) != 0);
        ++this.declUniqueNumber;
        return this.declUniqueNumber;
    }

    public void openScope(ActiveScope newScope) {
        Assert.check((newScope != ActiveScope.NONE && this.activeScope == newScope.getEnclosing() ? 1 : 0) != 0);
        this.activeScope = newScope;
        switch (this.activeScope) {
            case DEFINITION: {
                this.defScope = Maps.map();
                break;
            }
            case GLOBALS: {
                this.globalScope = Maps.map();
                break;
            }
            case SELECT_ALT: {
                this.selectAltScope = Maps.map();
                break;
            }
            default: {
                Assert.fail((Object)"Unknown scope type encountered while opening");
            }
        }
    }

    public void closeScope() {
        switch (this.activeScope) {
            case DEFINITION: {
                this.defScope = null;
                break;
            }
            case GLOBALS: {
                this.globalScope = null;
                break;
            }
            case SELECT_ALT: {
                this.selectAltScope = null;
                break;
            }
            default: {
                Assert.fail((Object)"Unknown scope type encountered while closing");
            }
        }
        this.activeScope = this.activeScope.getEnclosing();
    }

    public void addDefinition(PositionObject def, String name) {
        switch (this.activeScope) {
            case DEFINITION: {
                Assert.check((!this.defScope.containsKey(def) ? 1 : 0) != 0);
                this.defScope.put(def, name);
                break;
            }
            case GLOBALS: {
                Assert.check((!this.globalScope.containsKey(def) ? 1 : 0) != 0);
                this.globalScope.put(def, name);
                break;
            }
            case SELECT_ALT: {
                Assert.check((!this.selectAltScope.containsKey(def) ? 1 : 0) != 0);
                this.selectAltScope.put(def, name);
                break;
            }
            default: {
                Assert.fail((Object)"Unknown scope type encountered while adding");
            }
        }
    }

    public String getDefinition(PositionObject def) {
        switch (this.activeScope) {
            case SELECT_ALT: {
                String name = this.selectAltScope.get(def);
                if (name != null) {
                    return name;
                }
            }
            case DEFINITION: {
                String name = this.defScope.get(def);
                if (name != null) {
                    if (this.activeScope == ActiveScope.SELECT_ALT) {
                        return "process." + name;
                    }
                    return name;
                }
            }
            case GLOBALS: {
                String name = this.globalScope.get(def);
                return name;
            }
        }
        Assert.fail((Object)"Unknown scope type encountered while getting");
        return null;
    }

    public static enum ActiveScope {
        NONE,
        GLOBALS,
        DEFINITION,
        SELECT_ALT;


        public ActiveScope getEnclosing() {
            switch (this) {
                case DEFINITION: {
                    return GLOBALS;
                }
                case GLOBALS: {
                    return NONE;
                }
                case NONE: {
                    return NONE;
                }
                case SELECT_ALT: {
                    return DEFINITION;
                }
            }
            Assert.fail((Object)"Unknow kind of current scope.");
            return NONE;
        }
    }
}

