/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Locale;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.EndUserException;

public class CsvParser {
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final char COMMA = ',';
    public static final char DQUOTE = '\"';
    private Reader reader = null;
    private int nextChar = -1;
    private int numFields = -1;
    private int rowNumber = 0;

    public CsvParser(Reader reader) {
        if (reader != null) {
            this.setInput(reader);
        }
    }

    public void setInput(Reader reader) {
        this.reader = reader;
        this.nextChar = -1;
        this.numFields = -1;
        this.rowNumber = 0;
    }

    public List<List<String>> parse() {
        List<String> row;
        List<List<String>> rows = Lists.list();
        while ((row = this.getRow()) != null) {
            rows.add(row);
        }
        return rows;
    }

    public List<String> getRow() {
        ++this.rowNumber;
        if (this.numFields >= 0) {
            boolean advanced = this.advanceChar('\r');
            advanced |= this.advanceChar('\n');
            if (this.isEof()) {
                return null;
            }
            if (!advanced) {
                char k = this.get();
                if (this.isPrintable(k)) {
                    throw new CsvParseError(Strings.fmt("Unexpected character '%c' (Unicode U+%s) found at row %d.", Character.valueOf(k), Integer.toHexString(k).toUpperCase(Locale.US), this.rowNumber));
                }
                throw new CsvParseError(Strings.fmt("Unexpected character (Unicode U+%s) found at row %d.", Integer.toHexString(k).toUpperCase(Locale.US), this.rowNumber));
            }
        }
        List<String> row = this.readRow();
        if (this.numFields < 0 || this.numFields == row.size()) {
            this.numFields = row.size();
            return row;
        }
        throw new CsvParseError(Strings.fmt("Incorrect number of fields at row %d (%s found, while previous rows have %s).", this.rowNumber, this.fieldNumberText(row.size()), this.fieldNumberText(this.numFields)));
    }

    private String fieldNumberText(int n) {
        return Strings.fmt("%d field%s", n, n == 1 ? "" : "s");
    }

    private List<String> readRow() {
        List<String> row = Lists.list();
        do {
            String s = this.readField();
            row.add(s);
        } while (this.advanceChar(','));
        return row;
    }

    private String readField() {
        if (this.isEof()) {
            return "";
        }
        char k = this.get();
        return k == '\"' ? this.getQuotedField() : this.getUnquotedField();
    }

    private String getQuotedField() {
        Assert.check(this.advanceChar('\"'));
        StringBuilder s = new StringBuilder();
        while (true) {
            if (this.isEof()) {
                throw new CsvParseError("Unexpected EOF while reading a quoted string.");
            }
            char k = this.get();
            if (this.isTextData(k) || k == ',' || k == '\r' || k == '\n') {
                s.append(k);
                this.advance();
                continue;
            }
            if (k != '\"') continue;
            this.advance();
            if (this.isEof()) {
                return s.toString();
            }
            if (!this.advanceChar('\"')) break;
            s.append('\"');
        }
        return s.toString();
    }

    private String getUnquotedField() {
        char k;
        StringBuilder s = new StringBuilder();
        while (!this.isEof() && this.isTextData(k = this.get())) {
            s.append(k);
            this.advance();
        }
        return s.toString();
    }

    private boolean isTextData(char k) {
        return k >= ' ' && k <= '~' && k != '\"' && k != ',';
    }

    private boolean isPrintable(char k) {
        return k >= ' ' && k <= '~';
    }

    private boolean advanceChar(char k) {
        if (!this.isEof() && this.get() == k) {
            this.advance();
            return true;
        }
        return false;
    }

    private char get() {
        Assert.check(!this.isEof());
        Assert.check(this.nextChar >= 0);
        return (char)this.nextChar;
    }

    private void advance() {
        Assert.check(!this.isEof());
        Assert.check(this.nextChar >= 0);
        this.nextChar = -1;
    }

    private boolean isEof() {
        if (this.nextChar >= 0) {
            return false;
        }
        if (this.reader == null) {
            return true;
        }
        try {
            this.nextChar = this.reader.read();
        }
        catch (IOException ex) {
            throw new CsvParseError("CSV read error.", ex);
        }
        if (this.nextChar < 0) {
            this.reader = null;
            return true;
        }
        return false;
    }

    public static class CsvParseError
    extends RuntimeException
    implements EndUserException {
        public CsvParseError(String message) {
            this(message, null);
        }

        public CsvParseError(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

