/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import org.eclipse.escet.common.java.Assert;

public class CloneUtils {
    private CloneUtils() {
    }

    public static <T> T deepclone(Object obj) {
        Object clone;
        if (obj == null) {
            return null;
        }
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            oout.writeObject(obj);
            oout.flush();
            oout.close();
            byte[] data = bout.toByteArray();
            ByteArrayInputStream bin = new ByteArrayInputStream(data);
            ClassLoader classLoader = obj.getClass().getClassLoader();
            MyObjectInputStream oin = new MyObjectInputStream(bin, classLoader);
            clone = oin.readObject();
            oin.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to deep clone object.", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to deep clone object.", e);
        }
        Assert.notNull(clone);
        Object rslt = clone;
        return (T)rslt;
    }

    private static class MyObjectInputStream
    extends ObjectInputStream {
        private final ClassLoader classLoader;

        public MyObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classLoader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            return Class.forName(desc.getName(), false, this.classLoader);
        }
    }
}

