/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.syntax;

import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementVisitor;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class ElementService
extends Element {
    private final Node serviceNode;
    private final Element element;
    private final boolean silent;

    public ElementService(String serviceURI, Element el) {
        this(NodeFactory.createURI(serviceURI), el, false);
    }

    public ElementService(String serviceURI, Element el, boolean silent) {
        this(NodeFactory.createURI(serviceURI), el, silent);
    }

    public ElementService(Node n, Element el, boolean silent) {
        if (!n.isURI() && !n.isVariable()) {
            Log.error(this, "Must be a URI (or variable which will be bound) for a service endpoint");
        }
        this.serviceNode = n;
        this.element = el;
        this.silent = silent;
    }

    public Element getElement() {
        return this.element;
    }

    public Node getServiceNode() {
        return this.serviceNode;
    }

    public boolean getSilent() {
        return this.silent;
    }

    @Override
    public int hashCode() {
        return this.serviceNode.hashCode() ^ this.element.hashCode();
    }

    @Override
    public boolean equalTo(Element el2, NodeIsomorphismMap isoMap) {
        if (!(el2 instanceof ElementService)) {
            return false;
        }
        ElementService service = (ElementService)el2;
        if (!this.serviceNode.equals(service.serviceNode)) {
            return false;
        }
        if (service.getSilent() != this.getSilent()) {
            return false;
        }
        return this.getElement().equalTo(service.getElement(), isoMap);
    }

    @Override
    public void visit(ElementVisitor v) {
        v.visit(this);
    }
}

