/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.util.Objects;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.E_IRI;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction2;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.serializer.SerializationContext;

public class E_IRI2
extends ExprFunction2 {
    private static final String sparqlPrintName = "IRI";
    private static final String sseFunctionName = "iri2";
    protected final String parserBase;
    protected final Expr baseExpr;
    protected final Expr relExpr;

    public E_IRI2(Expr baseExpr, String parserBaseURI, Expr relExpr) {
        this(baseExpr, parserBaseURI, relExpr, sparqlPrintName, sseFunctionName);
    }

    protected E_IRI2(Expr baseExpr, String baseStr, Expr relExpr, String sparqlName, String sseName) {
        super(baseExpr, relExpr, sseName);
        this.parserBase = baseStr;
        this.baseExpr = baseExpr;
        this.relExpr = relExpr;
    }

    @Override
    protected NodeValue evalSpecial(Binding binding, FunctionEnv env) {
        String baseIRI = null;
        if (this.baseExpr != null) {
            NodeValue baseValue = this.baseExpr.eval(binding, env);
            NodeValue baseValueResolved = E_IRI.resolve(baseValue, this.parserBase, env);
            baseIRI = baseValueResolved.getNode().getURI();
        } else {
            baseIRI = this.parserBase;
        }
        NodeValue nvRel = this.relExpr.eval(binding, env);
        return E_IRI.resolve(nvRel, baseIRI, env);
    }

    @Override
    public NodeValue eval(NodeValue v1, NodeValue v2, FunctionEnv env) {
        return E_IRI.resolve(v1, this.parserBase, env);
    }

    @Override
    public Expr copy(Expr expr1, Expr expr2) {
        return new E_IRI2(expr1, this.parserBase, expr2);
    }

    @Override
    public NodeValue eval(NodeValue v1, NodeValue v2) {
        throw new ARQInternalErrorException("Should not be called");
    }

    @Override
    public String getFunctionPrintName(SerializationContext cxt) {
        return sparqlPrintName;
    }

    public String getParserBase() {
        return this.parserBase;
    }

    public Expr getRelExpr() {
        return this.relExpr;
    }

    public Expr getBaseExpr() {
        return this.baseExpr;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.parserBase);
        return result;
    }

    @Override
    public boolean equals(Expr obj, boolean bySyntax) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        E_IRI2 other = (E_IRI2)obj;
        return Objects.equals(this.parserBase, other.parserBase) && Objects.equals(this.baseExpr, other.baseExpr) && Objects.equals(this.relExpr, other.relExpr);
    }
}

