/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.out.quoted;

import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.OutputUtils;
import org.apache.jena.atlas.lib.CharSpace;
import org.apache.jena.atlas.lib.EscapeStr;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.SysRIOT;

public class QuotedURI {
    private final CharSpace charSpace;

    public QuotedURI() {
        this(CharSpace.UTF8);
    }

    public QuotedURI(CharSpace charSpace) {
        this.charSpace = charSpace;
    }

    public void writeURI(AWriter w, String s) {
        w.print('<');
        if (CharSpace.isAscii(this.charSpace)) {
            EscapeStr.writeASCII(w, s);
        } else {
            QuotedURI.systemWriteUnicodeURI(w, s);
        }
        w.print('>');
    }

    private static void systemWriteUnicodeURI(AWriter w, String s) {
        QuotedURI.writeUnicodeEscapeBadChars(w, s);
    }

    static void writeDirect(AWriter out, String uriStr) {
        out.print(uriStr);
    }

    static void writeWarnBadChars(AWriter out, String uriStr) {
        QuotedURI.driverOnBadChars(out, uriStr, QuotedURI::warn);
    }

    static void writeExceptionOnBadChar(AWriter out, String uriStr) {
        QuotedURI.driverOnBadChars(out, uriStr, QuotedURI::error);
    }

    static void writeUnicodeEscapeBadChars(AWriter out, String uriStr) {
        QuotedURI.driverWriteBadChars(out, uriStr, QuotedURI::escapeUnicode);
    }

    static void writePercentEncodedeBadChars(AWriter out, String uriStr) {
        QuotedURI.driverWriteBadChars(out, uriStr, QuotedURI::encodePercent);
    }

    static void writeUnicodeEscapeCtlChars(AWriter out, String uriStr) {
        QuotedURI.driverWriteControlChars(out, uriStr, QuotedURI::escapeUnicode);
    }

    private static void driverOnBadChars(AWriter out, String uriStr, BadCharHandler handler) {
        int len = uriStr.length();
        block3: for (int i = 0; i < len; ++i) {
            char c = uriStr.charAt(i);
            if (QuotedURI.isControlChar(c)) {
                handler.badChar(i, uriStr, c);
                continue;
            }
            switch (c) {
                case ' ': 
                case '\"': 
                case '<': 
                case '>': 
                case '\\': 
                case '^': 
                case '`': 
                case '{': 
                case '|': 
                case '}': 
                case '\u007f': {
                    handler.badChar(i, uriStr, c);
                    continue block3;
                }
            }
        }
        out.print(uriStr);
    }

    private static void driverWriteBadChars(AWriter out, String uriStr, BadCharWriter badCharWriter) {
        int len = uriStr.length();
        block3: for (int i = 0; i < len; ++i) {
            char c = uriStr.charAt(i);
            if (QuotedURI.isControlChar(c)) {
                badCharWriter.writeChar(out, c);
                continue;
            }
            switch (c) {
                case ' ': 
                case '\"': 
                case '<': 
                case '>': 
                case '\\': 
                case '^': 
                case '`': 
                case '{': 
                case '|': 
                case '}': 
                case '\u007f': {
                    badCharWriter.writeChar(out, c);
                    continue block3;
                }
                default: {
                    out.print(c);
                }
            }
        }
    }

    private static void driverWriteControlChars(AWriter out, String uriStr, BadCharWriter escaper) {
        int len = uriStr.length();
        for (int i = 0; i < len; ++i) {
            char c = uriStr.charAt(i);
            if (!QuotedURI.isControlChar(c)) continue;
            escaper.writeChar(out, c);
        }
    }

    private static void escapeUnicode(AWriter out, char c) {
        out.print("\\u");
        OutputUtils.printHex(out, (int)c, 4);
    }

    private static void encodePercent(AWriter out, char c) {
        if (c <= '\u00ff') {
            out.print("%");
            OutputUtils.printHex(out, (int)c, 2);
            return;
        }
        if (c > '\u00ff' && c <= '\uffff') {
            char x = c;
            out.print("%");
            OutputUtils.printHex(out, x >> 8, 2);
            out.print("%");
            OutputUtils.printHex(out, x | 0xFF, 2);
        }
        throw new RiotException("Very bad character! " + Long.toHexString(c));
    }

    private static void warn(int idx, String str2, char ch) {
        String msg = QuotedURI.formattedMessage(idx, str2, ch);
        FmtLog.warn(SysRIOT.getLogger(), msg, new Object[0]);
    }

    private static void error(int idx, String str2, char ch) {
        String msg = QuotedURI.formattedMessage(idx, str2, ch);
        throw new RiotException(msg);
    }

    private static String formattedMessage(int idx, String str2, char ch) {
        String chStr = Character.toString(ch);
        if (ch == ' ') {
            chStr = " ";
        }
        if (ch == '\t') {
            chStr = "\\t";
        }
        if (ch == '\n') {
            chStr = "\\n";
        }
        str2 = QuotedURI.displayUnicodeEscapeControlChars(str2);
        return String.format("Bad character in URI <%s> at position %d: '%s' codepoint U+%04X", str2, idx, chStr, (int)ch);
    }

    private static String displayUnicodeEscapeControlChars(String uriStr) {
        IndentedLineBuffer out = new IndentedLineBuffer();
        QuotedURI.writeDisplayUnicodeControlChars(out, uriStr);
        return out.asString();
    }

    private static void writeDisplayUnicodeControlChars(AWriter out, String uriStr) {
        int len = uriStr.length();
        for (int i = 0; i < len; ++i) {
            char c = uriStr.charAt(i);
            String s = QuotedURI.displayUnicode(c);
            if (s != null) {
                out.print(s);
                continue;
            }
            if (QuotedURI.isControlChar(c)) {
                QuotedURI.displayUnicodeEscape(out, c);
                continue;
            }
            out.print(c);
        }
    }

    private static boolean isControlChar(char c) {
        return c < '\u0014';
    }

    private static String displayUnicode(char c) {
        return switch (c) {
            case '\n' -> "[NL]";
            case '\r' -> "[CR]";
            case '\f' -> "[FF]";
            case ' ' -> "[space]";
            case '\t' -> "[tab]";
            default -> null;
        };
    }

    private static void displayUnicodeEscape(AWriter out, char c) {
        out.print("[U+");
        OutputUtils.printHex(out, (int)c, 4);
        out.print("]");
    }

    @FunctionalInterface
    private static interface BadCharHandler {
        public void badChar(int var1, String var2, char var3);
    }

    @FunctionalInterface
    private static interface BadCharWriter {
        public void writeChar(AWriter var1, char var2);
    }
}

