/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.jdt.dt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.epsilon.common.dt.launching.dialogs.AbstractCachedModelConfigurationDialog;
import org.eclipse.epsilon.emc.jdt.JdtUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class JdtModelConfigurationDialog
extends AbstractCachedModelConfigurationDialog {
    private org.eclipse.swt.widgets.List list;
    private Button selectAll;
    private Button deselectAll;
    private Button bindingSwitch;
    private boolean bindingFlag;

    protected String getModelName() {
        return "Java (JDT) Model";
    }

    protected String getModelType() {
        return "JDT";
    }

    private void createProjectSelectionGroup(Composite parent) {
        Composite groupContent = JdtModelConfigurationDialog.createGroupContainer((Composite)parent, (String)"Projects", (int)1);
        this.getList(groupContent);
        this.createRadioButtonGroup(groupContent);
        groupContent.layout();
    }

    private void createRadioButtonGroup(Composite parent) {
        Composite groupContent = JdtModelConfigurationDialog.createGroupContainer((Composite)parent, (String)"", (int)2);
        this.getSelectButton(groupContent);
        this.getDeSelectButton(groupContent);
        groupContent.layout();
    }

    private void createBidingSwitchGroup(Composite parent) {
        Composite groupContent = JdtModelConfigurationDialog.createGroupContainer((Composite)parent, (String)"Bindings:", (int)2);
        this.getBindingSwitch(groupContent);
        groupContent.layout();
    }

    private org.eclipse.swt.widgets.List getList(Composite groupContent) {
        this.list = new org.eclipse.swt.widgets.List(groupContent, 2562);
        ArrayList<String> projectNameList = new ArrayList<String>();
        List<IJavaProject> javaProjects = this.getJavaProjects();
        for (IJavaProject javaProject : javaProjects) {
            projectNameList.add(javaProject.getProject().getName());
        }
        this.list.setItems(projectNameList.toArray(new String[projectNameList.size()]));
        this.list.setLayoutData((Object)new GridData(768));
        return this.list;
    }

    private Button getSelectButton(Composite groupContent) {
        this.selectAll = new Button(groupContent, 16);
        this.selectAll.setText("Select all");
        this.selectAll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (JdtModelConfigurationDialog.this.selectAll.getSelection()) {
                    JdtModelConfigurationDialog.this.list.selectAll();
                }
            }
        });
        return this.selectAll;
    }

    private Button getDeSelectButton(Composite groupContent) {
        this.deselectAll = new Button(groupContent, 16);
        this.deselectAll.setText("Deselect all");
        this.deselectAll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (JdtModelConfigurationDialog.this.deselectAll.getSelection()) {
                    JdtModelConfigurationDialog.this.list.deselectAll();
                }
            }
        });
        return this.deselectAll;
    }

    private Button getBindingSwitch(Composite groupContent) {
        this.bindingSwitch = new Button(groupContent, 32);
        this.bindingSwitch.setText("Resolve bindings");
        this.bindingSwitch.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (JdtModelConfigurationDialog.this.bindingSwitch.getSelection()) {
                    JdtModelConfigurationDialog.this.bindingFlag = true;
                } else {
                    JdtModelConfigurationDialog.this.bindingFlag = false;
                }
            }
        });
        return this.bindingSwitch;
    }

    private List<IJavaProject> getJavaProjects() {
        List projects = JdtUtil.getIProjects();
        try {
            return JdtUtil.getIJavaProjects((List)projects);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void createGroups(Composite control) {
        this.createNameAliasGroup(control);
        this.createPerformanceGroup(control);
        this.createProjectSelectionGroup(control);
        this.createBidingSwitchGroup(control);
    }

    protected void loadProperties() {
        super.loadProperties();
        if (this.properties == null) {
            return;
        }
        String[] selection = this.properties.getProperty("projects").split(",");
        this.list.setSelection(selection);
        String bindingStr = this.properties.getProperty("resolveBindings");
        if (bindingStr != "") {
            boolean bindingTemp = Boolean.parseBoolean(bindingStr);
            if (bindingTemp) {
                this.bindingFlag = true;
                this.bindingSwitch.setSelection(true);
            } else {
                this.bindingFlag = false;
                this.bindingSwitch.setSelection(false);
            }
        }
    }

    protected void storeProperties() {
        super.storeProperties();
        String projectStr = "";
        String[] stringArray = this.list.getSelection();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            projectStr = projectStr.equals("") ? str : String.valueOf(projectStr) + "," + str;
            ++n2;
        }
        this.properties.put((Object)"projects", (Object)projectStr);
        this.properties.put((Object)"resolveBindings", (Object)this.bindingFlag);
    }
}

