/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.dialogs.merge;

import java.util.concurrent.Callable;
import org.eclipse.emf.emfstore.common.ESObserver;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.AbstractConflictResolver;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.DecisionManager;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.util.DefaultOperationAuthorProvider;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.util.MergeLabelProvider;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.util.OperationAuthorProvider;
import org.eclipse.emf.emfstore.internal.client.ui.common.RunInUI;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.merge.MergeWizard;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.merge.util.DefaultMergeLabelProvider;
import org.eclipse.emf.emfstore.internal.common.ExtensionRegistry;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ChangeConflictSet;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;

public class MergeProjectHandler
extends AbstractConflictResolver {
    private MergeLabelProvider labelProvider;
    private OperationAuthorProvider authorProvider;

    public MergeProjectHandler(boolean isBranchMerge) {
        super(isBranchMerge);
    }

    protected void preDecisionManagerHook() {
        this.labelProvider = this.getLabelProvider();
        ESWorkspaceProviderImpl.getObserverBus().register((ESObserver)this.labelProvider, new Class[]{MergeLabelProvider.class});
    }

    protected void postDecisionManagerHook() {
        if (this.labelProvider != null) {
            ESWorkspaceProviderImpl.getObserverBus().unregister((ESObserver)this.labelProvider, new Class[]{MergeLabelProvider.class});
        }
        if (this.authorProvider != null) {
            ESWorkspaceProviderImpl.getObserverBus().unregister((ESObserver)this.authorProvider, new Class[]{OperationAuthorProvider.class});
        }
    }

    protected boolean controlDecisionManager(final DecisionManager decisionManager, ChangeConflictSet changeConflictSet) {
        this.authorProvider = new DefaultOperationAuthorProvider(changeConflictSet.getLeftChanges(), changeConflictSet.getRightChanges());
        ESWorkspaceProviderImpl.getObserverBus().register((ESObserver)this.authorProvider, new Class[]{OperationAuthorProvider.class});
        return RunInUI.runWithResult(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                MergeWizard wizard = new MergeWizard(decisionManager);
                WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
                dialog.setPageSize(1000, 400);
                dialog.setBlockOnOpen(true);
                dialog.create();
                int open = dialog.open();
                MergeProjectHandler.this.getLabelProvider().dispose();
                if (open == 0) {
                    return true;
                }
                return false;
            }
        });
    }

    private MergeLabelProvider getLabelProvider() {
        return (MergeLabelProvider)ExtensionRegistry.INSTANCE.get("org.eclipse.emf.emfstore.client.mergeLabelProvider", MergeLabelProvider.class, (Object)new DefaultMergeLabelProvider(), true);
    }
}

