/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.AdminEmfStore;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.AuthorizationControl;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.PAPrivileges;
import org.eclipse.emf.emfstore.internal.server.core.AbstractEmfstoreInterface;
import org.eclipse.emf.emfstore.internal.server.core.Messages;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.exceptions.InvalidInputException;
import org.eclipse.emf.emfstore.internal.server.exceptions.StorageException;
import org.eclipse.emf.emfstore.internal.server.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.server.model.ProjectHistory;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.internal.server.model.ServerSpace;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACGroup;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnitId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.AccesscontrolFactory;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.Role;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.RolesFactory;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.RolesPackage;
import org.eclipse.emf.emfstore.internal.server.model.dao.ACDAOFacade;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminEmfStoreImpl
extends AbstractEmfstoreInterface
implements AdminEmfStore {
    private final ACDAOFacade daoFacade;

    public AdminEmfStoreImpl(ACDAOFacade daoFacade, ServerSpace serverSpace, AuthorizationControl authorizationControl) throws FatalESException {
        super(serverSpace, authorizationControl);
        this.daoFacade = daoFacade;
    }

    @Override
    public List<ACGroup> getGroups(SessionId sessionId) throws ESException {
        this.checkForNulls(sessionId);
        this.getAuthorizationControl().checkProjectAdminAccess(sessionId, null);
        ArrayList<ACGroup> result = new ArrayList<ACGroup>();
        for (ACGroup group : this.daoFacade.getGroups()) {
            ACGroup copy = (ACGroup)ModelUtil.clone((EObject)group);
            this.clearMembersFromGroup((ACOrgUnit)copy);
            result.add(copy);
        }
        return result;
    }

    @Override
    public List<ACGroup> getGroups(SessionId sessionId, ACOrgUnitId orgUnitId) throws ESException {
        this.checkForNulls(sessionId, orgUnitId);
        this.getAuthorizationControl().checkProjectAdminAccess(sessionId, null);
        ArrayList<ACGroup> result = new ArrayList<ACGroup>();
        ACOrgUnit orgUnit = this.getOrgUnit(orgUnitId);
        for (ACGroup group : this.daoFacade.getGroups()) {
            if (!group.getMembers().contains((Object)orgUnit)) continue;
            ACGroup copy = (ACGroup)ModelUtil.clone((EObject)group);
            this.clearMembersFromGroup((ACOrgUnit)copy);
            result.add(copy);
        }
        return result;
    }

    @Override
    public ACOrgUnitId createGroup(SessionId sessionId, String name) throws ESException {
        this.checkForNulls(sessionId, name);
        this.getAuthorizationControl().checkProjectAdminAccess(sessionId, null, PAPrivileges.CreateGroup);
        if (this.groupExists(name)) {
            throw new InvalidInputException(Messages.AdminEmfStoreImpl_Group_Already_Exists);
        }
        ACGroup acGroup = AccesscontrolFactory.eINSTANCE.createACGroup();
        acGroup.setName(name);
        acGroup.setDescription("");
        this.daoFacade.add(acGroup);
        this.save();
        return (ACOrgUnitId)ModelUtil.clone((EObject)acGroup.getId());
    }

    private boolean groupExists(String name) {
        for (ACGroup group : this.daoFacade.getGroups()) {
            if (!group.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeGroup(SessionId sessionId, ACOrgUnitId user, ACOrgUnitId group) throws ESException {
        this.checkForNulls(sessionId, user, group);
        boolean isServerAdmin = this.getAuthorizationControl().checkProjectAdminAccess(sessionId, null, PAPrivileges.DeleteOrgUnit);
        if (!isServerAdmin) {
            this.getAuthorizationControl().checkProjectAdminAccessForOrgUnit(sessionId, group);
        }
        this.getGroup(group).getMembers().remove((Object)this.getOrgUnit(user));
        this.save();
    }

    @Override
    public void deleteGroup(SessionId sessionId, ACOrgUnitId groupId) throws ESException {
        this.checkForNulls(sessionId, groupId);
        this.getAuthorizationControl().checkProjectAdminAccess(sessionId, null, PAPrivileges.DeleteOrgUnit);
        this.getAuthorizationControl().checkProjectAdminAccessForOrgUnit(sessionId, groupId);
        ACGroup group = this.getGroup(groupId);
        for (ACOrgUnit member : group.getMembers()) {
            this.getAuthorizationControl().checkProjectAdminAccessForOrgUnit(sessionId, member.getId());
        }
        for (ACGroup nextGroup : this.daoFacade.getGroups()) {
            List<ACGroup> groups = this.getGroups(sessionId, groupId);
            if (!nextGroup.getId().equals(groupId)) continue;
            for (ACGroup acGroup : groups) {
                this.removeMember(sessionId, acGroup.getId(), nextGroup.getId());
            }
            this.daoFacade.remove(nextGroup);
            EcoreUtil.delete((EObject)nextGroup);
            this.save();
            return;
        }
    }

    @Override
    public List<ACOrgUnit> getMembers(SessionId sessionId, ACOrgUnitId groupId) throws ESException {
        this.checkForNulls(sessionId, groupId);
        this.getAuthorizationControl().checkProjectAdminAccess(sessionId, null);
        ArrayList<ACOrgUnit> result = new ArrayList<ACOrgUnit>();
        for (ACOrgUnit orgUnit : this.getGroup(groupId).getMembers()) {
            result.add((ACOrgUnit)ModelUtil.clone((EObject)orgUnit));
        }
        this.clearMembersFromGroups(result);
        return result;
    }

    @Override
    public void addMember(SessionId sessionId, ACOrgUnitId group, ACOrgUnitId member) throws ESException {
        this.checkForNulls(sessionId, group, member);
        boolean isServerAdmin = this.getAuthorizationControl().checkProjectAdminAccess(sessionId, null, PAPrivileges.ChangeAssignmentsOfOrgUnits);
        if (!isServerAdmin) {
            this.getAuthorizationControl().checkProjectAdminAccessForOrgUnit(sessionId, group);
        }
        this.addToGroup(group, member);
    }

    private void addToGroup(ACOrgUnitId group, ACOrgUnitId member) throws ESException {
        ACGroup acGroup = this.getGroup(group);
        ACOrgUnit acMember = this.getOrgUnit(member);
        acGroup.getMembers().add((Object)acMember);
        this.save();
    }

    @Override
    public void removeMember(SessionId sessionId, ACOrgUnitId group, ACOrgUnitId member) throws ESException {
        this.checkForNulls(sessionId, group, member);
        boolean isServerAdmin = this.getAuthorizationControl().checkProjectAdminAccess(sessionId, null, PAPrivileges.ChangeAssignmentsOfOrgUnits);
        if (!isServerAdmin) {
            this.getAuthorizationControl().checkProjectAdminAccessForOrgUnit(sessionId, group);
        }
        this.removeFromGroup(group, member);
    }

    private void removeFromGroup(ACOrgUnitId group, ACOrgUnitId member) throws ESException {
        ACGroup acGroup = this.getGroup(group);
        ACOrgUnit acMember = this.getOrgUnit(member);
        if (acGroup.getMembers().contains((Object)acMember)) {
            acGroup.getMembers().remove((Object)acMember);
            this.save();
        }
    }

    @Override
    public List<ACOrgUnit> getParticipants(SessionId sessionId, ProjectId projectId) throws ESException {
        this.checkForNulls(sessionId);
        this.getAuthorizationControl().checkProjectAdminAccess(sessionId, projectId);
        ArrayList<ACOrgUnit> result = new ArrayList<ACOrgUnit>();
        for (ACOrgUnit orgUnit : this.daoFacade.getUsers()) {
            for (Role role : orgUnit.getRoles()) {
                if (!this.isServerAdmin(role) && !role.getProjects().contains((Object)projectId)) continue;
                result.add((ACOrgUnit)ModelUtil.clone((EObject)orgUnit));
            }
        }
        for (ACOrgUnit orgUnit : this.daoFacade.getGroups()) {
            for (Role role : orgUnit.getRoles()) {
                if (!this.isServerAdmin(role) && !role.getProjects().contains((Object)projectId)) continue;
                result.add((ACOrgUnit)ModelUtil.clone((EObject)orgUnit));
            }
        }
        this.clearMembersFromGroups(result);
        return result;
    }

    @Override
    public void addParticipant(SessionId sessionId, ProjectId projectId, ACOrgUnitId participantId, EClass roleClass) throws ESException {
        this.checkForNulls(sessionId, projectId, participantId, roleClass);
        boolean isServerAdmin = this.getAuthorizationControl().checkProjectAdminAccess(sessionId, projectId, PAPrivileges.AssignRoleToOrgUnit);
        if (!isServerAdmin && roleClass.equals(RolesPackage.eINSTANCE.getServerAdmin())) {
            throw new AccessControlException(Messages.AdminEmfStoreImpl_Not_Allowed_To_Create_Participant_With_ServerAdminRole);
        }
        projectId = this.getProjectId(projectId);
        ACOrgUnit orgUnit = this.getOrgUnit(participantId);
        for (Role role : orgUnit.getRoles()) {
            if (!role.getProjects().contains((Object)projectId)) continue;
            return;
        }
        for (Role role : orgUnit.getRoles()) {
            if (!this.areEqual(role, roleClass)) continue;
            role.getProjects().add((Object)((ProjectId)ModelUtil.clone((EObject)projectId)));
            this.save();
            return;
        }
        Role newRole = (Role)RolesPackage.eINSTANCE.getEFactoryInstance().create((EClass)RolesPackage.eINSTANCE.getEClassifier(roleClass.getName()));
        newRole.getProjects().add((Object)((ProjectId)ModelUtil.clone((EObject)projectId)));
        orgUnit.getRoles().add((Object)newRole);
        this.save();
    }

    @Override
    public void addInitialParticipant(SessionId sessionId, ProjectId projectId, ACOrgUnitId participantId, EClass roleClass) throws ESException {
        this.checkForNulls(sessionId, projectId, participantId, roleClass);
        projectId = this.getProjectId(projectId);
        ACOrgUnit orgUnit = this.getOrgUnit(participantId);
        Role newRole = (Role)RolesPackage.eINSTANCE.getEFactoryInstance().create((EClass)RolesPackage.eINSTANCE.getEClassifier(roleClass.getName()));
        for (Role role : orgUnit.getRoles()) {
            if (!this.isServerAdmin(role)) continue;
            return;
        }
        for (Role role : orgUnit.getRoles()) {
            if (!this.areEqual(role, roleClass)) continue;
            role.getProjects().add((Object)((ProjectId)ModelUtil.clone((EObject)projectId)));
            this.save();
            return;
        }
        newRole.getProjects().add((Object)((ProjectId)ModelUtil.clone((EObject)projectId)));
        orgUnit.getRoles().add((Object)newRole);
        this.save();
    }

    private ProjectId getProjectId(ProjectId projectId) throws ESException {
        for (ProjectHistory projectHistory : this.getServerSpace().getProjects()) {
            if (!projectHistory.getProjectId().equals(projectId)) continue;
            return projectHistory.getProjectId();
        }
        throw new ESException(Messages.AdminEmfStoreImpl_Unknown_ProjectID);
    }

    @Override
    public void removeParticipant(SessionId sessionId, ProjectId projectId, ACOrgUnitId participantId) throws ESException {
        this.checkForNulls(sessionId, projectId, participantId);
        boolean isServerAdmin = this.getAuthorizationControl().checkProjectAdminAccess(sessionId, projectId, PAPrivileges.AssignRoleToOrgUnit);
        ACOrgUnit orgUnit = this.getOrgUnit(participantId);
        projectId = this.getProjectId(projectId);
        for (Role role : orgUnit.getRoles()) {
            if (!role.getProjects().contains((Object)projectId)) continue;
            if (!isServerAdmin && role.canAdministrate(projectId)) {
                throw new AccessControlException(String.valueOf(Messages.AdminEmfStoreImpl_RemovePA_Violation_1) + Messages.AdminEmfStoreImpl_RemovePA_Violation_2);
            }
            role.getProjects().remove((Object)projectId);
            this.save();
            return;
        }
    }

    @Override
    public Role getRole(SessionId sessionId, ProjectId projectId, ACOrgUnitId orgUnitId) throws ESException {
        this.checkForNulls(sessionId, projectId, orgUnitId);
        this.getAuthorizationControl().checkProjectAdminAccess(sessionId, projectId);
        projectId = this.getProjectId(projectId);
        ACOrgUnit oUnit = this.getOrgUnit(orgUnitId);
        for (Role role : oUnit.getRoles()) {
            if (!this.isServerAdmin(role) && !role.getProjects().contains((Object)projectId)) continue;
            return role;
        }
        throw new ESException(Messages.AdminEmfStoreImpl_Could_Not_Find_OrgUnit);
    }

    @Override
    public void changeRole(SessionId sessionId, ProjectId projectId, ACOrgUnitId orgUnitId, EClass roleClass) throws ESException {
        ACOrgUnit orgUnit;
        this.checkForNulls(sessionId, projectId, orgUnitId, roleClass);
        this.getAuthorizationControl().checkProjectAdminAccess(sessionId, projectId);
        boolean isServerAdmin = this.getAuthorizationControl().checkProjectAdminAccessForOrgUnit(sessionId, orgUnitId, Collections.singleton(projectId));
        if (!ServerConfiguration.isProjectAdminPrivileg(PAPrivileges.AssignRoleToOrgUnit)) {
            throw new AccessControlException(Messages.AdminEmfStoreImpl_Assign_Role_Privilege_Not_Set);
        }
        if (!isServerAdmin && this.isServerAdminRole(roleClass)) {
            throw new AccessControlException(Messages.AdminEmfStoreImpl_Not_Allowed_To_Assign_ServerAdminRole);
        }
        Role role = this.getRole(projectId = this.getProjectId(projectId), orgUnit = this.getOrgUnit(orgUnitId));
        if (role != null) {
            if (!isServerAdmin && role.canAdministrate(projectId)) {
                throw new AccessControlException(String.valueOf(Messages.AdminEmfStoreImpl_RemovePA_Violation_1) + Messages.AdminEmfStoreImpl_RemovePA_Violation_2);
            }
            role.getProjects().remove((Object)projectId);
            if (role.getProjects().size() == 0) {
                orgUnit.getRoles().remove((Object)role);
            }
        }
        if (this.isServerAdminRole(roleClass)) {
            orgUnit.getRoles().add((Object)RolesFactory.eINSTANCE.createServerAdmin());
            this.save();
            return;
        }
        for (Role r : orgUnit.getRoles()) {
            if (!r.eClass().getName().equals(roleClass.getName())) continue;
            r.getProjects().add((Object)((ProjectId)ModelUtil.clone((EObject)projectId)));
            this.save();
            return;
        }
        Role newRole = (Role)RolesPackage.eINSTANCE.getEFactoryInstance().create((EClass)RolesPackage.eINSTANCE.getEClassifier(roleClass.getName()));
        newRole.getProjects().add((Object)((ProjectId)ModelUtil.clone((EObject)projectId)));
        orgUnit.getRoles().add((Object)newRole);
        this.save();
    }

    @Override
    public void assignRole(SessionId sessionId, ACOrgUnitId orgUnitId, EClass roleClass) throws ESException {
        this.checkForNulls(sessionId, orgUnitId, roleClass);
        this.getAuthorizationControl().checkProjectAdminAccess(sessionId, null, PAPrivileges.AssignRoleToOrgUnit);
        boolean isServerAdmin = this.getAuthorizationControl().checkProjectAdminAccessForOrgUnit(sessionId, orgUnitId);
        if (!isServerAdmin && this.isServerAdminRole(roleClass)) {
            throw new AccessControlException("A project admin is not allowed to assign a server admin role");
        }
        ACOrgUnit orgUnit = this.getOrgUnit(orgUnitId);
        for (Role role : orgUnit.getRoles()) {
            if (!this.areEqual(role, roleClass)) continue;
            return;
        }
        Role newRole = (Role)RolesPackage.eINSTANCE.getEFactoryInstance().create((EClass)RolesPackage.eINSTANCE.getEClassifier(roleClass.getName()));
        orgUnit.getRoles().add((Object)newRole);
        this.save();
    }

    @Override
    public List<ACUser> getUsers(SessionId sessionId) throws ESException {
        this.checkForNulls(sessionId);
        this.getAuthorizationControl().checkProjectAdminAccess(sessionId, null);
        ArrayList<ACUser> result = new ArrayList<ACUser>();
        for (ACUser user : this.daoFacade.getUsers()) {
            result.add(user);
        }
        return result;
    }

    @Override
    public List<ACOrgUnit> getOrgUnits(SessionId sessionId) throws ESException {
        this.checkForNulls(sessionId);
        this.getAuthorizationControl().checkProjectAdminAccess(sessionId, null);
        ArrayList<ACOrgUnit> result = new ArrayList<ACOrgUnit>();
        for (ACOrgUnit user : this.daoFacade.getUsers()) {
            result.add((ACOrgUnit)ModelUtil.clone((EObject)user));
        }
        for (ACOrgUnit group : this.daoFacade.getGroups()) {
            result.add((ACOrgUnit)ModelUtil.clone((EObject)group));
        }
        this.clearMembersFromGroups(result);
        return result;
    }

    @Override
    public List<ProjectInfo> getProjectInfos(SessionId sessionId) throws ESException {
        this.checkForNulls(sessionId);
        ArrayList<ProjectInfo> result = new ArrayList<ProjectInfo>();
        for (ProjectHistory projectHistory : this.getServerSpace().getProjects()) {
            try {
                this.getAuthorizationControl().checkProjectAdminAccess(sessionId, projectHistory.getProjectId());
                result.add(this.getProjectInfo(projectHistory));
            }
            catch (AccessControlException accessControlException) {}
        }
        return result;
    }

    @Override
    public ACOrgUnitId createUser(SessionId sessionId, String name) throws ESException {
        this.checkForNulls(sessionId, name);
        this.getAuthorizationControl().checkProjectAdminAccess(sessionId, null, PAPrivileges.CreateUser);
        if (this.userExists(name)) {
            throw new InvalidInputException("Username '" + name + "' already exists.");
        }
        ACUser acUser = AccesscontrolFactory.eINSTANCE.createACUser();
        acUser.setName(name);
        acUser.setDescription("");
        this.daoFacade.add(acUser);
        this.save();
        return (ACOrgUnitId)ModelUtil.clone((EObject)acUser.getId());
    }

    private boolean userExists(String name) {
        for (ACUser user : this.daoFacade.getUsers()) {
            if (!user.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void deleteUser(SessionId sessionId, ACOrgUnitId userId) throws ESException {
        this.checkForNulls(sessionId, userId);
        this.getAuthorizationControl().checkProjectAdminAccessForOrgUnit(sessionId, userId);
        this.getAuthorizationControl().checkProjectAdminAccess(sessionId, null, PAPrivileges.DeleteOrgUnit);
        for (ACUser user : this.daoFacade.getUsers()) {
            List<ACGroup> groups = this.getGroups(sessionId, userId);
            if (!user.getId().equals(userId)) continue;
            for (ACGroup acGroup : groups) {
                this.removeMember(sessionId, acGroup.getId(), userId);
            }
            this.daoFacade.remove(user);
            EcoreUtil.delete((EObject)user);
            this.save();
            return;
        }
    }

    @Override
    public void changeOrgUnit(SessionId sessionId, ACOrgUnitId orgUnitId, String name, String description) throws ESException {
        this.checkForNulls(sessionId, orgUnitId, name, description);
        this.getAuthorizationControl().checkProjectAdminAccessForOrgUnit(sessionId, orgUnitId);
        ACOrgUnit orgUnit = this.getOrgUnit(orgUnitId);
        orgUnit.setName(name);
        orgUnit.setDescription(description);
        this.save();
    }

    @Override
    public void changeUser(SessionId sessionId, ACOrgUnitId userId, String name, String password) throws ESException {
        this.checkForNulls(sessionId, userId, name, password);
        boolean isServerAdmin = this.getAuthorizationControl().checkProjectAdminAccess(sessionId, null, PAPrivileges.ChangeUserPassword);
        if (!isServerAdmin) {
            this.getAuthorizationControl().checkProjectAdminAccessForOrgUnit(sessionId, userId);
        }
        this.updateUser(userId, name, password);
    }

    private void updateUser(ACOrgUnitId userId, String name, String password) throws ESException {
        ACUser user = (ACUser)this.getOrgUnit(userId);
        user.setName(name);
        user.setPassword(password);
        this.save();
    }

    @Override
    public ACOrgUnit getOrgUnit(SessionId sessionId, ACOrgUnitId orgUnitId) throws ESException {
        this.checkForNulls(sessionId, orgUnitId);
        this.getAuthorizationControl().checkProjectAdminAccess(sessionId, null);
        ACOrgUnit orgUnit = (ACOrgUnit)ModelUtil.clone((EObject)this.getOrgUnit(orgUnitId));
        this.clearMembersFromGroup(orgUnit);
        return orgUnit;
    }

    private void clearMembersFromGroups(Collection<ACOrgUnit> orgUnits) {
        for (ACOrgUnit orgUnit : orgUnits) {
            this.clearMembersFromGroup(orgUnit);
        }
    }

    private void clearMembersFromGroup(ACOrgUnit orgUnit) {
        if (orgUnit instanceof ACGroup) {
            ((ACGroup)orgUnit).getMembers().clear();
        }
    }

    private boolean isServerAdmin(Role role) {
        return role.eClass().getName().equals(RolesPackage.Literals.SERVER_ADMIN.getName());
    }

    private boolean isServerAdminRole(EClass role) {
        return role.getName().equals(RolesPackage.Literals.SERVER_ADMIN.getName());
    }

    private boolean areEqual(Role role, EClass roleClass) {
        return role.eClass().getName().equals(roleClass.getName());
    }

    private ProjectInfo getProjectInfo(ProjectHistory project) {
        ProjectInfo info = ModelFactory.eINSTANCE.createProjectInfo();
        info.setName(project.getProjectName());
        info.setDescription(project.getProjectDescription());
        info.setProjectId((ProjectId)ModelUtil.clone((EObject)project.getProjectId()));
        info.setVersion(project.getLastVersion().getPrimarySpec());
        return info;
    }

    private ACGroup getGroup(ACOrgUnitId orgUnitId) throws ESException {
        for (ACGroup group : this.daoFacade.getGroups()) {
            if (!group.getId().equals(orgUnitId)) continue;
            return group;
        }
        throw new ESException(Messages.AdminEmfStoreImpl_Group_Does_Not_Exist);
    }

    private ACOrgUnit getOrgUnit(ACOrgUnitId orgUnitId) throws ESException {
        for (ACOrgUnit unit : this.daoFacade.getUsers()) {
            if (!unit.getId().equals(orgUnitId)) continue;
            return unit;
        }
        for (ACOrgUnit unit : this.daoFacade.getGroups()) {
            if (!unit.getId().equals(orgUnitId)) continue;
            return unit;
        }
        throw new ESException(Messages.AdminEmfStoreImpl_OrgUnit_Does_Not_Exist);
    }

    private Role getRole(ProjectId projectId, ACOrgUnit orgUnit) {
        for (Role role : orgUnit.getRoles()) {
            if (!this.isServerAdmin(role) && !role.getProjects().contains((Object)projectId)) continue;
            return role;
        }
        return null;
    }

    private void save() throws ESException {
        try {
            this.daoFacade.save();
        }
        catch (IOException e) {
            throw new StorageException("Couldn't save data in database.", e);
        }
        catch (NullPointerException e) {
            throw new StorageException("Couldn't save data in database.", e);
        }
    }

    private void checkForNulls(Object ... objects) throws InvalidInputException {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj == null) {
                throw new InvalidInputException();
            }
            ++n2;
        }
    }

    @Override
    protected void initSubInterfaces() throws FatalESException {
    }
}

