/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.fuzzy.emf;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.emfstore.fuzzy.Util;
import org.eclipse.emf.emfstore.fuzzy.emf.EMFDataProvider;
import org.eclipse.emf.emfstore.fuzzy.emf.FuzzyUtil;
import org.eclipse.emf.emfstore.fuzzy.emf.Messages;
import org.eclipse.emf.emfstore.internal.modelmutator.api.ModelMutator;
import org.eclipse.emf.emfstore.internal.modelmutator.api.ModelMutatorConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutateUtil
implements Util {
    private final EMFDataProvider dataProvider;

    public MutateUtil(EMFDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public Collection<EPackage> getEPackages() {
        return this.dataProvider.getEPackages();
    }

    public int getMinObjectsCount() {
        return this.dataProvider.getModelMutatorConfiguration().getMinObjectsCount();
    }

    public long getSeed() {
        return this.dataProvider.getSeed();
    }

    public int getSeedCount() {
        return this.dataProvider.getCurrentSeedCount();
    }

    public Collection<EClass> getEClassesToIgnore() {
        return this.dataProvider.getModelMutatorConfiguration().geteClassesToIgnore();
    }

    public Collection<EStructuralFeature> getEStructuralFeaturesToIgnore() {
        return this.dataProvider.getModelMutatorConfiguration().geteStructuralFeaturesToIgnore();
    }

    public void mutate(ModelMutatorConfiguration mmc) {
        ModelMutator.changeModel((ModelMutatorConfiguration)mmc, new LinkedHashSet<EStructuralFeature>(this.getEStructuralFeaturesToIgnore()));
    }

    public void saveEObject(EObject obj) {
        this.saveEObject(obj, null, true);
    }

    public void saveEObject(EObject obj, String suffix, boolean discardDanglingHREF) {
        Resource resource = FuzzyUtil.createResource(this.getRunResourcePath(suffix));
        resource.getContents().add((Object)obj);
        try {
            HashMap<String, String> options = new HashMap<String, String>();
            if (discardDanglingHREF) {
                options.put("PROCESS_DANGLING_HREF", "DISCARD");
            }
            resource.save(options);
        }
        catch (IOException e) {
            throw new RuntimeException(String.valueOf(Messages.MutateUtil_SaveFailed) + obj, e);
        }
    }

    public String getRunResourcePath(String suffix) {
        String toAdd = suffix == null || "".equals(suffix) ? "" : "_" + suffix;
        return "../fuzzy/testruns/" + this.dataProvider.getConfig().getId() + "/" + this.dataProvider.getCurrentSeedCount() + toAdd + ".xml";
    }

    public URI getRunResourceURI(String suffix) {
        return URI.createFileURI((String)this.getRunResourcePath(suffix));
    }

    protected EMFDataProvider getDataProvider() {
        return this.dataProvider;
    }
}

