/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.startup;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.emf.emfstore.internal.common.model.util.FileUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.startup.ServerSpaceRule;
import org.eclipse.emf.emfstore.internal.server.startup.UpdateXMIAttributeRule;
import org.eclipse.emf.emfstore.internal.server.startup.VersionMultiRule;
import org.eclipse.emf.emfstore.internal.server.startup.VersionRule;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ServerHrefMigrator {
    private File backup;

    public boolean migrate() {
        String sEMFStoreServer = ServerConfiguration.getServerHome();
        if (this.isMigrationNeeded(String.valueOf(sEMFStoreServer) + "storage.uss")) {
            if (this.backup != null) {
                return false;
            }
            try {
                this.backup = this.createBackup(ServerConfiguration.getServerHome(), String.valueOf(ServerConfiguration.getServerHome()) + "../backup" + System.currentTimeMillis());
            }
            catch (IOException ex) {
                ModelUtil.logException((String)"Error during the backup creation.", (Throwable)ex);
                return false;
            }
            try {
                this.doMigrate(sEMFStoreServer);
                return true;
            }
            catch (InvocationTargetException ex) {
                ModelUtil.logException((String)"Error during the migration process.", (Throwable)ex);
                return false;
            }
        }
        return true;
    }

    private boolean isMigrationNeeded(String pathToServerSpace) {
        String toMatch;
        block7: {
            toMatch = this.getProjectAttribute(pathToServerSpace);
            if (toMatch != null) break block7;
            return false;
        }
        try {
            return toMatch.contains("projectHistory.uph");
        }
        catch (ParserConfigurationException ex) {
            ModelUtil.logException((String)"Cannot determine whether migration is needed. Migration will be skipped, backup will be created.", (Throwable)ex);
        }
        catch (SAXException ex) {
            ModelUtil.logException((String)"Cannot determine whether migration is needed. Migration will be skipped, backup will be created.", (Throwable)ex);
        }
        catch (IOException ex) {
            ModelUtil.logException((String)"Cannot determine whether migration is needed. Migration will be skipped, backup will be created.", (Throwable)ex);
        }
        try {
            this.backup = this.createBackup(ServerConfiguration.getServerHome(), String.valueOf(ServerConfiguration.getServerHome()) + "../backup" + System.currentTimeMillis());
        }
        catch (IOException ex) {
            this.backup = new File("");
            ModelUtil.logException((String)"Creating the backup failed.", (Throwable)ex);
        }
        return true;
    }

    protected File createBackup(String from, String to) throws IOException {
        File sourceFile = new File(from);
        File backupFile = new File(to);
        FileUtil.copyDirectory((File)sourceFile, (File)backupFile);
        return backupFile;
    }

    private void doMigrate(String sEMFStoreServer) throws InvocationTargetException {
        File[] projects;
        this.migrateNonContainment(String.valueOf(sEMFStoreServer) + "storage.uss", "projects", new ServerSpaceRule());
        File fEMFStoreServer = new File(sEMFStoreServer);
        File[] fileArray = projects = fEMFStoreServer.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("project-");
            }
        });
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            File[] versions;
            File f = fileArray[n2];
            String pH = String.valueOf(f.getAbsolutePath()) + "/projectHistory.uph";
            this.migrateContainmentHRefs(pH, "versions", new VersionRule());
            File[] fileArray2 = versions = f.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith("version-");
                }
            });
            int n3 = versions.length;
            int n4 = 0;
            while (n4 < n3) {
                File v = fileArray2[n4];
                String versionPath = v.getAbsolutePath();
                this.migrateNonContainment(versionPath, "nextVersion", new VersionMultiRule());
                this.migrateNonContainment(versionPath, "previousVersion", new VersionMultiRule());
                this.migrateNonContainment(versionPath, "ancestorVersion", new VersionMultiRule());
                this.migrateNonContainment(versionPath, "branchedVersions", new VersionMultiRule());
                this.migrateNonContainment(versionPath, "mergedToVersion", new VersionMultiRule());
                this.migrateNonContainment(versionPath, "mergedFromVersion", new VersionMultiRule());
                ++n4;
            }
            ++n2;
        }
    }

    private String getProjectAttribute(String pathToFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(pathToFile);
        Node serverSpace = doc.getFirstChild();
        NamedNodeMap attr = serverSpace.getAttributes();
        Node nodeAttr = attr.getNamedItem("projects");
        if (nodeAttr == null) {
            return null;
        }
        String projectsOld = nodeAttr.getTextContent();
        String[] projects = projectsOld.split(" ");
        if (projects.length < 1) {
            return null;
        }
        return projects[0];
    }

    protected void migrateContainmentHRefs(String pathToFile, String tagName, UpdateXMIAttributeRule rule) throws InvocationTargetException {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(pathToFile);
            NodeList tagElements = doc.getElementsByTagName(tagName);
            int i = 0;
            while (i < tagElements.getLength()) {
                Node pS = tagElements.item(i);
                NamedNodeMap attr = pS.getAttributes();
                Node nodeAttr = attr.getNamedItem("href");
                String hrefOld = nodeAttr.getTextContent();
                String hrefNew = rule.getNewAttribute(hrefOld);
                nodeAttr.setTextContent(hrefNew);
                ++i;
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(pathToFile));
            transformer.transform(source, result);
        }
        catch (DOMException ex) {
            throw new InvocationTargetException(ex);
        }
        catch (TransformerConfigurationException ex) {
            throw new InvocationTargetException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new InvocationTargetException(ex);
        }
        catch (SAXException ex) {
            throw new InvocationTargetException(ex);
        }
        catch (IOException ex) {
            throw new InvocationTargetException(ex);
        }
        catch (TransformerFactoryConfigurationError ex) {
            throw new InvocationTargetException(ex);
        }
        catch (TransformerException ex) {
            throw new InvocationTargetException(ex);
        }
    }

    protected void migrateNonContainment(String pathToFile, String tagName, UpdateXMIAttributeRule rule) throws InvocationTargetException {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(pathToFile);
            Node serverSpace = doc.getFirstChild();
            NamedNodeMap attr = serverSpace.getAttributes();
            Node nodeAttr = attr.getNamedItem(tagName);
            if (nodeAttr == null) {
                return;
            }
            String attributeOld = nodeAttr.getTextContent();
            String attributeNew = rule.getNewAttribute(attributeOld);
            nodeAttr.setTextContent(attributeNew);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(pathToFile));
            transformer.transform(source, result);
        }
        catch (DOMException ex) {
            throw new InvocationTargetException(ex);
        }
        catch (TransformerConfigurationException ex) {
            throw new InvocationTargetException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new InvocationTargetException(ex);
        }
        catch (SAXException ex) {
            throw new InvocationTargetException(ex);
        }
        catch (IOException ex) {
            throw new InvocationTargetException(ex);
        }
        catch (TransformerFactoryConfigurationError ex) {
            throw new InvocationTargetException(ex);
        }
        catch (TransformerException ex) {
            throw new InvocationTargetException(ex);
        }
    }
}

