/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.changeTracking.commands;

import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.emfstore.client.changetracking.ESCommandObserver;
import org.eclipse.emf.emfstore.common.ESObserver;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.commands.Messages;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.common.observer.ObserverCall;

public class EMFStoreCommandNotifier {
    public void notifiyListenersAboutStart(Command startedCommand) {
        ESCommandObserver commandObserver = (ESCommandObserver)ESWorkspaceProviderImpl.getObserverBus().notify(ESCommandObserver.class);
        commandObserver.commandStarted(startedCommand);
        this.logExceptions(commandObserver);
    }

    public void notifiyListenersAboutCommandFailed(Command command, Exception exception) {
        ESCommandObserver commandObserver = (ESCommandObserver)ESWorkspaceProviderImpl.getObserverBus().notify(ESCommandObserver.class);
        commandObserver.commandFailed(command, exception);
        this.logExceptions(commandObserver);
    }

    public void notifiyListenersAboutCommandCompleted(Command completedCommand) {
        ESCommandObserver commandObserver = (ESCommandObserver)ESWorkspaceProviderImpl.getObserverBus().notify(ESCommandObserver.class);
        commandObserver.commandCompleted(completedCommand);
        this.logExceptions(commandObserver);
    }

    private void logExceptions(ESCommandObserver commandObserver) {
        ObserverCall observerCall = (ObserverCall)ObserverCall.class.cast(commandObserver);
        List results = observerCall.getObserverCallResults();
        for (ObserverCall.Result result : results) {
            if (result.getException() == null) continue;
            ModelUtil.logWarning((String)Messages.EMFStoreCommandNotifier_CommandObserverException, (Throwable)result.getException());
        }
    }

    public void addCommandStackObserver(ESCommandObserver observer) {
        ESWorkspaceProviderImpl.getObserverBus().register((ESObserver)observer);
    }

    public void removeCommandStackObserver(ESCommandObserver observer) {
        ESWorkspaceProviderImpl.getObserverBus().unregister((ESObserver)observer);
    }
}

