/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.controller;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.emfstore.client.ESRemoteProject;
import org.eclipse.emf.emfstore.client.ESUsersession;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESRemoteProjectImpl;
import org.eclipse.emf.emfstore.internal.client.ui.controller.AbstractEMFStoreUIController;
import org.eclipse.emf.emfstore.internal.client.ui.controller.Messages;
import org.eclipse.emf.emfstore.internal.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIDeleteRemoteProjectController
extends AbstractEMFStoreUIController<Void> {
    private final ServerInfo serverInfo;
    private final ESUsersession session;
    private final ProjectInfo projectInfo;
    private final ESRemoteProject remoteProject;

    public UIDeleteRemoteProjectController(Shell shell, ServerInfo serverInfo, ProjectInfo projectInfo) {
        super(shell);
        this.serverInfo = serverInfo;
        this.projectInfo = projectInfo;
        this.session = null;
        this.remoteProject = null;
    }

    public UIDeleteRemoteProjectController(Shell shell, ESUsersession session, ProjectInfo projectInfo) {
        super(shell);
        this.serverInfo = null;
        this.projectInfo = projectInfo;
        this.session = session;
        this.remoteProject = null;
    }

    public UIDeleteRemoteProjectController(Shell shell, ESUsersession session, ESRemoteProject remoteProject) {
        super(shell);
        this.serverInfo = null;
        this.projectInfo = null;
        this.session = session;
        this.remoteProject = remoteProject;
    }

    @Override
    public Void doRun(IProgressMonitor monitor) throws ESException {
        block3: {
            try {
                if (this.remoteProject == null) break block3;
                this.deleteRemoteProject(this.remoteProject, this.session, monitor);
                return null;
            }
            catch (ESException e) {
                String msg = this.remoteProject != null ? MessageFormat.format(Messages.UIDeleteRemoteProjectController_DeleteProjectFailed_Message, this.remoteProject.getProjectName()) : MessageFormat.format(Messages.UIDeleteRemoteProjectController_DeleteProjectFailed_Message, this.projectInfo.getName());
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.UIDeleteRemoteProjectController_DeleteProjectFailed_Title, (String)(String.valueOf(msg) + e.getMessage()));
                return null;
            }
        }
        this.deleteRemoteProject(this.serverInfo, this.projectInfo, this.session, monitor);
        return null;
    }

    private void deleteRemoteProject(ServerInfo server, ProjectInfo projectInfo, ESUsersession session, IProgressMonitor monitor) throws ESException {
        if (this.confirm(Messages.UIDeleteRemoteProjectController_Confirmation, MessageFormat.format(Messages.UIDeleteRemoteProjectController_DeleteRemoteProjectPrompt, projectInfo.getName()))) {
            if (session != null) {
                new ESRemoteProjectImpl(server, projectInfo).delete(session, monitor);
            } else {
                new ESRemoteProjectImpl(server, projectInfo).delete(monitor);
            }
        }
    }

    private void deleteRemoteProject(ESRemoteProject remoteProject, ESUsersession session, IProgressMonitor monitor) throws ESException {
        if (this.confirm(Messages.UIDeleteProjectController_Confirmation, MessageFormat.format(Messages.UIDeleteRemoteProjectController_DeleteRemoteProjectPrompt, remoteProject.getProjectName()))) {
            if (session != null) {
                remoteProject.delete(session, monitor);
            } else {
                remoteProject.delete(monitor);
            }
        }
    }
}

