/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.test.persistence;

import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.test.common.cases.ESTest;
import org.eclipse.emf.emfstore.internal.client.model.Configuration;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.Workspace;
import org.eclipse.emf.emfstore.internal.client.model.util.EMFStoreCommand;
import org.eclipse.emf.emfstore.internal.common.EMFStoreResource;
import org.eclipse.emf.emfstore.internal.common.EMFStoreResourceHelper;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.SerializationException;
import org.eclipse.emf.emfstore.test.model.TestmodelFactory;
import org.junit.Assert;
import org.junit.Test;

public class PersistenceTest
extends ESTest {
    @Test
    public void testReinitWorkspace() throws SerializationException {
        Configuration.getClientBehavior().setAutoSave(false);
        Project originalProject = (Project)ModelUtil.clone((EObject)((ProjectSpace)((Workspace)ESWorkspaceProviderImpl.getInstance().getWorkspace().toInternalAPI()).getProjectSpaces().get(0)).getProject());
        new EMFStoreCommand(){

            protected void doRun() {
                PersistenceTest.this.getProject().addModelElement((EObject)TestmodelFactory.eINSTANCE.createTestElement());
            }
        }.run(false);
        Assert.assertEquals((long)((ESLocalProject)ESWorkspaceProviderImpl.getInstance().getWorkspace().getLocalProjects().get(0)).getModelElements().size(), (long)1L);
        ESWorkspaceProviderImpl.getInstance().dispose();
        ESWorkspaceProviderImpl.getInstance().load();
        Workspace internalWorkspace = (Workspace)ESWorkspaceProviderImpl.getInstance().getWorkspace().toInternalAPI();
        Project project = ((ProjectSpace)internalWorkspace.getProjectSpaces().get(0)).getProject();
        Assert.assertTrue((boolean)ModelUtil.areEqual((IdEObjectCollection)project, (IdEObjectCollection)originalProject));
    }

    @Test
    public void testIsEMFStoreResourceHelperInUse() throws IOException {
        final XMLHelper[] helper = new XMLHelper[1];
        EMFStoreResource resource = new EMFStoreResource(URI.createURI((String)"foo")){

            protected XMLHelper createXMLHelper() {
                XMLHelper xmlHelper;
                helper[0] = xmlHelper = super.createXMLHelper();
                return xmlHelper;
            }
        };
        resource.save(null);
        Assert.assertTrue((boolean)EMFStoreResourceHelper.class.isInstance(helper[0]));
    }
}

