/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.impl.api;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.emfstore.client.ESRemoteProject;
import org.eclipse.emf.emfstore.client.ESServer;
import org.eclipse.emf.emfstore.client.ESUsersession;
import org.eclipse.emf.emfstore.client.ESWorkspaceProvider;
import org.eclipse.emf.emfstore.client.util.RunESCommand;
import org.eclipse.emf.emfstore.internal.client.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.Workspace;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ServerCall;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESRemoteProjectImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESUsersessionImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESWorkspaceImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.Messages;
import org.eclipse.emf.emfstore.internal.client.model.util.EMFStoreCommand;
import org.eclipse.emf.emfstore.internal.client.model.util.EMFStoreCommandWithException;
import org.eclipse.emf.emfstore.internal.common.APIUtil;
import org.eclipse.emf.emfstore.internal.common.api.APIDelegate;
import org.eclipse.emf.emfstore.internal.common.api.AbstractAPIImpl;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningFactory;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.server.model.ESGlobalProjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ESServerImpl
extends AbstractAPIImpl<ESServerImpl, ServerInfo>
implements ESServer {
    public ESServerImpl(ServerInfo serverInfo) {
        super((APIDelegate)serverInfo);
    }

    @Override
    public String getName() {
        return ((ServerInfo)this.toInternalAPI()).getName();
    }

    @Override
    public void setName(final String serverName) {
        new EMFStoreCommand(){

            protected void doRun() {
                ((ServerInfo)ESServerImpl.this.toInternalAPI()).setName(serverName);
            }
        }.run(false);
    }

    @Override
    public int getPort() {
        return ((ServerInfo)this.toInternalAPI()).getPort();
    }

    @Override
    public void setPort(final int port) {
        new EMFStoreCommand(){

            protected void doRun() {
                ((ServerInfo)ESServerImpl.this.toInternalAPI()).setPort(port);
            }
        }.run(false);
    }

    @Override
    public String getURL() {
        return ((ServerInfo)this.toInternalAPI()).getUrl();
    }

    @Override
    public void setURL(final String url) {
        new EMFStoreCommand(){

            protected void doRun() {
                ((ServerInfo)ESServerImpl.this.toInternalAPI()).setUrl(url);
            }
        }.run(false);
    }

    @Override
    public String getCertificateAlias() {
        return ((ServerInfo)this.toInternalAPI()).getCertificateAlias();
    }

    @Override
    public void setCertificateAlias(final String alias) {
        new EMFStoreCommand(){

            protected void doRun() {
                ((ServerInfo)ESServerImpl.this.toInternalAPI()).setCertificateAlias(alias);
            }
        }.run(false);
    }

    @Override
    public ESUsersession getLastUsersession() {
        if (((ServerInfo)this.toInternalAPI()).getLastUsersession() == null) {
            return null;
        }
        return (ESUsersession)((ServerInfo)this.toInternalAPI()).getLastUsersession().toAPI();
    }

    @Override
    public ESRemoteProject createRemoteProject(String projectName, IProgressMonitor monitor) throws ESException {
        ProjectInfo projectInfo = this.getCreateRemoteProjectServerCall(projectName).setServer((ServerInfo)this.toInternalAPI()).execute();
        return new ESRemoteProjectImpl((ServerInfo)this.toInternalAPI(), projectInfo);
    }

    @Override
    public ESRemoteProject createRemoteProject(ESUsersession usersession, String projectName, IProgressMonitor progressMonitor) throws ESException {
        ESUsersessionImpl session = (ESUsersessionImpl)this.validateUsersession(usersession);
        ProjectInfo projectInfo = this.getCreateRemoteProjectServerCall(projectName).setUsersession((Usersession)session.toInternalAPI()).execute();
        return new ESRemoteProjectImpl((ServerInfo)this.toInternalAPI(), projectInfo);
    }

    @Override
    public ESUsersession login(String name, String password) throws ESException {
        final ESWorkspaceImpl workspace = (ESWorkspaceImpl)ESWorkspaceProvider.INSTANCE.getWorkspace();
        workspace.addServer(this);
        final Usersession usersession = ModelFactory.eINSTANCE.createUsersession();
        usersession.setUsername(name);
        usersession.setPassword(password);
        usersession.setServerInfo((ServerInfo)this.toInternalAPI());
        ESUsersessionImpl esSession = (ESUsersessionImpl)usersession.toAPI();
        EMFStoreCommandWithException<ESException> cmd = new EMFStoreCommandWithException<ESException>(){

            @Override
            protected void doRun() {
                ((Workspace)workspace.toInternalAPI()).getUsersessions().add((Object)usersession);
                try {
                    usersession.logIn();
                }
                catch (AccessControlException e) {
                    this.setException(e);
                }
                catch (ESException e) {
                    this.setException(e);
                }
            }
        };
        cmd.run(false);
        if (cmd.hasException()) {
            throw (ESException)((Object)cmd.getException());
        }
        ((Workspace)workspace.toInternalAPI()).save();
        return esSession;
    }

    private List<ESRemoteProject> mapToRemoteProject(List<ProjectInfo> projectInfos) {
        ArrayList<ESRemoteProject> remoteProjects = new ArrayList<ESRemoteProject>();
        for (ProjectInfo projectInfo : projectInfos) {
            ESRemoteProjectImpl wrapper = new ESRemoteProjectImpl((ServerInfo)this.toInternalAPI(), projectInfo);
            remoteProjects.add(wrapper);
        }
        return remoteProjects;
    }

    @Override
    public List<ESRemoteProject> getRemoteProjects() throws ESException {
        List<ProjectInfo> projectInfos = this.getRemoteProjectsServerCall().setServer((ServerInfo)this.toInternalAPI()).execute();
        return APIUtil.copy(this.mapToRemoteProject(projectInfos));
    }

    @Override
    public List<ESRemoteProject> getRemoteProjects(ESUsersession usersession) throws ESException {
        final ServerCall<List<ProjectInfo>> serverCall = this.getRemoteProjectsServerCall().setUsersession((Usersession)((ESUsersessionImpl)usersession).toInternalAPI());
        List<ProjectInfo> projectInfos = RunESCommand.WithException.runWithResult(ESException.class, new Callable<List<ProjectInfo>>(){

            @Override
            public List<ProjectInfo> call() throws Exception {
                return (List)serverCall.execute();
            }
        });
        return APIUtil.copy(this.mapToRemoteProject(projectInfos));
    }

    private ServerCall<List<ProjectInfo>> getRemoteProjectsServerCall() {
        return new ServerCall<List<ProjectInfo>>(){

            @Override
            protected List<ProjectInfo> run() throws ESException {
                return this.getConnectionManager().getProjectList(this.getSessionId());
            }
        };
    }

    private ServerCall<ProjectInfo> getCreateRemoteProjectServerCall(final String projectName) {
        return new ServerCall<ProjectInfo>(){

            @Override
            protected ProjectInfo run() throws ESException {
                return this.getConnectionManager().createEmptyProject(this.getSessionId(), projectName, "", ESServerImpl.this.createLogmessage(this.getUsersession(), projectName));
            }
        };
    }

    private LogMessage createLogmessage(Usersession usersession, String projectName) {
        LogMessage log = VersioningFactory.eINSTANCE.createLogMessage();
        log.setMessage(MessageFormat.format(Messages.ESServerImpl_Creating_Project, projectName));
        log.setAuthor(usersession.getUsername());
        log.setClientDate(new Date());
        return log;
    }

    private ESUsersession validateUsersession(ESUsersession usersession) throws ESException {
        if (usersession == null || !this.equals(usersession.getServer())) {
            throw new ESException(Messages.ESServerImpl_Invalid_Userssesion);
        }
        return usersession;
    }

    public ESRemoteProject getRemoteProject(ESGlobalProjectId projectId) throws ESException {
        for (ESRemoteProject remoteProject : this.getRemoteProjects()) {
            if (!remoteProject.getGlobalProjectId().equals(projectId)) continue;
            return remoteProject;
        }
        return null;
    }

    public ESRemoteProject getRemoteProject(ESUsersession usersession, ESGlobalProjectId projectId) throws ESException {
        for (ESRemoteProject remoteProject : this.getRemoteProjects(usersession)) {
            if (!remoteProject.getGlobalProjectId().equals(projectId)) continue;
            return remoteProject;
        }
        return null;
    }
}

