/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.common.model.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.emfstore.common.ESResourceSetProvider;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPointException;
import org.eclipse.emf.emfstore.common.extensionpoint.ESPriorityComparator;
import org.eclipse.emf.emfstore.common.model.ESModelElementId;
import org.eclipse.emf.emfstore.common.model.ESSingletonIdResolver;
import org.eclipse.emf.emfstore.internal.common.CommonUtil;
import org.eclipse.emf.emfstore.internal.common.ResourceFactoryRegistry;
import org.eclipse.emf.emfstore.internal.common.model.AssociationClassElement;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.impl.ESModelElementIdImpl;
import org.eclipse.emf.emfstore.internal.common.model.impl.IdEObjectCollectionImpl;
import org.eclipse.emf.emfstore.internal.common.model.impl.ProjectImpl;
import org.eclipse.emf.emfstore.internal.common.model.util.ChecksumCalculatorWriter;
import org.eclipse.emf.emfstore.internal.common.model.util.IResourceLogger;
import org.eclipse.emf.emfstore.internal.common.model.util.Messages;
import org.eclipse.emf.emfstore.internal.common.model.util.SerializationException;
import org.eclipse.emf.emfstore.internal.common.model.util.SettingWithReferencedElement;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelUtil {
    private static final String CLIENT_RESOURCE_SET_PROVIDER_EXT_POINT_ID = "org.eclipse.emf.emfstore.client.resourceSetProvider";
    private static final String SERVER_RESOURCE_SET_PROVIDER_EXT_POINT_ID = "org.eclipse.emf.emfstore.server.resourceSetProvider";
    private static final String SINGLETON_ID_RESOLVER_EXT_POINT_ID = "org.eclipse.emf.emfstore.common.model.singletonIdResolver";
    private static final String IGNORED_DATATYPE_EXT_POINT_ID = "org.eclipse.emf.emfstore.common.model.ignoreDatatype";
    public static final long NO_CHECKSUM = -1L;
    public static final URI VIRTUAL_URI = URI.createURI((String)"virtualUri");
    private static final String ORG_ECLIPSE_EMF_EMFSTORE_COMMON_MODEL = "org.eclipse.emf.emfstore.common.model";
    private static final String DISCARD_DANGLING_HREF_ID = "org.eclipse.emf.emfstore.common.discardDanglingHREFs";
    private static IResourceLogger resourceLogger = new IResourceLogger(){

        public void logWarning(String msg) {
            ModelUtil.logWarning(msg);
        }

        public void logError(String msg) {
            ModelUtil.logError(msg);
        }
    };
    private static Set<String> ignoredDataTypes;
    private static Set<ESSingletonIdResolver> singletonIdResolvers;
    private static HashMap<Object, Object> resourceLoadOptions;
    private static HashMap<Object, Object> resourceSaveOptions;
    private static Map<Object, Object> checksumSaveOptions;
    private static SimpleDateFormat dateFormat;

    static {
        dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    }

    private ModelUtil() {
    }

    public static ModelElementId createModelElementId(String id) {
        ModelElementId modelElementId = ModelFactory.eINSTANCE.createModelElementId();
        modelElementId.setId(id);
        return modelElementId;
    }

    public static boolean areEqual(IdEObjectCollection collectionA, IdEObjectCollection collectionB) {
        long b;
        long a;
        try {
            a = ModelUtil.computeChecksum(collectionA);
            b = ModelUtil.computeChecksum(collectionB);
        }
        catch (SerializationException serializationException) {
            return false;
        }
        return a == b;
    }

    public static String eObjectToString(EObject eObject) throws SerializationException {
        return ModelUtil.eObjectToString(eObject, ModelUtil.getResourceSaveOptions());
    }

    public static String eObjectToString(EObject eObject, Map<?, ?> saveOptions) throws SerializationException {
        if (eObject == null) {
            return null;
        }
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        resourceSetImpl.setResourceFactoryRegistry((Resource.Factory.Registry)new ResourceFactoryRegistry());
        XMIResource resource = (XMIResource)resourceSetImpl.createResource(VIRTUAL_URI);
        ((ResourceImpl)resource).setIntrinsicIDToEObjectMap(new HashMap());
        IdEObjectCollection copy = eObject instanceof IdEObjectCollection ? ModelUtil.copyIdEObjectCollection((IdEObjectCollection)eObject, resource) : ModelUtil.copyEObject(ModelUtil.getProject(eObject), eObject, resource);
        if (saveOptions != null) {
            return ModelUtil.copiedEObjectToString(copy, resource, saveOptions);
        }
        return ModelUtil.copiedEObjectToString(copy, resource);
    }

    private static String copiedEObjectToString(EObject copy, XMIResource resource) throws SerializationException {
        return ModelUtil.copiedEObjectToString(copy, resource, ModelUtil.getChecksumSaveOptions());
    }

    private static String copiedEObjectToString(EObject copy, XMIResource resource, Map<?, ?> saveOptions) throws SerializationException {
        resource.getContents().add((Object)copy);
        StringWriter stringWriter = new StringWriter(200);
        URIConverter.WriteableOutputStream uws = new URIConverter.WriteableOutputStream((Writer)stringWriter, CommonUtil.getEncoding());
        try {
            try {
                resource.save((OutputStream)uws, saveOptions);
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }
        finally {
            try {
                uws.close();
            }
            catch (IOException exception) {
                ModelUtil.logException(exception);
            }
        }
        return stringWriter.toString().trim();
    }

    private static long computeChecksumLegacy(String eObjectString) {
        long h = 1125899906842597L;
        int len = eObjectString.length();
        int i = 0;
        while (i < len) {
            char c = eObjectString.charAt(i);
            h = 31L * h + (long)c;
            ++i;
        }
        return h;
    }

    public static long computeChecksumLegacy(EObject eObject) throws SerializationException {
        return ModelUtil.computeChecksumLegacy(ModelUtil.eObjectToString(eObject, ModelUtil.getChecksumSaveOptions()));
    }

    private static long computeChecksumForCopiedEObject(EObject copy, XMIResource resource, Map<?, ?> saveOptions) throws SerializationException {
        resource.getContents().add((Object)copy);
        ChecksumCalculatorWriter checksumCalculatorWriter = new ChecksumCalculatorWriter();
        URIConverter.WriteableOutputStream uws = new URIConverter.WriteableOutputStream((Writer)checksumCalculatorWriter, CommonUtil.getEncoding());
        try {
            try {
                resource.save((OutputStream)uws, saveOptions);
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }
        finally {
            try {
                uws.close();
            }
            catch (IOException exception) {
                ModelUtil.logException(exception);
            }
        }
        return checksumCalculatorWriter.getChecksum();
    }

    public static long computeChecksum(EObject eObject) throws SerializationException {
        return ModelUtil.computeChecksumInternal(eObject, false);
    }

    public static long computeChecksum(IdEObjectCollection collection) throws SerializationException {
        return ModelUtil.computeChecksumInternal(collection, true);
    }

    private static long computeChecksumInternal(EObject eObject, boolean sort) throws SerializationException {
        IdEObjectCollection copy;
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        resourceSetImpl.setResourceFactoryRegistry((Resource.Factory.Registry)new ResourceFactoryRegistry());
        XMIResource res = (XMIResource)resourceSetImpl.createResource(VIRTUAL_URI);
        ((ResourceImpl)res).setIntrinsicIDToEObjectMap(new HashMap());
        if (eObject instanceof IdEObjectCollection) {
            final IdEObjectCollection castedCopy = copy = ModelUtil.copyIdEObjectCollection((IdEObjectCollection)eObject, res);
            if (sort) {
                ECollections.sort(castedCopy.getModelElements(), (Comparator)new Comparator<EObject>(){

                    @Override
                    public int compare(EObject o1, EObject o2) {
                        return castedCopy.getModelElementId(o1).getId().compareTo(castedCopy.getModelElementId(o2).getId());
                    }
                });
            }
        } else {
            copy = ModelUtil.copyEObject(ModelUtil.getProject(eObject), eObject, res);
        }
        return ModelUtil.computeChecksumForCopiedEObject(copy, res, ModelUtil.getChecksumSaveOptions());
    }

    public static IResourceLogger getResourceLogger() {
        return resourceLogger;
    }

    public static IdEObjectCollection copyIdEObjectCollection(IdEObjectCollection collection, XMIResource res) {
        ModelElementId modelElementId;
        IdEObjectCollection copiedCollection = ModelUtil.clone(collection);
        for (EObject modelElement : copiedCollection.getAllModelElements()) {
            if (ModelUtil.isIgnoredDatatype(modelElement)) continue;
            modelElementId = copiedCollection.getModelElementId(modelElement);
            res.setID(modelElement, modelElementId.getId());
        }
        for (EObject modelElement : ((Project)copiedCollection).getCutElements()) {
            if (ModelUtil.isIgnoredDatatype(modelElement)) continue;
            modelElementId = ((IdEObjectCollectionImpl)copiedCollection).getModelElementId(modelElement);
            res.setID(modelElement, modelElementId.getId());
        }
        return copiedCollection;
    }

    private static EObject copyEObject(IdEObjectCollection collection, EObject object, XMIResource res) {
        IdEObjectCollection copiedCollection = ModelUtil.copyIdEObjectCollection(collection, res);
        EObject copiedEObject = copiedCollection.getModelElement(collection.getModelElementId(object));
        return copiedEObject;
    }

    public static synchronized boolean isIgnoredDatatype(EObject eObject) {
        return false;
    }

    public static synchronized boolean isIgnoredDatatype2(EObject eObject) {
        if (ignoredDataTypes == null) {
            ignoredDataTypes = new LinkedHashSet<String>();
            for (ESExtensionElement element : new ESExtensionPoint(IGNORED_DATATYPE_EXT_POINT_ID, true).getExtensionElements()) {
                try {
                    ignoredDataTypes.add(element.getAttribute("type"));
                }
                catch (ESExtensionPointException eSExtensionPointException) {}
            }
        }
        return ignoredDataTypes.contains(eObject.eClass().getInstanceClassName());
    }

    public static synchronized Map<Object, Object> getResourceLoadOptions() {
        if (resourceLoadOptions == null) {
            resourceLoadOptions = new LinkedHashMap<Object, Object>();
            resourceLoadOptions.put("DEFER_ATTACHMENT", Boolean.TRUE);
            resourceLoadOptions.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
            resourceLoadOptions.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
            resourceLoadOptions.put("ENCODING", CommonUtil.getEncoding());
            resourceLoadOptions.put("CONFIGURATION_CACHE", Boolean.TRUE);
        }
        resourceLoadOptions.put("USE_XML_NAME_TO_FEATURE_MAP", new HashMap());
        return resourceLoadOptions;
    }

    public static synchronized Map<Object, Object> getResourceSaveOptions() {
        if (resourceSaveOptions == null) {
            resourceSaveOptions = new LinkedHashMap<Object, Object>();
            resourceSaveOptions.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
            resourceSaveOptions.put("ENCODING", CommonUtil.getEncoding());
            resourceSaveOptions.put("FLUSH_THRESHOLD", 100000);
            resourceSaveOptions.put("USE_FILE_BUFFER", Boolean.TRUE);
            resourceSaveOptions.put("CONFIGURATION_CACHE", Boolean.TRUE);
            ESExtensionPoint extensionPoint = new ESExtensionPoint(DISCARD_DANGLING_HREF_ID);
            Boolean discardDanglingHREFs = extensionPoint.getBoolean("value", Boolean.FALSE.booleanValue());
            if (discardDanglingHREFs.booleanValue()) {
                resourceSaveOptions.put("PROCESS_DANGLING_HREF", "RECORD");
            }
            ModelUtil.logInfo(Messages.ModelUtil_Save_Options_Initialized);
            for (Map.Entry<Object, Object> entry : resourceSaveOptions.entrySet()) {
                ModelUtil.logInfo("\t" + entry.getKey() + ": " + entry.getValue());
            }
        }
        resourceSaveOptions.put("USE_CACHED_LOOKUP_TABLE", new ArrayList());
        return resourceSaveOptions;
    }

    public static synchronized Map<Object, Object> getChecksumSaveOptions() {
        if (checksumSaveOptions == null) {
            LinkedHashMap<Object, Object> saveOptions = new LinkedHashMap<Object, Object>(ModelUtil.getResourceSaveOptions());
            saveOptions.put("DECLARE_XML", Boolean.FALSE);
            saveOptions.put("FORMATTED", Boolean.FALSE);
            checksumSaveOptions = saveOptions;
        }
        return checksumSaveOptions;
    }

    public static void saveResource(Resource resource, IResourceLogger logger) throws IOException {
        try {
            resource.save(ModelUtil.getResourceSaveOptions());
        }
        finally {
            ModelUtil.logWarningsAndErrors(resource, logger);
        }
    }

    public static void loadResource(Resource resource, IResourceLogger logger) throws IOException {
        try {
            resource.load(ModelUtil.getResourceLoadOptions());
        }
        finally {
            ModelUtil.logWarningsAndErrors(resource, logger);
        }
    }

    private static void logWarningsAndErrors(Resource resource, IResourceLogger logger) {
        if (resource.getWarnings().size() > 0) {
            for (Resource.Diagnostic diagnostic : resource.getErrors()) {
                logger.logWarning(ModelUtil.logDiagnostic(diagnostic).toString());
            }
        }
        if (resource.getErrors().size() > 0) {
            for (Resource.Diagnostic diagnostic : resource.getErrors()) {
                logger.logError(ModelUtil.logDiagnostic(diagnostic).toString());
            }
        }
    }

    private static StringWriter logDiagnostic(Resource.Diagnostic diagnostic) {
        StringWriter error = new StringWriter();
        error.append(String.valueOf(diagnostic.getLocation()) + "\n");
        error.append(String.valueOf(diagnostic.getMessage()) + "\n");
        if (diagnostic instanceof Exception) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            ((Throwable)diagnostic).printStackTrace(printWriter);
            error.append(String.valueOf(stringWriter.toString()) + "\n");
        }
        return error;
    }

    private static boolean canHaveInstances(EClass eClass) {
        return !eClass.isAbstract() && !eClass.isInterface();
    }

    public static Set<EClass> getNonAbstractMETypes(EPackage ePackage) {
        LinkedHashSet<EClass> nonAbstractMETypes = new LinkedHashSet<EClass>();
        Set<EClass> allMETypes = ModelUtil.getAllMETypes(ePackage);
        for (EClass eClass : allMETypes) {
            if (!ModelUtil.canHaveInstances(eClass)) continue;
            nonAbstractMETypes.add(eClass);
        }
        return nonAbstractMETypes;
    }

    public static Set<EClass> getAllMETypes(EPackage ePackage) {
        LinkedHashSet<EClass> meTypes = new LinkedHashSet<EClass>();
        for (EObject eObject : ePackage.eContents()) {
            if (eObject instanceof EClass) {
                EClass eClass = (EClass)eObject;
                meTypes.add(eClass);
                continue;
            }
            if (!(eObject instanceof EPackage)) continue;
            EPackage eSubPackage = (EPackage)eObject;
            meTypes.addAll(ModelUtil.getAllMETypes(eSubPackage));
        }
        return meTypes;
    }

    public static void log(String message, Throwable exception, int statusInt) {
        Bundle bundle = Platform.getBundle((String)ORG_ECLIPSE_EMF_EMFSTORE_COMMON_MODEL);
        if (bundle == null) {
            return;
        }
        Status status = new Status(statusInt, bundle.getSymbolicName(), statusInt, message, exception);
        Platform.getLog((Bundle)bundle).log((IStatus)status);
    }

    public static void logException(String message, Throwable exception) {
        ModelUtil.log(message, exception, 4);
    }

    public static void logException(Throwable exception) {
        ModelUtil.logException(exception.getMessage(), exception);
    }

    public static void logWarning(String message, Throwable exception) {
        ModelUtil.log(message, exception, 2);
    }

    public static void logWarning(String message) {
        ModelUtil.log(message, null, 2);
    }

    public static void logError(String message) {
        ModelUtil.log(message, null, 4);
    }

    public static void logInfo(String message) {
        ModelUtil.log(message, null, 1);
    }

    public static void logProjectDetails(String message, String user, String projectName, String projectId, String branch, int revision) {
        if (!Boolean.getBoolean("emfstore.logDetails")) {
            return;
        }
        ModelUtil.logInfo(MessageFormat.format("Time: {0} | Msg: {1} | User: {2} | Project Name: {3} | Project Id: {4} | Branch: {5} | Revision: {6}", dateFormat.format(new Date()), message != null ? message : "", user != null ? user : "not available", projectName != null ? projectName : "not available", projectId != null ? projectId : "not available", branch != null ? branch : "not available", revision != -1 ? Integer.valueOf(revision) : "not available"));
    }

    public static <T extends EObject> T clone(T eObject) {
        if (eObject instanceof ProjectImpl) {
            return ((ProjectImpl)eObject).copy();
        }
        EObject clone = EcoreUtil.copy(eObject);
        return (T)clone;
    }

    public static <T extends EObject> List<T> clone(List<T> list) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject eObject : list) {
            EObject clone = ModelUtil.clone(eObject);
            result.add(clone);
        }
        return result;
    }

    public static <T extends EObject> List<T> flatCloneList(List<T> originalList) {
        ArrayList<EObject> clonedList = new ArrayList<EObject>(originalList.size());
        for (EObject element : originalList) {
            clonedList.add(element);
        }
        return clonedList;
    }

    public static <T extends EObject> T loadEObjectFromResource(EClass eClass, URI resourceURI, boolean checkConstraints) throws IOException {
        ResourceSet resourceSet = ModelUtil.getResourceSetForURI(resourceURI);
        Resource resource = checkConstraints ? resourceSet.getResource(resourceURI, false) : resourceSet.getResource(resourceURI, true);
        ModelUtil.loadResource(resource, resourceLogger);
        EList contents = resource.getContents();
        if (checkConstraints && contents.size() > 1) {
            throw new IOException(Messages.ModelUtil_Resource_Contains_Multiple_Objects);
        }
        if (contents.size() < 1) {
            throw new IOException(Messages.ModelUtil_Resource_Contains_No_Objects);
        }
        EObject eObject = (EObject)contents.get(0);
        if (eObject instanceof Project && resource instanceof XMIResource) {
            XMIResource xmiResource = (XMIResource)resource;
            Project project = (Project)eObject;
            LinkedHashMap<EObject, String> eObjectToIdMap = new LinkedHashMap<EObject, String>();
            LinkedHashMap<String, EObject> idToEObjectMap = new LinkedHashMap<String, EObject>();
            TreeIterator it = project.eAllContents();
            while (it.hasNext()) {
                EObject obj = (EObject)it.next();
                String id = xmiResource.getID(obj);
                if (id == null) continue;
                eObjectToIdMap.put(obj, id);
                idToEObjectMap.put(id, obj);
            }
            project.initMapping(eObjectToIdMap, idToEObjectMap);
        }
        if (!eClass.isInstance((Object)eObject)) {
            throw new IOException(Messages.ModelUtil_Resource_Contains_No_Objects_Of_Given_Class);
        }
        return (T)eObject;
    }

    private static ResourceSet getResourceSetForURI(URI resourceURI) {
        Object resourceSet = null;
        if (resourceURI != null && resourceURI.scheme().equals("emfstore")) {
            ESExtensionPoint extensionPoint = null;
            extensionPoint = resourceURI.authority().equals("workspaces") ? new ESExtensionPoint(CLIENT_RESOURCE_SET_PROVIDER_EXT_POINT_ID, false, (Comparator)new ESPriorityComparator("priority", true)) : new ESExtensionPoint(SERVER_RESOURCE_SET_PROVIDER_EXT_POINT_ID, false, (Comparator)new ESPriorityComparator("priority", true));
            ESResourceSetProvider resourceSetProvider = (ESResourceSetProvider)extensionPoint.getElementWithHighestPriority().getClass("class", ESResourceSetProvider.class);
            resourceSet = resourceSetProvider == null ? new ResourceSetImpl() : resourceSetProvider.getResourceSet();
        } else {
            resourceSet = new ResourceSetImpl();
        }
        return resourceSet;
    }

    public static void saveEObjectToResource(List<? extends EObject> eObjects, URI resourceURI, Map<Object, Object> options) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(resourceURI);
        EList contents = resource.getContents();
        for (EObject eObject : eObjects) {
            contents.add((Object)eObject);
            if (!(eObject instanceof Project) || !(resource instanceof XMIResource)) continue;
            ModelUtil.setXmiIdsOnResource((Project)eObject, (XMIResource)resource);
        }
        contents.addAll(eObjects);
        resource.save(options);
    }

    public static void saveEObjectToResource(List<? extends EObject> eObjects, URI resourceURI) throws IOException {
        ModelUtil.saveEObjectToResource(eObjects, resourceURI, null);
    }

    public static void setXmiIdsOnResource(Project project, XMIResource xmiResource) {
        for (EObject modelElement : project.getAllModelElements()) {
            ModelElementId modelElementId = project.getModelElementId(modelElement);
            xmiResource.setID(modelElement, modelElementId.getId());
        }
    }

    public static void saveEObjectToResource(EObject eObject, URI resourceURI) throws IOException {
        ArrayList<EObject> list = new ArrayList<EObject>();
        list.add(eObject);
        ModelUtil.saveEObjectToResource(list, resourceURI);
    }

    public static void deleteResourcesWithPrefix(ResourceSet resourceSet, String prefix) throws IOException {
        ArrayList<Resource> toDelete = new ArrayList<Resource>();
        for (Resource resource : resourceSet.getResources()) {
            if (!resource.getURI().toFileString().startsWith(prefix)) continue;
            toDelete.add(resource);
        }
        for (Resource resource : toDelete) {
            resource.delete(null);
        }
    }

    public static Project getProject(EObject modelElement) {
        LinkedHashSet<EObject> seenModelElements = new LinkedHashSet<EObject>();
        seenModelElements.add(modelElement);
        return ModelUtil.getParent(Project.class, modelElement, seenModelElements);
    }

    public static ModelElementId getModelElementId(EObject modelElement) {
        Project project = ModelUtil.getProject(modelElement);
        if (project == null) {
            return null;
        }
        return project.getModelElementId(modelElement);
    }

    public static <T extends EObject> T getParent(Class<T> parent, EObject child) {
        LinkedHashSet<EObject> seenModelElements = new LinkedHashSet<EObject>();
        seenModelElements.add(child);
        return ModelUtil.getParent(parent, child, seenModelElements);
    }

    private static <T extends EObject> T getParent(Class<T> parent, EObject child, Set<EObject> seenModelElements) {
        if (child == null) {
            return null;
        }
        if (seenModelElements.contains(child.eContainer())) {
            throw new IllegalStateException(Messages.ModelUtil_ModelElement_Is_In_Containment_Cycle);
        }
        if (parent.isInstance(child)) {
            return (T)child;
        }
        seenModelElements.add(child);
        return ModelUtil.getParent(parent, child.eContainer(), seenModelElements);
    }

    public static boolean isAssociationClassElement(EClass eClazz) {
        if (eClazz == null || eClazz.isAbstract() || eClazz.getInstanceClass() == null) {
            return false;
        }
        return AssociationClassElement.class.isAssignableFrom(eClazz.getInstanceClass());
    }

    public static Set<EObject> getAllContainedModelElements(EObject modelElement, boolean includeTransientContainments) {
        return ModelUtil.getAllContainedModelElements(modelElement, includeTransientContainments, false);
    }

    public static Set<EObject> getAllContainedModelElements(EObject modelElement, boolean includeTransientContainments, boolean ignoreSingletonDatatypes) {
        return ModelUtil.getAllContainedModelElements(Collections.singletonList(modelElement), includeTransientContainments, ignoreSingletonDatatypes);
    }

    public static Set<EObject> getAllContainedModelElements(Resource resource, boolean includeTransientContainments, boolean ignoreSingletonDatatypes) {
        return ModelUtil.getAllContainedModelElements((Collection<EObject>)resource.getContents(), includeTransientContainments, ignoreSingletonDatatypes);
    }

    public static Set<EObject> getAllContainedModelElements(Collection<EObject> modelElements, boolean includeTransientContainments, boolean ignoreSingletonDatatypes) {
        LinkedHashSet<EObject> result = new LinkedHashSet<EObject>();
        for (EObject modelElement : modelElements) {
            for (EObject containee : modelElement.eContents()) {
                if (ignoreSingletonDatatypes && ModelUtil.isSingleton(containee) || containee.eContainingFeature().isTransient() && !includeTransientContainments) continue;
                Set<EObject> elements = ModelUtil.getAllContainedModelElements(containee, includeTransientContainments, ignoreSingletonDatatypes);
                result.add(containee);
                result.addAll(elements);
            }
        }
        return result;
    }

    public static EObject getContainerModelElement(EObject modelElement) {
        EObject container = modelElement.eContainer();
        if (container == null) {
            return null;
        }
        if (EcoreFactory.eINSTANCE.getEcorePackage().getEObject().isInstance((Object)container)) {
            return container;
        }
        return null;
    }

    public static List<EObject> getAllContainedModelElementsAsList(EObject modelElement, boolean includeTransientContainments) {
        TreeIterator it = modelElement.eAllContents();
        ArrayList<EObject> result = new ArrayList<EObject>();
        while (it.hasNext()) {
            EObject containee = (EObject)it.next();
            if ((containee.eContainingFeature() == null || containee.eContainingFeature().isTransient()) && !includeTransientContainments) continue;
            result.add(containee);
        }
        return result;
    }

    public static void deleteIncomingCrossReferencesToElement(EObject element, Collection<EStructuralFeature.Setting> inverseReferences, Set<EObject> referenceSourceElementsToIgnore) {
        for (EStructuralFeature.Setting setting : inverseReferences) {
            EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
            EReference reference = (EReference)eStructuralFeature;
            EObject sourceElement = setting.getEObject();
            if (referenceSourceElementsToIgnore.contains(sourceElement) || reference.isContainer() || reference.isContainment() || !reference.isChangeable()) continue;
            if (eStructuralFeature.isMany()) {
                ((EList)sourceElement.eGet(eStructuralFeature)).remove((Object)element);
                continue;
            }
            if (sourceElement instanceof Map.Entry && eStructuralFeature.getName().equals("key")) {
                ModelUtil.logWarning(MessageFormat.format(Messages.ModelUtil_Incoming_CrossRef_Is_Map_Key, element));
            }
            sourceElement.eUnset(eStructuralFeature);
        }
    }

    public static void deleteOutgoingCrossReferences(IdEObjectCollection collection, EObject modelElement) {
        LinkedHashSet<EObject> allModelElements = new LinkedHashSet<EObject>();
        allModelElements.add(modelElement);
        allModelElements.addAll(ModelUtil.getAllContainedModelElements(modelElement, false));
        List<SettingWithReferencedElement> crossReferences = ModelUtil.collectOutgoingCrossReferences(collection, allModelElements);
        for (SettingWithReferencedElement settingWithReferencedElement : crossReferences) {
            EStructuralFeature.Setting setting = settingWithReferencedElement.getSetting();
            if (!settingWithReferencedElement.getSetting().getEStructuralFeature().isMany()) {
                setting.getEObject().eUnset(setting.getEStructuralFeature());
                continue;
            }
            List references = (List)setting.getEObject().eGet(setting.getEStructuralFeature());
            references.remove(settingWithReferencedElement.getReferencedElement());
        }
    }

    public static List<SettingWithReferencedElement> collectOutgoingCrossReferences(IdEObjectCollection collection, Set<EObject> modelElements) {
        ArrayList<SettingWithReferencedElement> settings = new ArrayList<SettingWithReferencedElement>();
        for (EObject currentElement : modelElements) {
            for (EReference reference : currentElement.eClass().getEAllReferences()) {
                EClassifier eType = reference.getEType();
                if (reference.isContainer() || reference.isContainment() || !reference.isChangeable() || !(eType instanceof EClass)) continue;
                EStructuralFeature.Setting setting = ((InternalEObject)currentElement).eSetting((EStructuralFeature)reference);
                if (reference.isMany()) {
                    List referencedElements = (List)currentElement.eGet((EStructuralFeature)reference);
                    for (EObject referencedElement : referencedElements) {
                        if (!ModelUtil.shouldBeCollected(collection, modelElements, referencedElement)) continue;
                        settings.add(new SettingWithReferencedElement(setting, referencedElement));
                    }
                    continue;
                }
                EObject referencedElement = (EObject)currentElement.eGet((EStructuralFeature)reference);
                if (!ModelUtil.shouldBeCollected(collection, modelElements, referencedElement)) continue;
                settings.add(new SettingWithReferencedElement(setting, referencedElement));
            }
        }
        return settings;
    }

    public static boolean shouldBeCollected(IdEObjectCollection collection, Set<EObject> allModelElements, EObject referencedElement) {
        if (referencedElement == null) {
            return false;
        }
        if (!collection.contains(referencedElement) && ((ProjectImpl)collection).getDeletedModelElementId(referencedElement) == null) {
            return false;
        }
        return !ModelUtil.isSingleton(referencedElement) && !ModelUtil.isIgnoredDatatype(referencedElement) && !allModelElements.contains(referencedElement);
    }

    public static EObject getSingleton(ModelElementId singletonId) {
        ModelUtil.initSingletonIdResolvers();
        for (ESSingletonIdResolver resolver : singletonIdResolvers) {
            EObject singleton = resolver.getSingleton((ESModelElementId)singletonId.toAPI());
            if (singleton == null) continue;
            return singleton;
        }
        return null;
    }

    public static ModelElementId getSingletonModelElementId(EObject singleton) {
        ModelUtil.initSingletonIdResolvers();
        for (ESSingletonIdResolver resolver : singletonIdResolvers) {
            ESModelElementIdImpl id = (ESModelElementIdImpl)resolver.getSingletonModelElementId(singleton);
            if (id == null) continue;
            return ModelUtil.clone((ModelElementId)id.toInternalAPI());
        }
        return null;
    }

    public static boolean isSingleton(EObject eObject) {
        ModelUtil.initSingletonIdResolvers();
        for (ESSingletonIdResolver resolver : singletonIdResolvers) {
            if (!resolver.isSingleton(eObject)) continue;
            return true;
        }
        return false;
    }

    private static synchronized void initSingletonIdResolvers() {
        if (singletonIdResolvers == null) {
            singletonIdResolvers = new LinkedHashSet<ESSingletonIdResolver>();
            for (ESExtensionElement element : new ESExtensionPoint(SINGLETON_ID_RESOLVER_EXT_POINT_ID).getExtensionElements()) {
                try {
                    singletonIdResolvers.add((ESSingletonIdResolver)element.getClass("class", ESSingletonIdResolver.class));
                }
                catch (ESExtensionPointException e) {
                    ModelUtil.logWarning(String.valueOf(Messages.ModelUtil_SingletonIdResolver_Not_Instantiated) + e.getMessage());
                }
            }
        }
    }
}

