/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.table.model.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecp.view.internal.table.model.Activator;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.model.util.ViewValidator;
import org.eclipse.emf.ecp.view.spi.table.model.DetailEditing;
import org.eclipse.emf.ecp.view.spi.table.model.VReadOnlyColumnConfiguration;
import org.eclipse.emf.ecp.view.spi.table.model.VTableColumnConfiguration;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.model.VTableDomainModelReference;
import org.eclipse.emf.ecp.view.spi.table.model.VTablePackage;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;

public class TableValidator
extends EObjectValidator {
    public static final TableValidator INSTANCE = new TableValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.emf.ecp.view.spi.table.model";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected ViewValidator viewValidator = ViewValidator.INSTANCE;
    private EMFFormsDatabinding emfFormsDatabinding;

    TableValidator(EMFFormsDatabinding emfFormsDatabinding) {
        this();
        this.emfFormsDatabinding = emfFormsDatabinding;
    }

    public TableValidator() {
    }

    protected EPackage getEPackage() {
        return VTablePackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateTableControl((VTableControl)value, diagnostics, context);
            }
            case 1: {
                return this.validateTableColumnConfiguration((VTableColumnConfiguration)value, diagnostics, context);
            }
            case 2: {
                return this.validateTableDomainModelReference((VTableDomainModelReference)value, diagnostics, context);
            }
            case 3: {
                return this.validateReadOnlyColumnConfiguration((VReadOnlyColumnConfiguration)value, diagnostics, context);
            }
            case 4: {
                return this.validateDetailEditing((DetailEditing)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateTableControl(VTableControl tableControl, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)tableControl, diagnostics, context);
    }

    public boolean validateTableColumnConfiguration(VTableColumnConfiguration tableColumnConfiguration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(tableColumnConfiguration, diagnostics, context);
    }

    public boolean validateTableDomainModelReference(VTableDomainModelReference tableDomainModelReference, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)tableDomainModelReference, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)tableDomainModelReference, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)tableDomainModelReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)tableDomainModelReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)tableDomainModelReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)tableDomainModelReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)tableDomainModelReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)tableDomainModelReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)tableDomainModelReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTableDomainModelReference_resolveable(tableDomainModelReference, diagnostics, context);
        }
        return result;
    }

    public boolean validate_EveryMultiplicityConforms(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        EClass eClass = eObject.eClass();
        int i = 0;
        int size = eClass.getFeatureCount();
        while (i < size) {
            if (!(VTableDomainModelReference.class.isInstance(eObject) && eClass.getEStructuralFeature(i) == VViewPackage.eINSTANCE.getFeaturePathDomainModelReference_DomainModelEFeature() || (result &= this.validate_MultiplicityConforms(eObject, eClass.getEStructuralFeature(i), diagnostics, context)) || diagnostics != null)) {
                return false;
            }
            ++i;
        }
        return result;
    }

    public boolean validateTableDomainModelReference_resolveable(VTableDomainModelReference tableDomainModelReference, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String message;
        IValueProperty valueProperty;
        ViewValidator validator;
        Object pathToMultiRef = tableDomainModelReference.getDomainModelReference();
        if (pathToMultiRef != null) {
            validator = EValidator.Registry.INSTANCE.getEValidator(pathToMultiRef.eClass().getEPackage());
        } else {
            pathToMultiRef = tableDomainModelReference;
            validator = this.viewValidator;
        }
        if (!validator.validate((EObject)pathToMultiRef, diagnostics, context)) {
            if (pathToMultiRef != tableDomainModelReference && tableDomainModelReference.eContainer() != null && diagnostics != null) {
                diagnostics.add(this.createDiagnostic(4, 0, "Error on path to multi reference", tableDomainModelReference.eContainer(), tableDomainModelReference.eContainingFeature()));
            }
            return false;
        }
        try {
            valueProperty = this.getEMFFormsDatabinding().getValueProperty(pathToMultiRef, null);
        }
        catch (DatabindingFailedException ex) {
            Activator.getDefault().getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return true;
        }
        EStructuralFeature feature = (EStructuralFeature)valueProperty.getValueType();
        if (!EReference.class.isInstance(feature) || !feature.isMany()) {
            if (diagnostics != null) {
                String message2 = "Domain model reference does not end at a multi reference.";
                if (tableDomainModelReference.eContainer() != null) {
                    diagnostics.add(this.createDiagnostic(4, 0, "Domain model reference does not end at a multi reference.", tableDomainModelReference.eContainer(), tableDomainModelReference.eContainingFeature()));
                }
                if (pathToMultiRef == tableDomainModelReference) {
                    diagnostics.add(this.createDiagnostic(4, 0, "Domain model reference does not end at a multi reference.", (EObject)pathToMultiRef, (EStructuralFeature)VViewPackage.eINSTANCE.getFeaturePathDomainModelReference_DomainModelEFeature()));
                } else {
                    diagnostics.add(this.createDiagnostic(4, 0, "Domain model reference does not end at a multi reference.", (EObject)tableDomainModelReference, (EStructuralFeature)VTablePackage.eINSTANCE.getTableDomainModelReference_DomainModelReference()));
                }
            }
            return false;
        }
        EReference reference = (EReference)EReference.class.cast(feature);
        EClass referenceType = reference.getEReferenceType();
        boolean success = true;
        for (VDomainModelReference columnDMR : tableDomainModelReference.getColumnDomainModelReferences()) {
            if (!(success &= this.validateColumnForRootEClass(columnDMR, referenceType))) break;
        }
        if (success) {
            return true;
        }
        Collection<EClass> subClasses = TableValidator.getSubClasses(referenceType);
        LinkedHashSet<EClass> usableSubclasses = new LinkedHashSet<EClass>();
        for (EClass subClass : subClasses) {
            success = true;
            for (VDomainModelReference columnDMR : tableDomainModelReference.getColumnDomainModelReferences()) {
                if (!(success &= this.validateColumnForRootEClass(columnDMR, subClass))) break;
            }
            if (!success) continue;
            usableSubclasses.add(subClass);
        }
        if (usableSubclasses.isEmpty()) {
            if (diagnostics != null) {
                message = "Some columns may not be resolvable";
                if (tableDomainModelReference.eContainer() != null) {
                    diagnostics.add(this.createDiagnostic(2, 0, "Some columns may not be resolvable", tableDomainModelReference.eContainer(), tableDomainModelReference.eContainingFeature()));
                }
                diagnostics.add(this.createDiagnostic(2, 0, "Some columns may not be resolvable", (EObject)tableDomainModelReference, (EStructuralFeature)VTablePackage.eINSTANCE.getTableDomainModelReference_ColumnDomainModelReferences()));
            }
            return false;
        }
        if (diagnostics != null) {
            message = "Columns are resovable against a subclass of " + referenceType.getName();
            if (tableDomainModelReference.eContainer() != null) {
                diagnostics.add(this.createDiagnostic(1, 0, message, tableDomainModelReference.eContainer(), tableDomainModelReference.eContainingFeature()));
            }
            diagnostics.add(this.createDiagnostic(1, 0, message, (EObject)tableDomainModelReference, (EStructuralFeature)VTablePackage.eINSTANCE.getTableDomainModelReference_ColumnDomainModelReferences()));
        }
        return true;
    }

    private EMFFormsDatabinding getEMFFormsDatabinding() {
        if (this.emfFormsDatabinding != null) {
            return this.emfFormsDatabinding;
        }
        return Activator.getDefault().getEMFFormsDatabinding();
    }

    private Diagnostic createDiagnostic(int severity, int code, String message, EObject object, EStructuralFeature feature) {
        return new BasicDiagnostic(severity, DIAGNOSTIC_SOURCE, code, message, new Object[]{object, feature});
    }

    private boolean validateColumnForRootEClass(VDomainModelReference columnDMR, EClass rootEClass) {
        EValidator validator = EValidator.Registry.INSTANCE.getEValidator(columnDMR.eClass().getEPackage());
        LinkedHashMap<String, EClass> context = new LinkedHashMap<String, EClass>();
        context.put("dmr_resolvement_eclass", rootEClass);
        return validator.validate((EObject)columnDMR, null, context);
    }

    public boolean validateReadOnlyColumnConfiguration(VReadOnlyColumnConfiguration readOnlyColumnConfiguration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(readOnlyColumnConfiguration, diagnostics, context);
    }

    public boolean validateDetailEditing(DetailEditing detailEditing, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }

    private static Collection<EClass> getSubClasses(EClass superClass) {
        HashSet<EClass> classes = new HashSet<EClass>();
        ArrayList keySet = new ArrayList(EPackage.Registry.INSTANCE.keySet());
        for (String nsURI : keySet) {
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(nsURI);
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                EClass eClass;
                if (!(eClassifier instanceof EClass) || !superClass.isSuperTypeOf(eClass = (EClass)eClassifier) || eClass.isAbstract() || eClass.isInterface()) continue;
                classes.add(eClass);
            }
        }
        return classes;
    }
}

