/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.replacement;

import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="volatileToOpposite", label="Volatile to Opposite Reference", description="In the metamodel, a reference is changed from being volatile to an opposite. In the model, the opposite direction needs to be set.")
public class VolatileToOpposite
extends OperationImplementation {
    @EdaptParameter(main=true, description="The reference which is changed from volatile to opposite")
    public EReference reference;
    @EdaptParameter(description="The reference which is going to be the opposite")
    public EReference opposite;
    @EdaptParameter(description="Whether the reference is going to be changeable")
    public Boolean changeable = true;

    @EdaptConstraint(restricts="opposite", description="Reference and opposite must be compatible with each other")
    public boolean checkOppositeCompatible(EReference opposite) {
        return this.reference.getEType() == opposite.getEContainingClass() && this.reference.getEContainingClass() == opposite.getEType();
    }

    @EdaptConstraint(description="Reference must be volatile")
    public boolean checkReferenceVolatile() {
        return this.reference.isVolatile();
    }

    @EdaptConstraint(description="Reference must not already have an opposite")
    public boolean checkReferenceNoOpposite() {
        return this.reference.getEOpposite() == null;
    }

    public void execute(Metamodel metamodel, Model model) {
        this.reference.setVolatile(false);
        this.reference.setTransient(false);
        this.reference.setDerived(false);
        this.reference.setChangeable(this.changeable.booleanValue());
        metamodel.setEOpposite(this.opposite, this.reference);
    }
}

