/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfcloud.jackson.databind.property;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.fasterxml.jackson.databind.ser.std.StringSerializer;
import java.io.IOException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emfcloud.jackson.annotations.EcoreTypeInfo;
import org.eclipse.emfcloud.jackson.databind.property.EObjectProperty;
import org.eclipse.emfcloud.jackson.module.EMFModule;
import org.eclipse.emfcloud.jackson.utils.ValueReader;
import org.eclipse.emfcloud.jackson.utils.ValueWriter;

public class EObjectTypeProperty
extends EObjectProperty {
    private final JsonSerializer<Object> serializer = new StringSerializer();
    private final JsonDeserializer<String> deserializer = StringDeserializer.instance;
    private final ValueReader<String, EClass> valueReader;
    private final ValueWriter<EClass, String> valueWriter;
    private final int features;

    public EObjectTypeProperty(EcoreTypeInfo info, int features) {
        super(info.getProperty());
        this.valueReader = info.getValueReader();
        this.valueWriter = info.getValueWriter();
        this.features = features;
    }

    @Override
    public void serialize(EObject bean, JsonGenerator jg, SerializerProvider provider) throws IOException {
        if (!EMFModule.Feature.OPTION_SERIALIZE_TYPE.enabledIn(this.features)) {
            return;
        }
        EClass objectType = bean.eClass();
        EReference containment = bean.eContainmentFeature();
        if (this.isRoot(bean) || this.shouldSaveType(objectType, containment.getEReferenceType(), (EStructuralFeature)containment)) {
            String value = this.valueWriter.writeValue(bean.eClass(), provider);
            jg.writeFieldName(this.getFieldName());
            this.serializer.serialize((Object)value, jg, provider);
        }
    }

    private boolean isRoot(EObject bean) {
        EObject container = bean.eContainer();
        Resource.Internal resource = ((InternalEObject)bean).eDirectResource();
        return container == null || resource != null && resource != ((InternalEObject)container).eDirectResource();
    }

    @Override
    public EObject deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp.getCurrentToken() == JsonToken.FIELD_NAME) {
            jp.nextToken();
        }
        return this.create((String)this.deserializer.deserialize(jp, ctxt), ctxt);
    }

    public EObject create(String value, DeserializationContext ctxt) {
        EClass eClass = this.valueReader.readValue(value, ctxt);
        return eClass != null ? EcoreUtil.create((EClass)eClass) : null;
    }

    @Override
    public void deserializeAndSet(JsonParser jp, EObject current, DeserializationContext ctxt, Resource resource) throws IOException {
    }

    private boolean shouldSaveType(EClass objectType, EClass featureType, EStructuralFeature feature) {
        return objectType != featureType && objectType != EcorePackage.Literals.EOBJECT;
    }
}

