/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p3order;

import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.p3order.AbstractBarycenterPortDistributor;
import org.eclipse.elk.alg.layered.properties.PortType;
import org.eclipse.elk.core.options.PortSide;

public final class LayerTotalPortDistributor
extends AbstractBarycenterPortDistributor {
    public LayerTotalPortDistributor(int numLayers) {
        super(numLayers);
    }

    @Override
    protected float calculatePortRanks(LNode node, float rankSum, PortType type) {
        float[] portRanks = this.getPortRanks();
        switch (type) {
            case INPUT: {
                int inputCount = 0;
                int northInputCount = 0;
                for (LPort port : node.getPorts()) {
                    if (port.getIncomingEdges().isEmpty()) continue;
                    ++inputCount;
                    if (port.getSide() != PortSide.NORTH) continue;
                    ++northInputCount;
                }
                float northPos = rankSum + (float)northInputCount;
                float restPos = rankSum + (float)inputCount;
                for (LPort port : node.getPorts(PortType.INPUT)) {
                    if (port.getSide() == PortSide.NORTH) {
                        portRanks[port.id] = northPos;
                        northPos -= 1.0f;
                        continue;
                    }
                    portRanks[port.id] = restPos;
                    restPos -= 1.0f;
                }
                return inputCount;
            }
            case OUTPUT: {
                int pos = 0;
                for (LPort port : node.getPorts(PortType.OUTPUT)) {
                    portRanks[port.id] = rankSum + (float)(++pos);
                }
                return pos;
            }
        }
        throw new IllegalArgumentException();
    }
}

