/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.rectpacking.p1widthapproximation;

import java.util.List;
import org.eclipse.elk.alg.rectpacking.util.DrawingData;
import org.eclipse.elk.graph.ElkNode;

public final class Calculations {
    private Calculations() {
    }

    protected static double getWidthLPRorLPB(double drawingWidth, double x, double width) {
        return Math.max(drawingWidth, x + width);
    }

    protected static double getHeightLPRorLPB(double drawingHeight, double y, double height) {
        return Math.max(drawingHeight, y + height);
    }

    protected static double calculateYforLPR(double x, List<ElkNode> placedRects, ElkNode lastPlaced, double nodeNodeSpacing) {
        ElkNode closestUpperNeighbor = null;
        double closestNeighborBottomBorder = 0.0;
        for (ElkNode placedRect : placedRects) {
            double placedRectBottomBorder = placedRect.getY() + placedRect.getHeight();
            if (!Calculations.verticalOrderConstraint(placedRect, x, nodeNodeSpacing)) continue;
            if (closestUpperNeighbor == null) {
                closestUpperNeighbor = placedRect;
            } else if (lastPlaced.getY() - placedRectBottomBorder < lastPlaced.getY() - closestNeighborBottomBorder) {
                closestUpperNeighbor = placedRect;
            }
            closestNeighborBottomBorder = closestUpperNeighbor.getY() + closestUpperNeighbor.getHeight();
        }
        if (closestUpperNeighbor == null) {
            return 0.0;
        }
        return closestNeighborBottomBorder + nodeNodeSpacing;
    }

    protected static double calculateXforLPB(double y, List<ElkNode> placedRects, ElkNode lastPlaced, double nodeNodeSpacing) {
        ElkNode closestLeftNeighbour = null;
        double closestNeighborRightBorder = 0.0;
        for (ElkNode placedRect : placedRects) {
            double placedRectRightBorder = placedRect.getX() + placedRect.getWidth();
            if (!Calculations.horizontalOrderConstraint(placedRect, y, nodeNodeSpacing)) continue;
            if (closestLeftNeighbour == null) {
                closestLeftNeighbour = placedRect;
            } else if (lastPlaced.getX() - placedRectRightBorder < lastPlaced.getX() - closestNeighborRightBorder) {
                closestLeftNeighbour = placedRect;
            }
            closestNeighborRightBorder = closestLeftNeighbour.getX() + closestLeftNeighbour.getWidth();
        }
        if (closestLeftNeighbour == null) {
            return 0.0;
        }
        return closestNeighborRightBorder + nodeNodeSpacing;
    }

    protected static double calculateAreaLPR(ElkNode lastPlaced, ElkNode toPlace, DrawingData lprOpt) {
        double lastPlacedBottomBorder = lastPlaced.getY() + lastPlaced.getHeight();
        double toPlaceBottomBorder = lprOpt.getNextYcoordinate() + toPlace.getHeight();
        double maxYLPR = Math.max(lastPlacedBottomBorder, toPlaceBottomBorder);
        double heightLPR = maxYLPR - Math.min(lastPlaced.getY(), lprOpt.getNextYcoordinate());
        double widthLPR = lprOpt.getNextXcoordinate() + toPlace.getWidth() - lastPlaced.getX();
        return widthLPR * heightLPR;
    }

    protected static double calculateAreaLPB(ElkNode lastPlaced, ElkNode toPlace, DrawingData lpbOpt) {
        double lastPlacedRightBorder = lastPlaced.getX() + lastPlaced.getWidth();
        double toPlaceRightBorder = lpbOpt.getNextXcoordinate() + toPlace.getWidth();
        double maxXLPB = Math.max(lastPlacedRightBorder, toPlaceRightBorder);
        double widthLPB = maxXLPB - Math.min(lastPlaced.getX(), lpbOpt.getNextXcoordinate());
        double heightLPB = lpbOpt.getNextYcoordinate() + toPlace.getHeight() - lastPlaced.getY();
        return widthLPB * heightLPB;
    }

    private static boolean verticalOrderConstraint(ElkNode placedRect, double x, double nodeNodeSpacing) {
        return x < placedRect.getX() + placedRect.getWidth() + nodeNodeSpacing;
    }

    private static boolean horizontalOrderConstraint(ElkNode placedRect, double yCoordRectToPlace, double nodeNodeSpacing) {
        return yCoordRectToPlace < placedRect.getY() + placedRect.getHeight() + nodeNodeSpacing;
    }
}

