/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.spore.p3execution;

import org.eclipse.elk.alg.common.Tree;
import org.eclipse.elk.alg.common.spore.DepthFirstCompaction;
import org.eclipse.elk.alg.common.spore.InternalProperties;
import org.eclipse.elk.alg.common.spore.Node;
import org.eclipse.elk.alg.common.utils.SVGImage;
import org.eclipse.elk.alg.spore.SPOrEPhases;
import org.eclipse.elk.alg.spore.graph.Graph;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class ShrinkTreeCompactionPhase
implements ILayoutPhase<SPOrEPhases, Graph> {
    public LayoutProcessorConfiguration<SPOrEPhases, Graph> getLayoutProcessorConfiguration(Graph graph) {
        return LayoutProcessorConfiguration.create();
    }

    public void process(Graph graph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Shrinking tree compaction", 1.0f);
        if (((Boolean)graph.getProperty(InternalProperties.DEBUG_SVG)).booleanValue()) {
            this.debugOut(graph.tree);
            DepthFirstCompaction.compact(graph.tree, (boolean)graph.orthogonalCompaction, (String)(ElkUtil.debugFolderPath((String[])new String[]{"spore"}) + "60compaction"));
        } else {
            DepthFirstCompaction.compact(graph.tree, (boolean)graph.orthogonalCompaction);
        }
        progressMonitor.done();
    }

    private void debugOut(Tree<Node> tree) {
        SVGImage svg = new SVGImage(ElkUtil.debugFolderPath((String[])new String[]{"spore"}) + "30Tree");
        svg.clear();
        svg.addCircle(((Node)tree.node).vertex.x, ((Node)tree.node).vertex.y, 10.0, "fill=\"lime\"");
        this.draw(tree, svg);
        svg.save();
        svg.debug = false;
    }

    private void draw(Tree<Node> t, SVGImage svg) {
        svg.addRect(((Node)t.node).rect, "fill=\"none\" stroke=\"black\"");
        t.children.forEach(c -> {
            svg.addLine(((Node)tree.node).vertex.x, ((Node)tree.node).vertex.y, ((Node)c.node).vertex.x, ((Node)c.node).vertex.y, "stroke=\"blue\"");
            KVector cv = ((Node)tree.node).vertex.clone().sub(((Node)c.node).vertex);
            cv.scaleToLength(((Node)tree.node).distance((Node)c.node, cv));
            svg.addLine(((Node)c.node).vertex.x, ((Node)c.node).vertex.y, ((Node)c.node).vertex.x + cv.x, ((Node)c.node).vertex.y + cv.y, "stroke=\"orange\"");
            this.draw((Tree<Node>)c, svg);
        });
    }
}

