/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.rectpacking.intermediate;

import org.eclipse.elk.alg.common.nodespacing.NodeLabelAndSizeCalculator;
import org.eclipse.elk.alg.rectpacking.options.InternalProperties;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.adapters.ElkGraphAdapters;
import org.eclipse.elk.core.util.adapters.GraphAdapters;
import org.eclipse.elk.graph.ElkNode;

public class MinSizePreProcessor
implements ILayoutProcessor<ElkNode> {
    public void process(ElkNode graph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Min Size Preprocessing", 1.0f);
        KVector minSize = ElkUtil.effectiveMinSizeConstraintFor((ElkNode)graph);
        if (graph.getParent() != null) {
            ElkGraphAdapters.ElkGraphAdapter graphAdapter = ElkGraphAdapters.adapt((ElkNode)graph.getParent());
            ElkGraphAdapters.ElkNodeAdapter nodeAdapter = ElkGraphAdapters.adaptSingleNode((ElkNode)graph);
            KVector minSize2 = NodeLabelAndSizeCalculator.process((GraphAdapters.GraphAdapter)graphAdapter, (GraphAdapters.NodeAdapter)nodeAdapter, (boolean)false, (boolean)true);
            minSize.x = Math.max(minSize.x, minSize2.x);
            minSize.y = Math.max(minSize.y, minSize2.y);
        }
        graph.setProperty(InternalProperties.MIN_WIDTH, (Object)minSize.x);
        graph.setProperty(InternalProperties.MIN_HEIGHT, (Object)minSize.y);
        progressMonitor.done();
    }
}

