/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.graphviz.dot.formatting2;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.elk.alg.graphviz.dot.dot.Attribute;
import org.eclipse.elk.alg.graphviz.dot.dot.AttributeStatement;
import org.eclipse.elk.alg.graphviz.dot.dot.DotPackage;
import org.eclipse.elk.alg.graphviz.dot.dot.EdgeStatement;
import org.eclipse.elk.alg.graphviz.dot.dot.EdgeTarget;
import org.eclipse.elk.alg.graphviz.dot.dot.Graph;
import org.eclipse.elk.alg.graphviz.dot.dot.GraphvizModel;
import org.eclipse.elk.alg.graphviz.dot.dot.Node;
import org.eclipse.elk.alg.graphviz.dot.dot.NodeStatement;
import org.eclipse.elk.alg.graphviz.dot.dot.Port;
import org.eclipse.elk.alg.graphviz.dot.dot.Statement;
import org.eclipse.elk.alg.graphviz.dot.dot.Subgraph;
import org.eclipse.elk.alg.graphviz.dot.services.GraphvizDotGrammarAccess;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class GraphvizDotFormatter
extends AbstractFormatter2 {
    @Inject
    @Extension
    private GraphvizDotGrammarAccess _graphvizDotGrammarAccess;

    protected void _format(GraphvizModel graphvizModel, @Extension IFormattableDocument document) {
        IHiddenRegion region = this.textRegionExtensions.previousHiddenRegion((EObject)graphvizModel);
        while (region != null) {
            Procedures.Procedure1 _function = it -> it.autowrap();
            document.set(region, _function);
            region = region.getNextHiddenRegion();
        }
        EList<Graph> _graphs = graphvizModel.getGraphs();
        for (Graph graph : _graphs) {
            Procedures.Procedure1 _function = it -> it.newLine();
            document.append((EObject)graph, _function);
            document.format((Object)graph);
        }
    }

    protected void _format(Graph graph, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)graph).feature((EStructuralFeature)DotPackage.Literals.GRAPH__TYPE), _function);
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        Procedures.Procedure1 _function_2 = it -> it.newLine();
        Procedures.Procedure1 _function_3 = it -> it.indent();
        document.interior(document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)graph).keyword("{"), _function_1), _function_2), this.textRegionExtensions.regionFor((EObject)graph).keyword("}"), _function_3);
        EList<Statement> _statements = graph.getStatements();
        for (Statement statement : _statements) {
            Procedures.Procedure1 _function_4 = it -> it.newLine();
            document.append((EObject)statement, _function_4);
            document.format((Object)statement);
        }
    }

    protected void _format(Attribute attribute, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.noSpace();
        document.prepend(this.textRegionExtensions.regionFor((EObject)attribute).keyword(";"), _function);
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)attribute).keyword("="), _function_1);
    }

    protected void _format(NodeStatement nodeStatement, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.noSpace();
        document.prepend(this.textRegionExtensions.regionFor((EObject)nodeStatement).keyword(";"), _function);
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        Procedures.Procedure1 _function_2 = it -> it.noSpace();
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)nodeStatement).keyword("["), _function_1), _function_2);
        Procedures.Procedure1 _function_3 = it -> it.noSpace();
        document.prepend(this.textRegionExtensions.regionFor((EObject)nodeStatement).keyword("]"), _function_3);
        Consumer<ISemanticRegion> _function_4 = it -> {
            Procedures.Procedure1 _function_5 = it_1 -> it_1.noSpace();
            Procedures.Procedure1 _function_6 = it_1 -> it_1.oneSpace();
            document.append(document.prepend(it, _function_5), _function_6);
        };
        this.textRegionExtensions.regionFor((EObject)nodeStatement).keywords(new String[]{","}).forEach(_function_4);
        Node _node = nodeStatement.getNode();
        if (_node != null) {
            document.format((Object)_node);
        }
        EList<Attribute> _attributes = nodeStatement.getAttributes();
        for (Attribute attribute : _attributes) {
            document.format((Object)attribute);
        }
    }

    protected void _format(Node node, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.noSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)node).keyword(":"), _function);
        Port _port = node.getPort();
        if (_port != null) {
            document.format((Object)_port);
        }
    }

    protected void _format(EdgeStatement edgeStatement, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.noSpace();
        document.prepend(this.textRegionExtensions.regionFor((EObject)edgeStatement).keyword(";"), _function);
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        Procedures.Procedure1 _function_2 = it -> it.noSpace();
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)edgeStatement).keyword("["), _function_1), _function_2);
        Procedures.Procedure1 _function_3 = it -> it.noSpace();
        document.prepend(this.textRegionExtensions.regionFor((EObject)edgeStatement).keyword("]"), _function_3);
        Consumer<ISemanticRegion> _function_4 = it -> {
            Procedures.Procedure1 _function_5 = it_1 -> it_1.noSpace();
            Procedures.Procedure1 _function_6 = it_1 -> it_1.oneSpace();
            document.append(document.prepend(it, _function_5), _function_6);
        };
        this.textRegionExtensions.regionFor((EObject)edgeStatement).keywords(new String[]{","}).forEach(_function_4);
        Node _sourceNode = edgeStatement.getSourceNode();
        if (_sourceNode != null) {
            document.format((Object)_sourceNode);
        }
        EList<EdgeTarget> _edgeTargets = edgeStatement.getEdgeTargets();
        for (EdgeTarget target : _edgeTargets) {
            Procedures.Procedure1 _function_5 = it -> it.oneSpace();
            document.prepend((EObject)target, _function_5);
            document.format((Object)target);
        }
        EList<Attribute> _attributes = edgeStatement.getAttributes();
        for (Attribute attribute : _attributes) {
            document.format((Object)attribute);
        }
    }

    protected void _format(EdgeTarget edgeTarget, @Extension IFormattableDocument document) {
        Node _targetnode;
        Procedures.Procedure1 _function = it -> it.oneSpace();
        document.append(this.textRegionExtensions.regionFor((EObject)edgeTarget).feature((EStructuralFeature)DotPackage.Literals.EDGE_TARGET__OPERATOR), _function);
        Subgraph _targetSubgraph = edgeTarget.getTargetSubgraph();
        if (_targetSubgraph != null) {
            document.format((Object)_targetSubgraph);
        }
        if ((_targetnode = edgeTarget.getTargetnode()) != null) {
            document.format((Object)_targetnode);
        }
    }

    protected void _format(AttributeStatement attributeStatement, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.noSpace();
        document.prepend(this.textRegionExtensions.regionFor((EObject)attributeStatement).keyword(";"), _function);
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        Procedures.Procedure1 _function_2 = it -> it.noSpace();
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)attributeStatement).keyword("["), _function_1), _function_2);
        Procedures.Procedure1 _function_3 = it -> it.noSpace();
        document.prepend(this.textRegionExtensions.regionFor((EObject)attributeStatement).keyword("]"), _function_3);
        Consumer<ISemanticRegion> _function_4 = it -> {
            Procedures.Procedure1 _function_5 = it_1 -> it_1.noSpace();
            Procedures.Procedure1 _function_6 = it_1 -> it_1.oneSpace();
            document.append(document.prepend(it, _function_5), _function_6);
        };
        this.textRegionExtensions.regionFor((EObject)attributeStatement).keywords(new String[]{","}).forEach(_function_4);
        EList<Attribute> _attributes = attributeStatement.getAttributes();
        for (Attribute attribute : _attributes) {
            document.format((Object)attribute);
        }
    }

    protected void _format(Subgraph subgraph, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.noSpace();
        document.prepend(this.textRegionExtensions.regionFor((EObject)subgraph).keyword(";"), _function);
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        document.append(this.textRegionExtensions.regionFor((EObject)subgraph).keyword(this._graphvizDotGrammarAccess.getSubgraphAccess().getSubgraphKeyword_1_0()), _function_1);
        Procedures.Procedure1 _function_2 = it -> it.oneSpace();
        Procedures.Procedure1 _function_3 = it -> it.newLine();
        Procedures.Procedure1 _function_4 = it -> it.indent();
        document.interior(document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)subgraph).keyword("{"), _function_2), _function_3), this.textRegionExtensions.regionFor((EObject)subgraph).keyword("}"), _function_4);
        EList<Statement> _statements = subgraph.getStatements();
        for (Statement statement : _statements) {
            Procedures.Procedure1 _function_5 = it -> it.newLine();
            document.append((EObject)statement, _function_5);
            document.format((Object)statement);
        }
    }

    protected void _format(Port port, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.noSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)port).keyword(":"), _function);
    }

    @XbaseGenerated
    public void format(Object attribute, IFormattableDocument document) {
        if (attribute instanceof XtextResource) {
            this._format((XtextResource)attribute, document);
            return;
        }
        if (attribute instanceof Attribute) {
            this._format((Attribute)attribute, document);
            return;
        }
        if (attribute instanceof AttributeStatement) {
            this._format((AttributeStatement)attribute, document);
            return;
        }
        if (attribute instanceof EdgeStatement) {
            this._format((EdgeStatement)attribute, document);
            return;
        }
        if (attribute instanceof NodeStatement) {
            this._format((NodeStatement)attribute, document);
            return;
        }
        if (attribute instanceof Subgraph) {
            this._format((Subgraph)attribute, document);
            return;
        }
        if (attribute instanceof EdgeTarget) {
            this._format((EdgeTarget)attribute, document);
            return;
        }
        if (attribute instanceof Graph) {
            this._format((Graph)attribute, document);
            return;
        }
        if (attribute instanceof GraphvizModel) {
            this._format((GraphvizModel)attribute, document);
            return;
        }
        if (attribute instanceof Node) {
            this._format((Node)attribute, document);
            return;
        }
        if (attribute instanceof Port) {
            this._format((Port)attribute, document);
            return;
        }
        if (attribute instanceof EObject) {
            this._format((EObject)attribute, document);
            return;
        }
        if (attribute == null) {
            this._format(null, document);
            return;
        }
        if (attribute != null) {
            this._format(attribute, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(attribute, document).toString());
    }
}

