/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.editors;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.ActionConstants;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.process.ReplyProcess;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.PlatformUI;

class ReplyHandler
extends Action {
    private GerritClient fGerritClient;
    private ChangeInfo fChangeInfo;
    private String fLabelText;
    private int maxValue;

    ReplyHandler(ChangeInfo changeInfo, GerritClient gerritClient, String labelText) {
        this.fGerritClient = gerritClient;
        this.fChangeInfo = changeInfo;
        String actionLabel = labelText;
        if (!labelText.equals(ReplyProcess.REPLY_ALL_BUTTONS) && !labelText.equals(ActionConstants.REPLY.getLiteral())) {
            this.maxValue = this.fChangeInfo.getPermittedMaxValue(labelText);
            actionLabel = String.valueOf(labelText) + "  +" + this.maxValue;
        }
        this.fLabelText = labelText;
        this.setText(actionLabel);
    }

    public void run() {
        ReplyProcess replyProcess = new ReplyProcess();
        TreeMap<String, Integer> mapLabels = new TreeMap<String, Integer>();
        if (this.fLabelText.equals(ActionConstants.REPLY.getLiteral())) {
            replyProcess.handleReplyDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.fChangeInfo, this.fGerritClient, this.fChangeInfo.getUserSelectedRevision(), null);
            return;
        }
        if (this.fLabelText.equals(ReplyProcess.REPLY_ALL_BUTTONS)) {
            String loginUser = this.fGerritClient.getRepository().getServerInfo().getUserName();
            Map labelsToSet = this.fChangeInfo.getLabelsNotAtMax(loginUser);
            for (Map.Entry entry : labelsToSet.entrySet()) {
                mapLabels.put((String)entry.getKey(), (Integer)entry.getValue());
            }
        } else {
            mapLabels.put(this.fLabelText, this.maxValue);
        }
        if (!mapLabels.isEmpty()) {
            replyProcess.handleReplyVotes(this.fChangeInfo, mapLabels, this.fGerritClient);
        }
    }
}

