/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.model;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.egerrit.internal.model.AccountInfo;
import org.eclipse.egerrit.internal.model.ActionConstants;
import org.eclipse.egerrit.internal.model.ActionInfo;
import org.eclipse.egerrit.internal.model.ApprovalInfo;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.ChangeMessageInfo;
import org.eclipse.egerrit.internal.model.LabelInfo;
import org.eclipse.egerrit.internal.model.ModelFactory;
import org.eclipse.egerrit.internal.model.ModelPackage;
import org.eclipse.egerrit.internal.model.ReviewerInfo;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.model.impl.ChangeInfoImpl;
import org.eclipse.egerrit.internal.model.impl.StringToActionInfoImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EContentAdapter;

public class ModifiedChangeInfoImpl
extends ChangeInfoImpl {
    private static final ApprovalInfo NO_VOTE = ModelFactory.eINSTANCE.createApprovalInfo();
    private static final Pattern COMMENT_PATTERN = Pattern.compile("(\\d+ comme[nt])(\\w+)");

    public ModifiedChangeInfoImpl() {
        this.eAdapters().add((Object)new EContentAdapter(){
            {
                ModifiedChangeInfoImpl.this.eAdapters().add((Object)this);
            }

            public void notifyChanged(Notification msg) {
                InternalEObject modifiedFileInfo;
                super.notifyChanged(msg);
                if (msg.getFeature() == null) {
                    return;
                }
                if (msg.getFeature().equals(ModelPackage.Literals.CHANGE_INFO__CURRENT_REVISION)) {
                    InternalEObject modifiedChangeInfo = (InternalEObject)msg.getNotifier();
                    ModifiedChangeInfoImpl.this.notifySet(modifiedChangeInfo, (EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__REVISION);
                }
                if (msg.getFeature().equals(ModelPackage.Literals.CHANGE_INFO__REVISIONS)) {
                    ModifiedChangeInfoImpl.this.deriveCommentPresence();
                }
                if (msg.getFeature().equals(ModelPackage.Literals.CHANGE_INFO__MESSAGES)) {
                    ModifiedChangeInfoImpl.this.deriveCommentPresence();
                }
                if (msg.getFeature().equals(ModelPackage.Literals.FILE_INFO__DRAFT_COMMENTS)) {
                    modifiedFileInfo = (InternalEObject)msg.getNotifier();
                    if (ModifiedChangeInfoImpl.this.eNotificationRequired()) {
                        modifiedFileInfo.eNotify((Notification)new ENotificationImpl(modifiedFileInfo, 1, (EStructuralFeature)ModelPackage.Literals.FILE_INFO__DRAFTS_COUNT, null, modifiedFileInfo.eGet((EStructuralFeature)ModelPackage.Literals.FILE_INFO__DRAFTS_COUNT)));
                    }
                }
                if (msg.getFeature().equals(ModelPackage.Literals.FILE_INFO__COMMENTS)) {
                    modifiedFileInfo = (InternalEObject)msg.getNotifier();
                    if (ModifiedChangeInfoImpl.this.eNotificationRequired()) {
                        modifiedFileInfo.eNotify((Notification)new ENotificationImpl(modifiedFileInfo, 1, (EStructuralFeature)ModelPackage.Literals.FILE_INFO__COMMENTS_COUNT, null, modifiedFileInfo.eGet((EStructuralFeature)ModelPackage.Literals.FILE_INFO__COMMENTS_COUNT)));
                    }
                }
                if (msg.getFeature().equals(ModelPackage.Literals.REVISION_INFO__ACTIONS)) {
                    this.recomputeRevisionInfoActions(msg);
                }
                if (msg.getFeature().equals(ModelPackage.Literals.CHANGE_INFO__ACTIONS)) {
                    this.recomputeChangeInfoActions(msg);
                }
                if (msg.getFeature().equals(ModelPackage.Literals.CHANGE_INFO__REMOVABLE_REVIEWERS)) {
                    this.recomputeChangeInfoRemovalReviewer(msg);
                }
            }

            private void recomputeChangeInfoRemovalReviewer(Notification msg) {
                InternalEObject modifiedChangeInfo = (InternalEObject)msg.getNotifier();
                if (msg.getEventType() == 3 || msg.getEventType() == 5) {
                    ModifiedChangeInfoImpl.this.deriveReviewerRemovalPresence();
                }
            }

            private void recomputeChangeInfoActions(Notification msg) {
                InternalEObject modifiedChangeInfo = (InternalEObject)msg.getNotifier();
                if (msg.getEventType() == 6 || msg.getEventType() == 5) {
                    ModifiedChangeInfoImpl.this.notifySet(modifiedChangeInfo, (EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__REVERTABLE);
                    ModifiedChangeInfoImpl.this.notifySet(modifiedChangeInfo, (EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__ABANDONABLE);
                    ModifiedChangeInfoImpl.this.notifySet(modifiedChangeInfo, (EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__RESTOREABLE);
                    ModifiedChangeInfoImpl.this.notifySet(modifiedChangeInfo, (EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__DELETEABLE);
                }
                if (msg.getEventType() == 3) {
                    String actionName = ((StringToActionInfoImpl)((Object)msg.getNewValue())).getKey();
                    if (actionName.equals(ActionConstants.REVERT.getName())) {
                        ModifiedChangeInfoImpl.this.notifySet(modifiedChangeInfo, (EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__REVERTABLE);
                    }
                    if (actionName.equals(ActionConstants.ABANDON.getName())) {
                        ModifiedChangeInfoImpl.this.notifySet(modifiedChangeInfo, (EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__ABANDONABLE);
                    }
                    if (actionName.equals(ActionConstants.RESTORE.getName())) {
                        ModifiedChangeInfoImpl.this.notifySet(modifiedChangeInfo, (EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__RESTOREABLE);
                    }
                    if ("/".equals(actionName)) {
                        ModifiedChangeInfoImpl.this.notifySet(modifiedChangeInfo, (EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__DELETEABLE);
                    }
                }
            }

            private void recomputeRevisionInfoActions(Notification msg) {
                InternalEObject modifiedRevision = (InternalEObject)msg.getNotifier();
                if (msg.getEventType() == 6 || msg.getEventType() == 5) {
                    ModifiedChangeInfoImpl.this.notifySet(modifiedRevision, (EStructuralFeature)ModelPackage.Literals.REVISION_INFO__REBASEABLE);
                    ModifiedChangeInfoImpl.this.notifySet(modifiedRevision, (EStructuralFeature)ModelPackage.Literals.REVISION_INFO__SUBMITABLE);
                    ModifiedChangeInfoImpl.this.notifySet(modifiedRevision, (EStructuralFeature)ModelPackage.Literals.REVISION_INFO__CHERRYPICKABLE);
                    ModifiedChangeInfoImpl.this.notifySet(modifiedRevision, (EStructuralFeature)ModelPackage.Literals.REVISION_INFO__DELETEABLE);
                    ModifiedChangeInfoImpl.this.notifySet(modifiedRevision, (EStructuralFeature)ModelPackage.Literals.REVISION_INFO__PUBLISHABLE);
                }
                if (msg.getEventType() == 3) {
                    String actionName = ((StringToActionInfoImpl)((Object)msg.getNewValue())).getKey();
                    if (actionName.equals(ActionConstants.REBASE.getName())) {
                        ModifiedChangeInfoImpl.this.notifySet(modifiedRevision, (EStructuralFeature)ModelPackage.Literals.REVISION_INFO__REBASEABLE);
                    }
                    if (actionName.equals(ActionConstants.SUBMIT.getName())) {
                        ModifiedChangeInfoImpl.this.notifySet(modifiedRevision, (EStructuralFeature)ModelPackage.Literals.REVISION_INFO__SUBMITABLE);
                    }
                    if (actionName.equals(ActionConstants.CHERRYPICK.getName())) {
                        ModifiedChangeInfoImpl.this.notifySet(modifiedRevision, (EStructuralFeature)ModelPackage.Literals.REVISION_INFO__CHERRYPICKABLE);
                    }
                    if ("/".equals(actionName)) {
                        ModifiedChangeInfoImpl.this.notifySet(modifiedRevision, (EStructuralFeature)ModelPackage.Literals.REVISION_INFO__DELETEABLE);
                    }
                    if (actionName.equals(ActionConstants.PUBLISH.getName())) {
                        ModifiedChangeInfoImpl.this.notifySet(modifiedRevision, (EStructuralFeature)ModelPackage.Literals.REVISION_INFO__PUBLISHABLE);
                    }
                }
            }

            private InternalEObject getModifiedChangeInfo(Object object) {
                if (object instanceof ChangeInfo) {
                    return (InternalEObject)object;
                }
                return this.getModifiedChangeInfo(((EObject)object).eContainer());
            }
        });
    }

    private void notifySet(InternalEObject modifiedObject, EStructuralFeature attr) {
        if (this.eNotificationRequired()) {
            modifiedObject.eNotify((Notification)new ENotificationImpl(modifiedObject, 1, attr, null, modifiedObject.eGet(attr)));
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeInfo other = (ChangeInfo)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    @Override
    public RevisionInfo basicGetRevision() {
        return (RevisionInfo)this.getRevisions().get((Object)this.getCurrent_revision());
    }

    @Override
    public RevisionInfo basicGetLatestPatchSet() {
        Collection revisions = this.getRevisions().values();
        RevisionInfo match = null;
        int topNumber = 0;
        for (RevisionInfo candidate : revisions) {
            if (candidate.get_number() <= topNumber) continue;
            topNumber = candidate.get_number();
            match = candidate;
        }
        return match;
    }

    @Override
    public RevisionInfo getRevisionByNumber(int revisionNumber) {
        Collection revisions = this.getRevisions().values();
        for (RevisionInfo candidate : revisions) {
            if (candidate.get_number() != revisionNumber) continue;
            return candidate;
        }
        return null;
    }

    @Override
    public boolean isActionAllowed(String action) {
        ActionInfo actionInfo;
        EMap<String, ActionInfo> actionsAvailable = this.getActions();
        if (actionsAvailable != null && (actionInfo = (ActionInfo)actionsAvailable.get((Object)action)) != null) {
            return actionInfo.isEnabled();
        }
        return false;
    }

    @Override
    public boolean isRevertable() {
        return this.isActionAllowed(ActionConstants.REVERT.getName());
    }

    @Override
    public boolean isAbandonable() {
        return this.isActionAllowed(ActionConstants.ABANDON.getName());
    }

    @Override
    public boolean isRestoreable() {
        return this.isActionAllowed(ActionConstants.RESTORE.getName());
    }

    @Override
    public boolean isDeleteable() {
        return this.isActionAllowed("/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserSelectedRevision(RevisionInfo newUserSelectedRevision) {
        if (newUserSelectedRevision == null) {
            return;
        }
        ModifiedChangeInfoImpl modifiedChangeInfoImpl = this;
        synchronized (modifiedChangeInfoImpl) {
            if (this.userSelectedRevision == null) {
                super.setUserSelectedRevision(newUserSelectedRevision);
                return;
            }
            if (this.userSelectedRevision.get_number() != newUserSelectedRevision.get_number()) {
                super.setUserSelectedRevision(newUserSelectedRevision);
            }
        }
    }

    @Override
    public void setUpdated(String newUpdated) {
        if (this.updated == null) {
            super.setUpdated(newUpdated);
            return;
        }
        if (!this.updated.equals(newUpdated)) {
            super.setUpdated(newUpdated);
        }
    }

    @Override
    public ApprovalInfo getMostRelevantVote(String label) {
        if (this.labels == null) {
            return NO_VOTE;
        }
        LabelInfo labelInfo = (LabelInfo)this.labels.get((Object)label);
        if (labelInfo == null) {
            return NO_VOTE;
        }
        if (labelInfo.getRejected() != null) {
            return this.fromVoteToValue(labelInfo, labelInfo.getRejected());
        }
        if (labelInfo.getApproved() != null) {
            return this.fromVoteToValue(labelInfo, labelInfo.getApproved());
        }
        if (labelInfo.getDisliked() != null) {
            return this.fromVoteToValue(labelInfo, labelInfo.getDisliked());
        }
        if (labelInfo.getRecommended() != null) {
            return this.fromVoteToValue(labelInfo, labelInfo.getRecommended());
        }
        return NO_VOTE;
    }

    private ApprovalInfo fromVoteToValue(LabelInfo match, AccountInfo voter) {
        for (ApprovalInfo candidate : match.getAll()) {
            if (candidate.get_account_id() != voter.get_account_id()) continue;
            return candidate;
        }
        return NO_VOTE;
    }

    private void deriveCommentPresence() {
        EList<ChangeMessageInfo> messages = this.getMessages();
        for (ChangeMessageInfo m : messages) {
            RevisionInfo rev;
            m.setComment(this.hasComments(m.getMessage()));
            if (!m.isComment() || (rev = ((ChangeInfo)m.eContainer()).getRevisionByNumber(m.get_revision_number())) == null) continue;
            rev.setCommented(m.isComment());
        }
    }

    private void deriveReviewerRemovalPresence() {
        EList<AccountInfo> removalList = this.getRemovable_reviewers();
        EList<ReviewerInfo> reviewersInfo = this.getComputedReviewers();
        int i = 0;
        while (i < removalList.size()) {
            for (ReviewerInfo revInfo : reviewersInfo) {
                if (revInfo.get_account_id() != ((AccountInfo)removalList.get(i)).get_account_id()) continue;
                revInfo.setDeleteable(true);
            }
            ++i;
        }
    }

    private boolean hasComments(String msg) {
        if (msg == null) {
            return false;
        }
        Matcher matcher = COMMENT_PATTERN.matcher(msg.toLowerCase());
        return matcher.find(0);
    }

    @Override
    public int getLabelMinValue(String label) {
        int min = 0;
        EMap<String, LabelInfo> allLabels = this.getLabels();
        if (allLabels != null) {
            LabelInfo info = (LabelInfo)this.getLabels().get((Object)label);
            if (info == null) {
                return min;
            }
            Set possibleValues = info.getValues().keySet();
            for (String value : possibleValues) {
                min = Math.min(min, Integer.parseInt(value.trim()));
            }
        }
        return min;
    }

    @Override
    public int getLabelMaxValue(String label) {
        int max = 0;
        EMap<String, LabelInfo> mapLabels = this.getLabels();
        if (mapLabels != null) {
            LabelInfo info = (LabelInfo)mapLabels.get((Object)label);
            if (info == null) {
                return max;
            }
            Set possibleValues = info.getValues().keySet();
            for (String value : possibleValues) {
                max = Math.max(max, Integer.parseInt(value.trim()));
            }
        }
        return max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RevisionInfo getUserSelectedRevision() {
        ModifiedChangeInfoImpl modifiedChangeInfoImpl = this;
        synchronized (modifiedChangeInfoImpl) {
            return super.getUserSelectedRevision();
        }
    }

    @Override
    public int getPermittedMaxValue(String label) {
        EList listPermitted;
        int maxPermitted = Integer.MIN_VALUE;
        EMap<String, EList<String>> listLabels = this.getPermitted_labels();
        if (!listLabels.isEmpty() && (listPermitted = (EList)listLabels.get((Object)label)) != null && !listPermitted.isEmpty()) {
            for (String value : listPermitted) {
                maxPermitted = Math.max(maxPermitted, new Integer(value.trim()));
            }
        }
        return maxPermitted;
    }

    @Override
    public Map<String, EList<String>> getSortedPermittedLabels() {
        TreeMap<String, EList<String>> sortedPermitted = new TreeMap<String, EList<String>>();
        for (Map.Entry permittedlabel : this.getPermitted_labels()) {
            sortedPermitted.put((String)permittedlabel.getKey(), (EList<String>)((EList)permittedlabel.getValue()));
        }
        return sortedPermitted;
    }

    @Override
    public Map<String, Integer> getAllowedLabelsMaxValue() {
        TreeMap<String, Integer> mapLabels = new TreeMap<String, Integer>();
        for (Map.Entry permittedlabel : this.getPermitted_labels().entrySet()) {
            int maxPermitted = this.getPermittedMaxValue((String)permittedlabel.getKey());
            if (maxPermitted <= 0) continue;
            mapLabels.put((String)permittedlabel.getKey(), maxPermitted);
        }
        return mapLabels;
    }

    @Override
    public Map<String, Integer> getUserLastLabelSet(String user) {
        LinkedHashMap<String, Integer> userVotes = new LinkedHashMap<String, Integer>();
        EMap<String, LabelInfo> labelsInfo = this.getLabels();
        if (labelsInfo != null && !labelsInfo.isEmpty()) {
            for (Map.Entry entrylabel : labelsInfo.entrySet()) {
                LabelInfo labelInfo = (LabelInfo)entrylabel.getValue();
                EList<ApprovalInfo> listApproval = labelInfo.getAll();
                if (listApproval == null || listApproval.isEmpty()) continue;
                ApprovalInfo candidate = null;
                for (ApprovalInfo oneApproval : listApproval) {
                    if (!user.equals(oneApproval.getEmail()) && !user.equals(oneApproval.getUsername()) || candidate != null) continue;
                    candidate = oneApproval;
                    break;
                }
                if (candidate == null) continue;
                userVotes.put((String)entrylabel.getKey(), candidate.getValue());
            }
        }
        return userVotes;
    }

    @Override
    public Map<String, Integer> getLabelsNotAtMax(String loginUser) {
        TreeMap<String, Integer> modifiedAllowed = new TreeMap<String, Integer>();
        Iterator<Map.Entry<String, Integer>> iter = this.getAllowedLabelsMaxValue().entrySet().iterator();
        Map<String, Integer> userVotes = this.getUserLastLabelSet(loginUser);
        while (iter.hasNext()) {
            int permittedMax;
            Map.Entry<String, Integer> entry = iter.next();
            int currentValue = -1;
            if (!userVotes.isEmpty()) {
                currentValue = userVotes.get(entry.getKey());
            }
            if (currentValue == (permittedMax = this.getPermittedMaxValue(entry.getKey()))) continue;
            modifiedAllowed.put(entry.getKey(), entry.getValue());
        }
        return modifiedAllowed;
    }
}

