/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.process;

import java.util.concurrent.CompletableFuture;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.core.command.SubmitCommand;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.core.rest.SubmitInput;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.ui.editors.QueryHelpers;
import org.eclipse.egerrit.internal.ui.editors.RefreshRelatedEditors;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.jface.dialogs.MessageDialog;

public class SubmitProcess {
    public void handleSubmit(ChangeInfo changeInfo, GerritClient gerritClient) {
        SubmitCommand submitCmd = gerritClient.submit(changeInfo.getId());
        SubmitInput submitInput = new SubmitInput();
        submitInput.setWait_for_merge(true);
        submitCmd.setCommandInput((Object)submitInput);
        CompletableFuture.runAsync(() -> {
            try {
                submitCmd.call();
            }
            catch (EGerritException e) {
                EGerritCorePlugin.logError((String)(String.valueOf(gerritClient.getRepository().formatGerritVersion()) + e.getMessage()));
                MessageDialog.open((int)2, null, (String)Messages.SubmitProcess_failed, (String)e.getLocalizedMessage(), (int)0);
            }
        }).thenRun(() -> {
            QueryHelpers.loadBasicInformation(gerritClient, changeInfo, false);
            new RefreshRelatedEditors(changeInfo, gerritClient).schedule();
        });
    }
}

