/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.emf.edit.ui;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.fx.ui.controls.tree.SortableTreeItem;

public class AdapterFactoryTreeItem<T>
extends SortableTreeItem<T> {
    private final AdapterFactory adapterFactory;
    private final ITreeItemContentProvider provider;
    private AdapterImpl adapter = null;
    private INotifyChangedListener changeListener = null;

    public AdapterFactoryTreeItem(T value, AdapterFactory adapterFactory) {
        super(value);
        this.adapterFactory = adapterFactory;
        Object contentProvider = adapterFactory.adapt(value, ITreeItemContentProvider.class);
        if (!(contentProvider instanceof ITreeItemContentProvider)) {
            throw new IllegalArgumentException("Provided root object cannot be adapted.");
        }
        this.provider = (ITreeItemContentProvider)contentProvider;
        if (this.provider instanceof IChangeNotifier) {
            ((IChangeNotifier)this.provider).addListener(this.createNotifyChangedListener());
        } else if (value instanceof Notifier) {
            ((Notifier)value).eAdapters().add((Object)this.createAdapter());
        }
        this.initializeChildren();
    }

    private INotifyChangedListener createNotifyChangedListener() {
        if (this.changeListener == null) {
            this.changeListener = new INotifyChangedListener(){

                public void notifyChanged(Notification msg) {
                    if (!msg.isTouch() && msg.getFeature() instanceof EReference) {
                        if (msg instanceof IViewerNotification) {
                            this.processViewerNotification((IViewerNotification)msg);
                        } else {
                            AdapterFactoryTreeItem.this.updateChildren(msg);
                        }
                    }
                }

                private void processViewerNotification(IViewerNotification notification) {
                    if (notification.getElement() == null) {
                        return;
                    }
                    if (AdapterFactoryTreeItem.this.getValue().equals(notification.getElement())) {
                        AdapterFactoryTreeItem.this.updateChildren((Notification)notification);
                    }
                }
            };
        }
        return this.changeListener;
    }

    private AdapterImpl createAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (!msg.isTouch() && msg.getFeature() instanceof EReference) {
                        AdapterFactoryTreeItem.this.updateChildren(msg);
                    }
                }
            };
        }
        return this.adapter;
    }

    public void dispose() {
        super.getInternalChildren().forEach(childItem -> ((AdapterFactoryTreeItem)((Object)childItem)).dispose());
        if (this.changeListener != null) {
            ((IChangeNotifier)this.provider).removeListener(this.changeListener);
        }
        if (this.adapter != null) {
            ((Notifier)this.getValue()).eAdapters().remove((Object)this.adapter);
        }
    }

    void initializeChildren() {
        for (Object child : this.provider.getChildren(this.getValue())) {
            this.addNewChild(child, -1);
        }
    }

    void updateChildren(Notification msg) {
        ObservableList childTreeItems = super.getInternalChildren();
        switch (msg.getEventType()) {
            case 3: {
                this.addNewChild(msg.getNewValue(), msg.getPosition());
                break;
            }
            case 5: {
                List newValues = (List)msg.getNewValue();
                int position = msg.getPosition();
                if (position != -1 && position <= childTreeItems.size()) {
                    Collections.reverse(newValues);
                }
                newValues.forEach(newValue -> this.addNewChild(newValue, position));
                break;
            }
            case 4: {
                this.removeChild(msg.getOldValue());
                break;
            }
            case 6: {
                List oldValues = (List)msg.getOldValue();
                oldValues.forEach(oldValue -> this.removeChild(oldValue));
                break;
            }
            case 1: {
                childTreeItems.clear();
                this.initializeChildren();
                break;
            }
            case 9: {
                this.initializeChildren();
                break;
            }
            case 7: {
                int index = (Integer)msg.getOldValue();
                if (index < 0 || index >= childTreeItems.size()) break;
                TreeItem treeItem = (TreeItem)childTreeItems.get(index);
                childTreeItems.remove((Object)treeItem);
                childTreeItems.add(msg.getPosition(), (Object)treeItem);
            }
        }
    }

    private void addNewChild(Object value, int position) {
        if (!this.provider.getChildren(this.getValue()).contains(value)) {
            return;
        }
        ObservableList childTreeItems = super.getInternalChildren();
        AdapterFactoryTreeItem<Object> newTreeItem = new AdapterFactoryTreeItem<Object>(value, this.adapterFactory);
        if (position == -1 || position > childTreeItems.size()) {
            childTreeItems.add(newTreeItem);
        } else {
            childTreeItems.add(position, newTreeItem);
        }
    }

    private void removeChild(Object value) {
        TreeItem<T> treeItem = this.findTreeItemForValue(value);
        if (treeItem != null) {
            ((AdapterFactoryTreeItem)treeItem).dispose();
            super.getInternalChildren().remove(treeItem);
        }
    }

    private TreeItem<T> findTreeItemForValue(Object value) {
        Optional<TreeItem> first = super.getInternalChildren().stream().filter(item -> item.getValue().equals(value)).findFirst();
        return first.orElse(null);
    }
}

