/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.observable;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.observable.ValueObservable;
import org.eclipse.jdt.annotation.Nullable;

public class BaseValueObservable<T>
implements ValueObservable<T> {
    private List<ValueObservable.ChangeSubscription<T>> subscriptions;
    private T value;
    private boolean disposed;

    public BaseValueObservable(T value) {
        this.value = value;
    }

    @Override
    public void setValue(T value) {
        if (this.disposed) {
            throw new IllegalStateException("Observable is disposed");
        }
        this.value = value;
        this.notifyChange(this.value, this.value);
    }

    @Override
    public T getValue() {
        return this.value;
    }

    private void notifyChange(T oldValue, T newValue) {
        if (this.subscriptions != null) {
            new ArrayList<ValueObservable.ChangeSubscription<T>>(this.subscriptions).stream().forEach(s -> s.handle(this, oldValue, newValue));
        }
    }

    @Override
    public Subscription onValueChange(ValueObservable.ChangeSubscription<T> c) {
        if (this.disposed) {
            throw new IllegalStateException("Observable is disposed");
        }
        if (this.subscriptions == null) {
            this.subscriptions = new ArrayList<ValueObservable.ChangeSubscription<T>>();
        }
        this.subscriptions.add(c);
        return () -> {
            boolean bl = this.subscriptions.remove(c);
        };
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public void dispose() {
        this.disposed = true;
        if (this.subscriptions != null) {
            this.subscriptions = null;
        }
    }

    static class NullBaseValueObservable<@Nullable T>
    extends BaseValueObservable<T> {
        public NullBaseValueObservable() {
            super(null);
        }
    }
}

