/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.bindings.internal;

import java.util.function.Function;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ObservableValue;

public class MapSimpleObjectBinding<A, B>
extends ObjectBinding<B> {
    private ObservableValue<A> source;
    private Function<A, B> map;
    private Observable next = null;

    public MapSimpleObjectBinding(ObservableValue<A> source, Function<A, B> map) {
        this.source = source;
        this.map = map;
        this.bind(new Observable[]{this.source});
    }

    protected B computeValue() {
        Object sourceVal;
        if (this.next != null) {
            this.unbind(new Observable[]{this.next});
        }
        if ((sourceVal = this.source.getValue()) != null) {
            B apply = this.map.apply(sourceVal);
            return apply;
        }
        return null;
    }

    public void dispose() {
        this.unbind(new Observable[]{this.source});
        super.dispose();
    }
}

