/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.base.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.fx.core.ObjectSerializer;
import org.eclipse.fx.core.adapter.AdapterService;
import org.eclipse.fx.core.command.CommandService;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CommandServiceImpl
implements CommandService {
    private final @NonNull ECommandService commandService;
    private final @NonNull EHandlerService handlerService;
    private final @NonNull IEclipseContext context;
    private final @NonNull ObjectSerializer serializer;
    private final @NonNull AdapterService adapterService;
    private boolean disposed;

    @Inject
    public CommandServiceImpl(@NonNull ECommandService commandService, @NonNull EHandlerService handlerService, @NonNull IEclipseContext context, @NonNull ObjectSerializer serializer, @NonNull AdapterService adapterService) {
        this.commandService = commandService;
        this.handlerService = handlerService;
        this.context = context;
        this.serializer = serializer;
        this.adapterService = adapterService;
    }

    @PreDestroy
    void dispose() {
        this.disposed = true;
    }

    public boolean exists(@NonNull String commandId) {
        if (this.disposed) {
            throw new IllegalStateException("Service is disposed");
        }
        return this.commandService.getCommand(commandId) != null;
    }

    public boolean canExecute(@NonNull String commandId, @NonNull Map<@NonNull String, @Nullable Object> parameters) {
        if (this.disposed) {
            throw new IllegalStateException("Service is disposed");
        }
        ParameterizedCommand cmd = this.commandService.createCommand(commandId, CommandServiceImpl.mapToString(this.adapterService, this.serializer, parameters));
        return this.handlerService.canExecute(cmd);
    }

    public <O> Optional<O> execute(@NonNull String commandId, @NonNull Map<@NonNull String, @Nullable Object> parameters) {
        if (this.disposed) {
            throw new IllegalStateException("Service is disposed");
        }
        ParameterizedCommand cmd = this.commandService.createCommand(commandId, CommandServiceImpl.mapToString(this.adapterService, this.serializer, parameters));
        return Optional.ofNullable(this.handlerService.executeHandler(cmd));
    }

    /*
     * Exception decompiling
     */
    private static Map<@NonNull String, @Nullable Object> mapToString(@NonNull AdapterService adapterService, @NonNull ObjectSerializer serializer, Map<@NonNull String, @Nullable Object> map) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 1 out of bounds for length 1
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance$Annotated$Iterator.moveParameterized(JavaGenericRefTypeInstance.java:113)
         *     at org.benf.cfr.reader.entities.attributes.TypePathPartParameterized.apply(TypePathPartParameterized.java:15)
         *     at org.benf.cfr.reader.bytecode.analysis.types.TypeAnnotationHelper.apply(TypeAnnotationHelper.java:54)
         *     at org.benf.cfr.reader.bytecode.analysis.types.TypeAnnotationHelper.apply(TypeAnnotationHelper.java:45)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.TypeAnnotationTransformer.handleStatement(TypeAnnotationTransformer.java:141)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:144)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:24)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIf.transformStructuredChildren(StructuredIf.java:96)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.expression.StructuredStatementExpression.applyExpressionRewriter(StructuredStatementExpression.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.TypeAnnotationTransformer.rewriteExpression(TypeAnnotationTransformer.java:67)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.LambdaExpression.applyExpressionRewriter(LambdaExpression.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.TypeAnnotationTransformer.rewriteExpression(TypeAnnotationTransformer.java:67)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.TypeAnnotationTransformer.rewriteExpression(TypeAnnotationTransformer.java:67)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.TypeAnnotationTransformer.rewriteExpression(TypeAnnotationTransformer.java:67)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.TypeAnnotationTransformer.rewriteExpression(TypeAnnotationTransformer.java:67)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.TypeAnnotationTransformer.transform(TypeAnnotationTransformer.java:61)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.TypeAnnotationTransformer.transform(TypeAnnotationTransformer.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.TypeAnnotationTransformer.transform(TypeAnnotationTransformer.java:55)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.applyTypeAnnotations(Op04StructuredStatement.java:733)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:957)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <O> Optional<org.eclipse.fx.core.command.Command<O>> createCommand(@NonNull String commandId) {
        if (this.disposed) {
            throw new IllegalStateException("Service is disposed");
        }
        Command command = this.commandService.getCommand(commandId);
        if (command == null || !command.isDefined()) {
            return Optional.empty();
        }
        CommandImpl c = new CommandImpl(commandId, this.context);
        ContextInjectionFactory.inject(c, (IEclipseContext)this.context);
        return Optional.of(c);
    }

    static class CommandImpl<O>
    implements org.eclipse.fx.core.command.Command<O> {
        private final String commandId;
        private CommandService commandService;
        private final IEclipseContext context;
        private ReadOnlyBooleanWrapper enabledProperty = new ReadOnlyBooleanWrapper((Object)this, "enabled");
        private final ObservableMap<String, String> parameters = FXCollections.observableMap(new HashMap());

        public CommandImpl(String commandId, IEclipseContext context) {
            this.commandId = commandId;
            this.context = context;
            this.parameters.addListener(o -> this.recalculateState());
        }

        @PostConstruct
        void init(IEventBroker eventBroker) {
            eventBroker.subscribe("org/eclipse/fx/context/key", e -> this.recalculateState());
            eventBroker.subscribe("org/eclipse/e4/ui/renderer/requestEnablementUpdate", e -> this.recalculateState());
            eventBroker.subscribe("org/eclipse/e4/ui/model/ui/Dirtyable/dirty/*", e -> this.recalculateState());
            this.context.runAndTrack(new RunAndTrack(){

                public boolean changed(IEclipseContext context) {
                    context.get("activeContexts");
                    context.get("org.eclipse.ui.selection");
                    context.get("e4ActivePart");
                    this.recalculateState();
                    return true;
                }
            });
        }

        public void evaluate() {
            this.recalculateState();
        }

        @Inject
        public void setCommandService(CommandService commandService) {
            this.commandService = commandService;
            this.recalculateState();
        }

        void recalculateState() {
            this.enabledProperty.set(this.commandService.canExecute(this.commandId, this.parameters));
        }

        public ReadOnlyBooleanProperty enabledProperty() {
            return this.enabledProperty.getReadOnlyProperty();
        }

        public boolean isEnabled() {
            return this.enabledProperty.get();
        }

        public Optional<O> execute() {
            return this.commandService.execute(this.commandId, this.parameters);
        }

        public ObservableMap<String, String> parameters() {
            return this.parameters;
        }
    }
}

