/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

public enum JavaVersion {
    JAVA5("Java 5", "1.5", "J2SE-1.5"),
    JAVA6("Java 6", "1.6", "JavaSE-1.6"),
    JAVA7("Java 7", "1.7", "JavaSE-1.7"),
    JAVA8("Java 8", "1.8", "JavaSE-1.8");

    private final String label;
    private final String qualifier;
    private final String bree;

    private JavaVersion(String label, String qualifier, String bree) {
        this.label = label;
        this.qualifier = qualifier;
        this.bree = bree;
    }

    public static JavaVersion fromQualifier(String qualifier) {
        for (JavaVersion version : JavaVersion.values()) {
            if (!version.qualifier.equals(qualifier)) continue;
            return version;
        }
        return null;
    }

    public static JavaVersion fromBree(String bree) {
        for (JavaVersion version : JavaVersion.values()) {
            if (!version.bree.equals(bree)) continue;
            return version;
        }
        return null;
    }

    public String getLabel() {
        return this.label;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getBree() {
        return this.bree;
    }

    public boolean isAtLeast(JavaVersion other) {
        return this.ordinal() >= other.ordinal();
    }
}

