/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.databinding.internal;

import java.text.MessageFormat;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class TemplateComputedValue
extends ComputedValue {
    private final @NonNull List<@NonNull Struct> values;
    private final @NonNull String template;
    private final @NonNull BiFunction<IValueProperty, Object, Object> converter;

    public TemplateComputedValue(@NonNull Object o, @NonNull String template, @NonNull IValueProperty[] properties) {
        this(o, template, properties, (p, v) -> v);
    }

    public TemplateComputedValue(@NonNull Object o, @NonNull String template, @NonNull IValueProperty[] properties, @NonNull BiFunction<@NonNull IValueProperty, @Nullable Object, @Nullable Object> converter) {
        this.template = template;
        this.values = Stream.of(properties).map(p -> new Struct((IValueProperty)p, o)).collect(Collectors.toList());
        this.converter = converter;
    }

    protected Object calculate() {
        Object[] v = this.values.stream().map(o -> this.converter.apply(o.property, o.value.getValue())).toArray();
        return MessageFormat.format(this.template, v);
    }

    public synchronized void dispose() {
        super.dispose();
        this.values.forEach(v -> v.value.dispose());
    }

    static final class Struct {
        final IValueProperty property;
        final IObservableValue value;

        public Struct(IValueProperty property, Object o) {
            this.property = property;
            this.value = property.observe(o);
        }
    }
}

