/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

public class CommandLineOptionModelProcessor {
    @Inject
    private IEclipseContext context;
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;

    public void process() {
        this.selectForcedPerspective();
    }

    private void selectForcedPerspective() {
        String forcedPerspectiveId = (String)this.context.get("forcedPerspetiveId");
        if (forcedPerspectiveId == null) {
            return;
        }
        List<MPerspectiveStack> perspStackList = this.modelService.findElements((MUIElement)this.application, null, MPerspectiveStack.class, null);
        if (perspStackList.isEmpty()) {
            return;
        }
        MPerspectiveStack perspStack = perspStackList.get(0);
        MPerspective selected = (MPerspective)perspStack.getSelectedElement();
        if (selected != null && selected.getElementId().equals(forcedPerspectiveId)) {
            return;
        }
        for (MPerspective persp : perspStack.getChildren()) {
            if (!persp.getElementId().equals(forcedPerspectiveId)) continue;
            perspStack.setSelectedElement((MUIElement)persp);
            return;
        }
    }
}

