/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.image;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.scene.image.Image;
import org.eclipse.fx.core.ThreadSynchronize;
import org.eclipse.fx.core.cache.Cache;
import org.eclipse.fx.ui.controls.image.MultiDimensionImage;
import org.eclipse.jdt.annotation.Nullable;

public class SingleMultiDimensionImage
implements MultiDimensionImage {
    private final ReadOnlyObjectWrapper<Image> img;
    private final ReadOnlyDoubleWrapper ratio;

    public SingleMultiDimensionImage(Image img) {
        this.img = new ReadOnlyObjectWrapper((Object)this, "image", (Object)img);
        this.ratio = new ReadOnlyDoubleWrapper((Object)this, "ratio", img.getWidth() / img.getHeight());
    }

    public <O> SingleMultiDimensionImage(ThreadSynchronize threadSynchronize, Image placeholder, O data, Function<O, Image> imageComputer, @Nullable Cache<O, Image> cache) {
        this.img = new ReadOnlyObjectWrapper((Object)this, "image", (Object)placeholder);
        this.ratio = new ReadOnlyDoubleWrapper((Object)this, "ratio", placeholder.getWidth() / placeholder.getHeight());
        CompletableFuture.supplyAsync(() -> {
            Object object2 = data;
            synchronized (object2) {
                Optional rv;
                if (cache != null && (rv = cache.get(data)).isPresent()) {
                    return (Image)rv.get();
                }
                Image image = (Image)imageComputer.apply(data);
                if (cache != null) {
                    cache.put(data, (Object)image);
                }
                return image;
            }
        }).thenAccept(threadSynchronize.wrap(this::imageComputed));
    }

    private void imageComputed(Image img) {
        this.img.set((Object)img);
        this.ratio.set(img.getWidth() / img.getHeight());
    }

    @Override
    public double getRatio() {
        return this.ratio.get();
    }

    @Override
    public ReadOnlyDoubleProperty ratioProperty() {
        return this.ratio.getReadOnlyProperty();
    }

    @Override
    public ReadOnlyObjectProperty<Image> imageProperty() {
        return this.img.getReadOnlyProperty();
    }

    @Override
    public void updateDimension(double w, double h) {
    }
}

