/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.shape.PathElement;
import javafx.scene.text.Text;
import javafx.stage.Window;
import org.eclipse.fx.core.SystemUtils;
import org.eclipse.fx.core.log.LoggerCreator;

public class JavaFXCompatUtil {
    public static List<Window> getAllWindows() {
        try {
            if (SystemUtils.getMajorFXVersion() > 8) {
                return (List)Window.class.getMethod("getWindows", new Class[0]).invoke(null, new Object[0]);
            }
            Iterator it = (Iterator)Window.class.getMethod("impl_getWindows", new Class[0]).invoke(null, new Object[0]);
            ArrayList<Window> rv = new ArrayList<Window>();
            while (it.hasNext()) {
                rv.add((Window)it.next());
            }
            return Collections.unmodifiableList(rv);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static int getCode(KeyCode keyCode) {
        if (SystemUtils.getMajorFXVersion() > 8) {
            try {
                return (Integer)KeyCode.class.getMethod("getCode", new Class[0]).invoke((Object)keyCode, new Object[0]);
            }
            catch (Throwable t) {
                LoggerCreator.createLogger(JavaFXCompatUtil.class).error("Unable to call KeyCode#getCode()", t);
                throw new RuntimeException(t);
            }
        }
        try {
            return (Integer)KeyCode.class.getMethod("impl_getCode", new Class[0]).invoke((Object)keyCode, new Object[0]);
        }
        catch (Throwable t) {
            LoggerCreator.createLogger(JavaFXCompatUtil.class).error("Unable to call KeyCode#impl_getCode()", t);
            throw new RuntimeException(t);
        }
    }

    public static String getChar(KeyCode keyCode) {
        if (SystemUtils.getMajorFXVersion() > 8) {
            try {
                return (String)KeyCode.class.getMethod("getChar", new Class[0]).invoke((Object)keyCode, new Object[0]);
            }
            catch (Throwable t) {
                LoggerCreator.createLogger(JavaFXCompatUtil.class).error("Unable to call KeyCode#getChar()", t);
                throw new RuntimeException(t);
            }
        }
        try {
            return (String)KeyCode.class.getMethod("impl_getChar", new Class[0]).invoke((Object)keyCode, new Object[0]);
        }
        catch (Throwable t) {
            LoggerCreator.createLogger(JavaFXCompatUtil.class).error("Unable to call KeyCode#impl_getChar()", t);
            throw new RuntimeException(t);
        }
    }

    public static void reapplyCSS(Node node) {
        if (SystemUtils.getMajorFXVersion() > 8) {
            try {
                Method m = Node.class.getDeclaredMethod("reapplyCSS", new Class[0]);
                m.setAccessible(true);
                m.invoke((Object)node, new Object[0]);
            }
            catch (Throwable t) {
                LoggerCreator.createLogger(JavaFXCompatUtil.class).error("Unable to call Node#reapplyCSS()", t);
                throw new RuntimeException(t);
            }
        }
        try {
            Method m = Node.class.getDeclaredMethod("impl_reapplyCSS", new Class[0]);
            m.invoke((Object)node, new Object[0]);
        }
        catch (Throwable t) {
            LoggerCreator.createLogger(JavaFXCompatUtil.class).error("Unable to call Node#impl_reapplyCSS()", t);
            throw new RuntimeException(t);
        }
    }

    public static void setCaretPosition(Text t, int value) {
        if (SystemUtils.getMajorFXVersion() > 8) {
            try {
                Method m = Text.class.getDeclaredMethod("setPosition", Integer.TYPE);
                m.invoke((Object)t, value);
            }
            catch (Throwable e) {
                LoggerCreator.createLogger(JavaFXCompatUtil.class).error("Unable to call Text#setPosition()", e);
                throw new RuntimeException(e);
            }
        }
        try {
            Method m = Text.class.getDeclaredMethod("setImpl_caretPosition", Integer.TYPE);
            m.invoke((Object)t, value);
        }
        catch (Throwable e) {
            LoggerCreator.createLogger(JavaFXCompatUtil.class).error("Unable to call Text#setImpl_caretPosition()", e);
            throw new RuntimeException(e);
        }
    }

    public static PathElement[] getCaretShape(Text t) {
        if (SystemUtils.getMajorFXVersion() > 8) {
            try {
                Method m = Text.class.getDeclaredMethod("getCaretShape", new Class[0]);
                return (PathElement[])m.invoke((Object)t, new Object[0]);
            }
            catch (Throwable e) {
                LoggerCreator.createLogger(JavaFXCompatUtil.class).error("Unable to call Text#getCaretShape()", e);
                throw new RuntimeException(e);
            }
        }
        try {
            Method m = Text.class.getDeclaredMethod("getImpl_caretShape", new Class[0]);
            return (PathElement[])m.invoke((Object)t, new Object[0]);
        }
        catch (Throwable e) {
            LoggerCreator.createLogger(JavaFXCompatUtil.class).error("Unable to call Text#getImpl_caretShape()", e);
            throw new RuntimeException(e);
        }
    }

    public static Integer getInsertionIndex(Text t, Point2D point) {
        Method m;
        Object hitInfo = null;
        if (SystemUtils.getMajorFXVersion() > 8) {
            try {
                m = Text.class.getDeclaredMethod("hitTest", Point2D.class);
                hitInfo = m.invoke((Object)t, point);
            }
            catch (Throwable e) {
                LoggerCreator.createLogger(JavaFXCompatUtil.class).error("Unable to call Text#impl_hitTestChar(Point2D)");
                throw new RuntimeException(e);
            }
        }
        try {
            m = Text.class.getDeclaredMethod("impl_hitTestChar", Point2D.class);
            hitInfo = m.invoke((Object)t, point);
        }
        catch (Throwable e) {
            LoggerCreator.createLogger(JavaFXCompatUtil.class).error("Unable to call Text#impl_hitTestChar(Point2D)");
            throw new RuntimeException(e);
        }
        if (hitInfo != null) {
            try {
                m = hitInfo.getClass().getMethod("getInsertionIndex", new Class[0]);
                return (Integer)m.invoke(hitInfo, new Object[0]);
            }
            catch (Throwable e) {
                LoggerCreator.createLogger(JavaFXCompatUtil.class).error("Unable to call HitInfo#getInsertionIndex()");
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static Integer insertationIndex(Text t, Point2D point) {
        block7: {
            if (SystemUtils.getMajorFXVersion() > 8) {
                try {
                    Method m = Text.class.getDeclaredMethod("hitTestChar", Point2D.class);
                    Object hitTest = m.invoke((Object)t, point);
                    if (hitTest != null) {
                        Method m2 = hitTest.getClass().getDeclaredMethod("getInsertionIndex", new Class[0]);
                        return (Integer)m2.invoke(hitTest, point);
                    }
                    break block7;
                }
                catch (Throwable e) {
                    LoggerCreator.createLogger(JavaFXCompatUtil.class).error("Unable to call Text#getImpl_caretShape()", e);
                    throw new RuntimeException(e);
                }
            }
            try {
                Method m = Text.class.getDeclaredMethod("impl_hitTestChar", Point2D.class);
                Object hitTest = m.invoke((Object)t, point);
                if (hitTest != null) {
                    Method m2 = hitTest.getClass().getDeclaredMethod("getInsertionIndex", new Class[0]);
                    return (Integer)m2.invoke(hitTest, point);
                }
            }
            catch (Throwable e) {
                LoggerCreator.createLogger(JavaFXCompatUtil.class).error("Unable to call Text#getImpl_caretShape()", e);
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

