/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.configuration.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.fx.code.editor.configuration.Check;
import org.eclipse.fx.code.editor.configuration.Condition;
import org.eclipse.fx.code.editor.configuration.EditorGModel;
import org.eclipse.fx.code.editor.configuration.TokenScanner;
import org.eclipse.fx.code.editor.configuration.TokenScanner_Keyword;
import org.eclipse.fx.code.editor.configuration.gson.GsonBase;
import org.eclipse.fx.code.editor.configuration.gson.GsonElementFactory;

public final class GsonTokenScanner_KeywordImpl
implements GsonBase,
TokenScanner_Keyword,
TokenScanner {
    private final Check check;
    private final Condition condition;
    private final List<String> keywordList;

    public GsonTokenScanner_KeywordImpl(JsonObject jsonObject) {
        this.check = jsonObject.has("check") ? GsonElementFactory.createCheck(jsonObject.getAsJsonObject("check")) : null;
        this.condition = jsonObject.has("condition") ? GsonElementFactory.createCondition(jsonObject.getAsJsonObject("condition")) : null;
        this.keywordList = jsonObject.has("keywordList") ? Collections.unmodifiableList(StreamSupport.stream(jsonObject.getAsJsonArray("keywordList").spliterator(), false).map(e -> e.getAsString()).collect(Collectors.toList())) : Collections.emptyList();
    }

    public GsonTokenScanner_KeywordImpl(Check check, Condition condition, List<String> keywordList) {
        this.check = check;
        this.condition = condition;
        this.keywordList = keywordList;
    }

    @Override
    public JsonObject toJSONObject() {
        JsonObject o = new JsonObject();
        o.addProperty("$gtype", "TokenScanner_Keyword");
        o.add("check", this.getCheck() == null ? null : ((GsonBase)((Object)this.getCheck())).toJSONObject());
        o.add("condition", this.getCondition() == null ? null : ((GsonBase)((Object)this.getCondition())).toJSONObject());
        o.add("keywordList", (JsonElement)GsonBase.toJsonArray(this.getKeywordList().stream().map(JsonPrimitive::new).collect(Collectors.toList())));
        return o;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "@" + Integer.toHexString(this.hashCode()) + " { " + "check : " + (this.check == null ? null : String.valueOf(this.check.getClass().getSimpleName()) + "@" + Integer.toHexString(this.check.hashCode())) + ", " + "condition : " + (this.condition == null ? null : String.valueOf(this.condition.getClass().getSimpleName()) + "@" + Integer.toHexString(this.condition.hashCode())) + ", " + "keywordList : " + this.keywordList + " }";
    }

    @Override
    public Check getCheck() {
        return this.check;
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }

    @Override
    public List<String> getKeywordList() {
        return this.keywordList;
    }

    public static class Builder
    implements TokenScanner_Keyword.Builder {
        private final EditorGModel instance;
        private Check check;
        private Condition condition;
        private final List<String> keywordList = new ArrayList<String>();

        public Builder(EditorGModel instance) {
            this.instance = instance;
        }

        @Override
        public Builder check(Check check) {
            this.check = check;
            return this;
        }

        @Override
        public Builder condition(Condition condition) {
            this.condition = condition;
            return this;
        }

        @Override
        public Builder keywordList(List<String> keywordList) {
            this.keywordList.addAll(keywordList);
            return this;
        }

        @Override
        public Builder appendKeywordList(String keywordList) {
            this.keywordList.add(keywordList);
            return this;
        }

        @Override
        public TokenScanner_Keyword build() {
            return new GsonTokenScanner_KeywordImpl(this.check, this.condition, this.keywordList);
        }
    }
}

