/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.keybindings.e4.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.fx.ui.keybindings.Binding;
import org.eclipse.fx.ui.keybindings.TriggerSequence;
import org.eclipse.fx.ui.keybindings.e4.internal.BindingTable;
import org.eclipse.fx.ui.keybindings.e4.internal.ContextSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BindingTableManager {
    private static final String BINDING_TABLE_PREFIX = "bindingTable:";
    @Inject
    private IEclipseContext eclipseContext;
    private ContextSet definedTables = ContextSet.EMPTY;
    private String[] activeSchemeIds;

    public void addTable(@NonNull BindingTable table) {
        String contextId = BindingTableManager.getTableId(table.getId());
        if (this.eclipseContext.containsKey(contextId)) {
            return;
        }
        this.eclipseContext.set(contextId, (Object)table);
        List<@NonNull Context> contexts = this.definedTables.getContexts();
        if (!contexts.contains(table.getTableId())) {
            contexts.add(table.getTableId());
            this.definedTables = BindingTableManager.createContextSet(contexts);
        }
    }

    private static String getTableId(String id) {
        return BINDING_TABLE_PREFIX + id;
    }

    public void removeTable(@NonNull BindingTable table) {
        String contextId = BindingTableManager.getTableId(table.getId());
        if (!this.eclipseContext.containsKey(contextId)) {
            throw new IllegalArgumentException("Does not contains table " + contextId);
        }
        this.eclipseContext.remove(contextId);
        List<@NonNull Context> contexts = this.definedTables.getContexts();
        if (contexts.contains(table.getTableId())) {
            contexts.remove(table.getTableId());
            this.definedTables = BindingTableManager.createContextSet(contexts);
        }
    }

    public @Nullable BindingTable getTable(String id) {
        return (BindingTable)this.eclipseContext.get(BindingTableManager.getTableId(id));
    }

    public @NonNull Collection<@NonNull Binding> getActiveBindings() {
        ArrayList<@NonNull Binding> bindings = new ArrayList<Binding>();
        for (Context ctx : this.definedTables.getContexts()) {
            BindingTable table = this.getTable(ctx.getId());
            if (table == null) continue;
            bindings.addAll(table.getBindings());
        }
        return bindings;
    }

    static @NonNull ContextSet createContextSet(@NonNull Collection<@NonNull Context> contexts) {
        return new ContextSet(contexts);
    }

    @Nullable Collection<@NonNull Binding> getConflictsFor(@NonNull ContextSet contextSet, @NonNull TriggerSequence triggerSequence) {
        ArrayList<@NonNull Binding> matches = new ArrayList<Binding>();
        for (Context ctx : contextSet.getContexts()) {
            Collection<Binding> matchesFor;
            BindingTable table = this.getTable(ctx.getId());
            if (table == null || (matchesFor = table.getConflictsFor(triggerSequence)) == null) continue;
            matches.addAll(matchesFor);
        }
        return matches.size() == 0 ? null : matches;
    }

    @NonNull Collection<@NonNull Binding> getAllConflicts() {
        ArrayList<@NonNull Binding> conflictsList = new ArrayList<Binding>();
        for (Context ctx : this.definedTables.getContexts()) {
            BindingTable table = this.getTable(ctx.getId());
            if (table == null) continue;
            Collection<@NonNull Binding> conflictsInTable = table.getConflicts();
            conflictsList.addAll(conflictsInTable);
        }
        return conflictsList;
    }

    @Nullable Binding getPerfectMatch(@NonNull ContextSet contextSet, @NonNull TriggerSequence triggerSequence) {
        Binding result = null;
        Binding currentResult = null;
        List<Context> contexts = contextSet.getContexts();
        ListIterator<Context> it = contexts.listIterator(contexts.size());
        while (it.hasPrevious()) {
            Context c = it.previous();
            BindingTable table = this.getTable(c.getId());
            if (table != null) {
                currentResult = table.getPerfectMatch(triggerSequence);
            }
            if (currentResult == null) continue;
            if (this.isMostActiveScheme(currentResult)) {
                return currentResult;
            }
            if (result == null) {
                result = currentResult;
                continue;
            }
            int rc = this.compareSchemes(result.getSchemeId(), currentResult.getSchemeId());
            if (rc >= 0) continue;
            result = currentResult;
        }
        return result;
    }

    private boolean isMostActiveScheme(Binding currentResult) {
        if (this.activeSchemeIds == null || this.activeSchemeIds.length < 2) {
            return true;
        }
        String mostActive = this.activeSchemeIds[0];
        return mostActive == null ? false : mostActive.equals(currentResult.getSchemeId());
    }

    @Nullable Binding getBestSequenceFor(@NonNull ContextSet contextSet, @NonNull ParameterizedCommand parameterizedCommand) {
        List<@NonNull Binding> bindings = this.getSequencesFor(contextSet, parameterizedCommand);
        if (bindings.size() == 0) {
            return null;
        }
        return bindings.get(0);
    }

    @NonNull List<@NonNull Binding> getSequencesFor(@NonNull ContextSet contextSet, @NonNull ParameterizedCommand parameterizedCommand) {
        ArrayList<@NonNull Binding> bindings = new ArrayList<Binding>();
        List<Context> contexts = contextSet.getContexts();
        ListIterator<Context> it = contexts.listIterator(contexts.size());
        while (it.hasPrevious()) {
            Context c = it.previous();
            BindingTable table = this.getTable(c.getId());
            if (table == null) continue;
            Collection<@NonNull Binding> sequences = table.getSequencesFor(parameterizedCommand);
            bindings.addAll(sequences);
        }
        Collections.sort(bindings, BindingTable.BEST_SEQUENCE);
        return bindings;
    }

    @NonNull Collection<@NonNull Binding> getBindingsFor(@NonNull ContextSet contextSet, @NonNull ParameterizedCommand cmd) {
        ArrayList<@NonNull Binding> bindings = new ArrayList<Binding>();
        for (Context ctx : contextSet.getContexts()) {
            BindingTable table = this.getTable(ctx.getId());
            if (table == null) continue;
            Collection<@NonNull Binding> matches = table.getSequencesFor(cmd);
            bindings.addAll(matches);
        }
        return bindings;
    }

    boolean isPartialMatch(@NonNull ContextSet contextSet, @NonNull TriggerSequence sequence) {
        List<Context> contexts = contextSet.getContexts();
        ListIterator<Context> it = contexts.listIterator(contexts.size());
        while (it.hasPrevious()) {
            Context c = it.previous();
            BindingTable table = this.getTable(c.getId());
            if (table == null || !table.isPartialMatch(sequence)) continue;
            return true;
        }
        return false;
    }

    @NonNull Collection<@NonNull Binding> getPartialMatches(@NonNull ContextSet contextSet, @NonNull TriggerSequence sequence) {
        ArrayList<@NonNull Binding> bindings = new ArrayList<Binding>();
        List<Context> contexts = contextSet.getContexts();
        ListIterator<Context> it = contexts.listIterator(contexts.size());
        while (it.hasPrevious()) {
            Collection<Binding> partialMatches;
            Context c = it.previous();
            BindingTable table = this.getTable(c.getId());
            if (table == null || (partialMatches = table.getPartialMatches(sequence)) == null) continue;
            bindings.addAll(partialMatches);
        }
        return bindings;
    }

    public void setActiveSchemes(String[] activeSchemeIds) {
        this.activeSchemeIds = activeSchemeIds;
        BindingTable.BEST_SEQUENCE.setActiveSchemes(activeSchemeIds);
    }

    private final int compareSchemes(String schemeId1, String schemeId2) {
        if (this.activeSchemeIds == null) {
            return 0;
        }
        if (!schemeId2.equals(schemeId1)) {
            int i = 0;
            while (i < this.activeSchemeIds.length) {
                String schemePointer = this.activeSchemeIds[i];
                if (schemeId2.equals(schemePointer)) {
                    return 1;
                }
                if (schemeId1.equals(schemePointer)) {
                    return -1;
                }
                ++i;
            }
        }
        return 0;
    }
}

