/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.tabpane.skin;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import org.eclipse.fx.core.log.LoggerCreator;
import org.eclipse.fx.ui.controls.tabpane.DndTabPaneFactory;
import org.eclipse.fx.ui.controls.tabpane.GenericTab;
import org.eclipse.fx.ui.controls.tabpane.skin.FXTabWrapper;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DndTabPaneSkinHooker
implements DndTabPaneFactory.DragSetup {
    private static Tab DRAGGED_TAB;
    public static final DataFormat TAB_MOVE;
    private @Nullable Function<@NonNull GenericTab, @NonNull Boolean> startFunction;
    private @Nullable Function<@NonNull GenericTab, @NonNull String> clipboardDataFunction;
    private @Nullable Consumer<@NonNull GenericTab> dragFinishedConsumer;
    private @Nullable Consumer< @NonNull DndTabPaneFactory.FeedbackData> feedbackConsumer;
    private @Nullable Consumer< @NonNull DndTabPaneFactory.DroppedData> dropConsumer;
    private final TabPane pane;

    static {
        TAB_MOVE = new DataFormat(new String[]{"DnDTabPane:tabMove"});
    }

    public DndTabPaneSkinHooker(Skin<TabPane> skin) {
        this.pane = (TabPane)skin.getSkinnable();
        Optional<Node> o_TabHeaderArea = ((SkinBase)skin).getChildren().stream().filter(e -> e.getClass().getSimpleName().equals("TabHeaderArea")).findFirst();
        if (!o_TabHeaderArea.isPresent() || !(o_TabHeaderArea.get() instanceof Pane)) {
            LoggerCreator.createLogger(DndTabPaneSkinHooker.class).warning("Could not find a supported TabHeaderArea pane. DnD is disabled.");
            return;
        }
        Pane tabHeaderArea = (Pane)o_TabHeaderArea.get();
        Optional<Node> o_HeadersRegion = tabHeaderArea.getChildren().stream().filter(e -> e.getStyleClass().contains((Object)"headers-region")).findFirst();
        if (!o_HeadersRegion.isPresent() || !(o_HeadersRegion.get() instanceof Pane)) {
            LoggerCreator.createLogger(DndTabPaneSkinHooker.class).warning("Could not find a supported HeadersRegion pane. DnD is disabled.");
            return;
        }
        Pane headersRegion = (Pane)o_HeadersRegion.get();
        tabHeaderArea.setOnDragOver(e -> e.consume());
        EventHandler handler = this::tabPane_handleDragStart;
        EventHandler handlerFinished = this::tabPane_handleDragDone;
        for (Node tabHeaderSkin : headersRegion.getChildren()) {
            tabHeaderSkin.addEventHandler(MouseEvent.DRAG_DETECTED, handler);
            tabHeaderSkin.addEventHandler(DragEvent.DRAG_DONE, handlerFinished);
        }
        headersRegion.getChildren().addListener(change -> {
            while (change.next()) {
                if (change.wasRemoved()) {
                    change.getRemoved().forEach(e -> e.removeEventHandler(MouseEvent.DRAG_DETECTED, handler));
                    change.getRemoved().forEach(e -> e.removeEventHandler(DragEvent.DRAG_DONE, handlerFinished));
                }
                if (!change.wasAdded()) continue;
                change.getAddedSubList().forEach(e -> e.addEventHandler(MouseEvent.DRAG_DETECTED, handler));
                change.getAddedSubList().forEach(e -> e.addEventHandler(DragEvent.DRAG_DONE, handlerFinished));
            }
        });
        tabHeaderArea.addEventHandler(DragEvent.DRAG_OVER, e -> this.tabPane_handleDragOver(tabHeaderArea, headersRegion, (DragEvent)e));
        tabHeaderArea.addEventHandler(DragEvent.DRAG_DROPPED, e -> this.tabPane_handleDragDropped(tabHeaderArea, headersRegion, (DragEvent)e));
        tabHeaderArea.addEventHandler(DragEvent.DRAG_EXITED, this::tabPane_handleDragDone);
    }

    @Override
    public void setClipboardDataFunction(@Nullable Function<@NonNull GenericTab, @NonNull String> clipboardDataFunction) {
        this.clipboardDataFunction = clipboardDataFunction;
    }

    @Override
    public void setDragFinishedConsumer(Consumer<@NonNull GenericTab> dragFinishedConsumer) {
        this.dragFinishedConsumer = dragFinishedConsumer;
    }

    @Override
    public void setDropConsumer(Consumer< @NonNull DndTabPaneFactory.DroppedData> dropConsumer) {
        this.dropConsumer = dropConsumer;
    }

    @Override
    public void setFeedbackConsumer(Consumer< @NonNull DndTabPaneFactory.FeedbackData> feedbackConsumer) {
        this.feedbackConsumer = feedbackConsumer;
    }

    @Override
    public void setStartFunction(@Nullable Function<@NonNull GenericTab, @NonNull Boolean> startFunction) {
        this.startFunction = startFunction;
    }

    private Tab getTab(Node n) {
        int tabIdx = n.getParent().getChildrenUnmodifiable().indexOf((Object)n);
        return (Tab)this.pane.getTabs().get(tabIdx);
    }

    void tabPane_handleDragDropped(Pane tabHeaderArea, Pane headersRegion, DragEvent event) {
        Tab draggedTab = DRAGGED_TAB;
        if (draggedTab == null) {
            return;
        }
        double x = event.getX() - headersRegion.getBoundsInParent().getMinX();
        Node referenceNode = null;
        DndTabPaneFactory.DropType type = DndTabPaneFactory.DropType.AFTER;
        for (Node n : headersRegion.getChildren()) {
            Bounds b = n.getBoundsInParent();
            if (!(b.getMaxX() > x)) continue;
            if (b.getMinX() + b.getWidth() / 2.0 > x) {
                referenceNode = n;
                type = DndTabPaneFactory.DropType.BEFORE;
                break;
            }
            referenceNode = n;
            type = DndTabPaneFactory.DropType.AFTER;
            break;
        }
        if (referenceNode == null && headersRegion.getChildren().size() > 0) {
            referenceNode = (Node)headersRegion.getChildren().get(headersRegion.getChildren().size() - 1);
            type = DndTabPaneFactory.DropType.AFTER;
        }
        if (referenceNode != null) {
            try {
                Tab tab = this.getTab(referenceNode);
                boolean noMove = false;
                if (tab == null) {
                    event.setDropCompleted(false);
                    return;
                }
                if (tab == draggedTab) {
                    noMove = true;
                } else if (type == DndTabPaneFactory.DropType.BEFORE) {
                    int idx = this.pane.getTabs().indexOf((Object)tab);
                    if (idx > 0 && this.pane.getTabs().get(idx - 1) == draggedTab) {
                        noMove = true;
                    }
                } else {
                    int idx = this.pane.getTabs().indexOf((Object)tab);
                    if (idx + 1 < this.pane.getTabs().size() && this.pane.getTabs().get(idx + 1) == draggedTab) {
                        noMove = true;
                    }
                }
                if (!noMove) {
                    this.efx_dropped(event.getScreenX(), event.getScreenY(), FXTabWrapper.wrap(draggedTab), FXTabWrapper.wrap(tab), type);
                    event.setDropCompleted(true);
                } else {
                    event.setDropCompleted(false);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            event.consume();
        }
    }

    void tabPane_handleDragStart(MouseEvent event) {
        try {
            Tab t = this.getTab((Node)event.getSource());
            if (t != null && this.efx_canStartDrag(FXTabWrapper.wrap(t))) {
                DRAGGED_TAB = t;
                Node node = (Node)event.getSource();
                Dragboard db = node.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                WritableImage snapShot = node.snapshot(new SnapshotParameters(), null);
                PixelReader reader = snapShot.getPixelReader();
                int padX = 10;
                int padY = 10;
                int width = (int)snapShot.getWidth();
                int height = (int)snapShot.getHeight();
                WritableImage image = new WritableImage(width + padX, height + padY);
                PixelWriter writer = image.getPixelWriter();
                int h = 0;
                int v = 0;
                while (h < width + padX) {
                    v = 0;
                    while (v < height + padY) {
                        if (h >= padX && h <= width + padX && v >= padY && v <= height + padY) {
                            writer.setColor(h, v, reader.getColor(h - padX, v - padY));
                        } else {
                            writer.setColor(h, v, Color.TRANSPARENT);
                        }
                        ++v;
                    }
                    ++h;
                }
                db.setDragView((Image)image, image.getWidth(), image.getHeight() * -1.0);
                ClipboardContent content = new ClipboardContent();
                String data = this.efx_getClipboardContent(FXTabWrapper.wrap(t));
                if (data != null) {
                    content.put((Object)TAB_MOVE, (Object)data);
                }
                db.setContent((Map)content);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    void tabPane_handleDragOver(Pane tabHeaderArea, Pane headersRegion, DragEvent event) {
        Tab draggedTab = DRAGGED_TAB;
        if (draggedTab == null) {
            return;
        }
        event.consume();
        double x = event.getX() - headersRegion.getBoundsInParent().getMinX();
        Node referenceNode = null;
        DndTabPaneFactory.DropType type = DndTabPaneFactory.DropType.AFTER;
        for (Node n : headersRegion.getChildren()) {
            Bounds b = n.getBoundsInParent();
            if (!(b.getMaxX() > x)) continue;
            if (b.getMinX() + b.getWidth() / 2.0 > x) {
                referenceNode = n;
                type = DndTabPaneFactory.DropType.BEFORE;
                break;
            }
            referenceNode = n;
            type = DndTabPaneFactory.DropType.AFTER;
            break;
        }
        if (referenceNode == null && headersRegion.getChildren().size() > 0) {
            referenceNode = (Node)headersRegion.getChildren().get(headersRegion.getChildren().size() - 1);
            type = DndTabPaneFactory.DropType.AFTER;
        }
        if (referenceNode != null) {
            try {
                Tab tab = this.getTab(referenceNode);
                boolean noMove = false;
                if (tab == draggedTab) {
                    noMove = true;
                } else if (type == DndTabPaneFactory.DropType.BEFORE) {
                    int idx = this.pane.getTabs().indexOf((Object)tab);
                    if (idx > 0 && this.pane.getTabs().get(idx - 1) == draggedTab) {
                        noMove = true;
                    }
                } else {
                    int idx = this.pane.getTabs().indexOf((Object)tab);
                    if (idx + 1 < this.pane.getTabs().size() && this.pane.getTabs().get(idx + 1) == draggedTab) {
                        noMove = true;
                    }
                }
                if (noMove) {
                    this.efx_dragFeedback(FXTabWrapper.wrap(draggedTab), null, null, DndTabPaneFactory.DropType.NONE);
                    return;
                }
                Bounds b = referenceNode.getBoundsInLocal();
                b = referenceNode.localToScene(b);
                b = this.pane.sceneToLocal(b);
                this.efx_dragFeedback(FXTabWrapper.wrap(draggedTab), FXTabWrapper.wrap(tab), b, type);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
        } else {
            this.efx_dragFeedback(FXTabWrapper.wrap(draggedTab), null, null, DndTabPaneFactory.DropType.NONE);
        }
    }

    void tabPane_handleDragDone(DragEvent event) {
        Tab tab = DRAGGED_TAB;
        if (tab == null) {
            return;
        }
        this.efx_dragFinished(FXTabWrapper.wrap(tab));
    }

    private boolean efx_canStartDrag(@NonNull GenericTab tab) {
        if (this.startFunction != null) {
            return this.startFunction.apply(tab);
        }
        return true;
    }

    private void efx_dragFinished(@NonNull GenericTab tab) {
        if (this.dragFinishedConsumer != null) {
            this.dragFinishedConsumer.accept(tab);
        }
    }

    private String efx_getClipboardContent(@NonNull GenericTab t) {
        if (this.clipboardDataFunction != null) {
            return this.clipboardDataFunction.apply(t);
        }
        return String.valueOf(System.identityHashCode(t));
    }

    private void efx_dragFeedback(@NonNull GenericTab draggedTab, GenericTab targetTab, Bounds bounds,  @NonNull DndTabPaneFactory.DropType dropType) {
        if (this.feedbackConsumer != null) {
            this.feedbackConsumer.accept(new DndTabPaneFactory.FeedbackData(draggedTab, targetTab, bounds, dropType));
        }
    }

    private void efx_dropped(double x, double y, @NonNull GenericTab draggedTab, @NonNull GenericTab targetTab,  @NonNull DndTabPaneFactory.DropType dropType) {
        if (this.dropConsumer != null) {
            this.dropConsumer.accept(new DndTabPaneFactory.DroppedData(x, y, draggedTab, targetTab, dropType));
        }
    }
}

