/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Locale;
import org.sat4j.reader.AAGReader;
import org.sat4j.reader.AIGReader;
import org.sat4j.reader.DimacsReader;
import org.sat4j.reader.LecteurDimacs;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;

public class InstanceReader
extends Reader {
    private AAGReader aag;
    private AIGReader aig;
    private DimacsReader ezdimacs;
    private LecteurDimacs dimacs;
    private Reader reader = null;
    private final ISolver solver;

    public InstanceReader(ISolver solver) {
        this.solver = solver;
    }

    private Reader getDefaultSATReader() {
        if (this.dimacs == null) {
            this.dimacs = new LecteurDimacs(this.solver);
        }
        return this.dimacs;
    }

    private Reader getEZSATReader() {
        if (this.ezdimacs == null) {
            this.ezdimacs = new DimacsReader(this.solver);
        }
        return this.ezdimacs;
    }

    private Reader getAIGReader() {
        if (this.aig == null) {
            this.aig = new AIGReader(this.solver);
        }
        return this.aig;
    }

    private Reader getAAGReader() {
        if (this.aag == null) {
            this.aag = new AAGReader(this.solver);
        }
        return this.aag;
    }

    public IProblem parseInstance(String filename) throws ParseFormatException, IOException, ContradictionException {
        String prefix = "";
        if (filename.startsWith("http://")) {
            filename = filename.substring(filename.lastIndexOf(47), filename.length() - 1);
        }
        if (filename.indexOf(58) != -1) {
            String[] parts = filename.split(":");
            filename = parts[1];
            prefix = parts[0].toUpperCase(Locale.getDefault());
        }
        String fname = filename.endsWith(".gz") || filename.endsWith(".bz2") ? filename.substring(0, filename.lastIndexOf(46)) : filename;
        this.reader = this.handleFileName(fname, prefix);
        return this.reader.parseInstance(filename);
    }

    protected Reader handleFileName(String fname, String prefix) {
        if ("EZCNF".equals(prefix)) {
            return this.getEZSATReader();
        }
        if (fname.endsWith(".aag")) {
            return this.getAAGReader();
        }
        if (fname.endsWith(".aig")) {
            return this.getAIGReader();
        }
        return this.getDefaultSATReader();
    }

    @Deprecated
    public String decode(int[] model) {
        return this.reader.decode(model);
    }

    public void decode(int[] model, PrintWriter out) {
        this.reader.decode(model, out);
    }

    public IProblem parseInstance(InputStream in) throws ParseFormatException, ContradictionException, IOException {
        throw new UnsupportedOperationException("Use a domain specific Reader (LecteurDimacs, AIGReader, etc.) for stream input ");
    }
}

