/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.util;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.ui.util.PluginContainmentAdapter;
import org.eclipse.ui.IContainmentAdapter;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class PersistablePluginObject
extends PlatformObject
implements IPersistableElement,
IElementFactory {
    public static final String FACTORY_ID = "org.eclipse.pde.ui.elementFactory";
    public static final String KEY = "org.eclipse.pde.workingSetKey";
    private static PluginContainmentAdapter fgContainmentAdapter;
    private String fPluginID;

    public PersistablePluginObject() {
    }

    public PersistablePluginObject(String pluginID) {
        this.fPluginID = pluginID;
    }

    public String getFactoryId() {
        return FACTORY_ID;
    }

    public void saveState(IMemento memento) {
        memento.putString(KEY, this.fPluginID);
    }

    public IAdaptable createElement(IMemento memento) {
        return new PersistablePluginObject(memento.getString(KEY));
    }

    /*
     * WARNING - void declaration
     */
    public <T> T getAdapter(Class<T> adapter) {
        IResource res;
        IResource iResource;
        if (adapter.equals(IPersistableElement.class)) {
            return (T)((Object)this);
        }
        if (adapter.equals(IResource.class)) {
            return (T)this.getResource();
        }
        if (adapter.equals(IContainmentAdapter.class)) {
            return (T)PersistablePluginObject.getPluginContainmentAdapter();
        }
        if (adapter.equals(IJavaElement.class) && (iResource = (res = this.getResource())) instanceof IProject) {
            IProject iProject = (IProject)iResource;
            IProject cfr_ignored_0 = (IProject)iResource;
            try {
                void project;
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    return (T)JavaCore.create((IProject)project);
                }
            }
            catch (CoreException coreException) {}
        }
        return (T)super.getAdapter(adapter);
    }

    public IResource getResource() {
        IPluginModelBase model = PluginRegistry.findModel((String)this.fPluginID);
        IResource resource = model != null ? model.getUnderlyingResource() : null;
        return resource == null ? null : resource.getProject();
    }

    public String getPluginID() {
        return this.fPluginID;
    }

    private static IContainmentAdapter getPluginContainmentAdapter() {
        if (fgContainmentAdapter == null) {
            fgContainmentAdapter = new PluginContainmentAdapter();
        }
        return fgContainmentAdapter;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof PersistablePluginObject) {
            String id = ((PersistablePluginObject)((Object)arg0)).fPluginID;
            return this.fPluginID != null ? this.fPluginID.equals(id) : id == null;
        }
        return false;
    }

    public int hashCode() {
        return this.fPluginID.hashCode();
    }
}

