/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.Messages;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jdt.internal.ui.util.ASTHelper;

public class SealedClassFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public SealedClassFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation operation) {
        super(name, compilationUnit, operation);
    }

    /*
     * Unable to fully structure code
     */
    public static SealedClassFixCore addTypeAsPermittedSubTypeProposal(CompilationUnit cu, IProblemLocationCore problem) {
        selectedNode = problem.getCoveringNode(cu);
        sealedType = SealedClassFixCore.getSealedType(selectedNode);
        if (sealedType != null) ** GOTO lbl6
        return null;
lbl-1000:
        // 1 sources

        {
            selectedNode = selectedNode.getParent();
lbl6:
            // 2 sources

            ** while (selectedNode.getParent() instanceof Type)
        }
lbl7:
        // 1 sources

        subType = SealedClassFixCore.getDeclaringType(selectedNode);
        if (subType == null) {
            return null;
        }
        subTypeBinding = subType.resolveBinding();
        compilationUnit = SealedClassFixCore.getCompilationUnitForSealedType(sealedType);
        if (compilationUnit == null) {
            return null;
        }
        cuRewrite = new CompilationUnitRewrite(compilationUnit);
        try {
            declaration = ASTNodeSearchUtil.getTypeDeclarationNode(sealedType, cuRewrite.getRoot());
        }
        catch (JavaModelException v0) {
            return null;
        }
        if (declaration == null) {
            return null;
        }
        op = new AddTypeAsPermittedSubTypeProposalOperation(declaration, subType, subTypeBinding);
        subTypeName = subType.getName().getIdentifier();
        sealedTypeName = sealedType.getElementName();
        label = Messages.format(CorrectionMessages.LocalCorrectionsSubProcessor_declareSubClassAsPermitsSealedClass_description, new String[]{subTypeName, sealedTypeName});
        return new SealedClassFixCore(label, cuRewrite.getRoot(), op);
    }

    public static SealedClassFixCore addSealedAsDirectSuperTypeProposal(CompilationUnit cu, IProblemLocationCore problem) {
        TypeDeclaration permittedTypeDeclaration;
        ASTNode selectedNode = problem.getCoveringNode(cu);
        TypeDeclaration sealedType = SealedClassFixCore.getSealedTypeNodeFromPermitsNode(selectedNode);
        if (sealedType == null) {
            return null;
        }
        IType permittedTypeElement = SealedClassFixCore.getPermittedType(selectedNode);
        if (permittedTypeElement == null) {
            return null;
        }
        ICompilationUnit compilationUnit = permittedTypeElement.getCompilationUnit();
        if (compilationUnit == null) {
            return null;
        }
        CompilationUnitRewrite cuRewrite = new CompilationUnitRewrite(compilationUnit);
        try {
            permittedTypeDeclaration = ASTNodeSearchUtil.getTypeDeclarationNode(permittedTypeElement, cuRewrite.getRoot());
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        if (permittedTypeDeclaration == null) {
            return null;
        }
        boolean isSealedInterface = sealedType.isInterface();
        String permittedTypeName = permittedTypeDeclaration.getName().getIdentifier();
        String sealedTypeName = sealedType.getName().getIdentifier();
        String label = isSealedInterface ? Messages.format(CorrectionMessages.LocalCorrectionsSubProcessor_declareSealedAsDirectSuperInterface_description, new String[]{sealedTypeName, permittedTypeName}) : Messages.format(CorrectionMessages.LocalCorrectionsSubProcessor_declareSealedAsDirectSuperClass_description, new String[]{sealedTypeName, permittedTypeName});
        AddSealedAsDirectSuperTypeProposalOperation op = new AddSealedAsDirectSuperTypeProposalOperation(permittedTypeDeclaration, sealedType);
        return new SealedClassFixCore(label, cuRewrite.getRoot(), op);
    }

    private static TypeDeclaration getDeclaringType(ASTNode selectedNode) {
        if (selectedNode.getLocationInParent() != TypeDeclaration.SUPERCLASS_TYPE_PROPERTY && selectedNode.getLocationInParent() != TypeDeclaration.SUPER_INTERFACE_TYPES_PROPERTY) {
            return null;
        }
        return (TypeDeclaration)selectedNode.getParent();
    }

    /*
     * Unable to fully structure code
     */
    public static IType getSealedType(ASTNode selectedNode) {
        if (selectedNode == null) {
            return null;
        }
        if (ASTHelper.isSealedTypeSupportedInAST(selectedNode.getAST())) ** GOTO lbl6
        return null;
lbl-1000:
        // 1 sources

        {
            selectedNode = selectedNode.getParent();
lbl6:
            // 2 sources

            ** while (selectedNode.getParent() instanceof Type)
        }
lbl7:
        // 1 sources

        if (selectedNode.getLocationInParent() != TypeDeclaration.SUPERCLASS_TYPE_PROPERTY && selectedNode.getLocationInParent() != TypeDeclaration.SUPER_INTERFACE_TYPES_PROPERTY) {
            return null;
        }
        sealedTypeElement = null;
        if (selectedNode instanceof SimpleType && (typeBinding = ((SimpleType)selectedNode).resolveBinding()) != null) {
            sealedTypeElement = typeBinding.getJavaElement();
        }
        if (!(sealedTypeElement instanceof IType)) {
            return null;
        }
        return (IType)sealedTypeElement;
    }

    /*
     * Unable to fully structure code
     */
    private static TypeDeclaration getSealedTypeNodeFromPermitsNode(ASTNode selectedNode) {
        if (selectedNode == null) {
            return null;
        }
        if (ASTHelper.isSealedTypeSupportedInAST(selectedNode.getAST())) ** GOTO lbl6
        return null;
lbl-1000:
        // 1 sources

        {
            selectedNode = selectedNode.getParent();
lbl6:
            // 2 sources

            ** while (selectedNode.getParent() instanceof Type)
        }
lbl7:
        // 1 sources

        if (selectedNode.getLocationInParent() != TypeDeclaration.PERMITS_TYPES_PROPERTY) {
            return null;
        }
        sealedType = (TypeDeclaration)selectedNode.getParent();
        return sealedType;
    }

    public static ICompilationUnit getCompilationUnitForSealedType(IType sealedType) {
        try {
            if (sealedType.isBinary() || !sealedType.isSealed()) {
                return null;
            }
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        return sealedType.getCompilationUnit();
    }

    /*
     * Unable to fully structure code
     */
    public static IType getPermittedType(ASTNode selectedNode) {
        if (selectedNode == null) {
            return null;
        }
        if (ASTHelper.isSealedTypeSupportedInAST(selectedNode.getAST())) ** GOTO lbl6
        return null;
lbl-1000:
        // 1 sources

        {
            selectedNode = selectedNode.getParent();
lbl6:
            // 2 sources

            ** while (selectedNode.getParent() instanceof Type)
        }
lbl7:
        // 1 sources

        if (selectedNode.getLocationInParent() != TypeDeclaration.PERMITS_TYPES_PROPERTY) {
            return null;
        }
        permittedTypeElement = null;
        if (selectedNode instanceof SimpleType && (typeBinding = ((SimpleType)selectedNode).resolveBinding()) != null) {
            permittedTypeElement = typeBinding.getJavaElement();
        }
        if (!(permittedTypeElement instanceof IType)) {
            return null;
        }
        return (IType)permittedTypeElement;
    }

    public static class AddSealedAsDirectSuperTypeProposalOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private TypeDeclaration fPermittedTypeDeclaration;
        private TypeDeclaration fSealedType;

        public AddSealedAsDirectSuperTypeProposalOperation(TypeDeclaration permittedTypeDeclaration, TypeDeclaration sealedType) {
            this.fPermittedTypeDeclaration = permittedTypeDeclaration;
            this.fSealedType = sealedType;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            AST ast = this.fPermittedTypeDeclaration.getAST();
            String sealedTypeName = this.fSealedType.getName().getIdentifier();
            SimpleType type = ast.newSimpleType((Name)ast.newSimpleName(sealedTypeName));
            boolean isSealedInterface = this.fSealedType.isInterface();
            ASTRewrite astRewrite = cuRewrite.getASTRewrite();
            if (isSealedInterface) {
                astRewrite.getListRewrite((ASTNode)this.fPermittedTypeDeclaration, TypeDeclaration.SUPER_INTERFACE_TYPES_PROPERTY).insertLast((ASTNode)type, null);
            } else {
                astRewrite.set((ASTNode)this.fPermittedTypeDeclaration, (StructuralPropertyDescriptor)TypeDeclaration.SUPERCLASS_TYPE_PROPERTY, (Object)type, null);
            }
            ImportRewrite importRewrite = cuRewrite.getImportRewrite();
            ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext(this.fPermittedTypeDeclaration.getRoot(), importRewrite);
            importRewrite.addImport(this.fSealedType.resolveBinding(), astRewrite.getAST(), (ImportRewrite.ImportRewriteContext)importRewriteContext);
        }
    }

    public static class AddTypeAsPermittedSubTypeProposalOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private TypeDeclaration fsealedType;
        private ITypeBinding fSubTypeBinding;
        private TypeDeclaration fSubType;

        public AddTypeAsPermittedSubTypeProposalOperation(TypeDeclaration sealedType, TypeDeclaration subType, ITypeBinding subTypeBinding) {
            this.fsealedType = sealedType;
            this.fSubType = subType;
            this.fSubTypeBinding = subTypeBinding;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore model) throws CoreException {
            AST ast = this.fsealedType.getAST();
            String subTypeName = this.fSubType.getName().getIdentifier();
            SimpleType type = ast.newSimpleType((Name)ast.newSimpleName(subTypeName));
            ASTRewrite astRewrite = cuRewrite.getASTRewrite();
            astRewrite.getListRewrite((ASTNode)this.fsealedType, TypeDeclaration.PERMITS_TYPES_PROPERTY).insertLast((ASTNode)type, null);
            ImportRewrite importRewrite = cuRewrite.getImportRewrite();
            ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext(this.fsealedType.getRoot(), importRewrite);
            importRewrite.addImport(this.fSubTypeBinding, astRewrite.getAST(), (ImportRewrite.ImportRewriteContext)importRewriteContext);
        }
    }
}

