/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efbt.regdna.dsl.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import org.eclipse.efbt.regdna.model.regdna.ELAnnotation;
import org.eclipse.efbt.regdna.model.regdna.ELAnnotationDirective;
import org.eclipse.efbt.regdna.model.regdna.ELAttribute;
import org.eclipse.efbt.regdna.model.regdna.ELClass;
import org.eclipse.efbt.regdna.model.regdna.ELClassifier;
import org.eclipse.efbt.regdna.model.regdna.ELDataType;
import org.eclipse.efbt.regdna.model.regdna.ELEnum;
import org.eclipse.efbt.regdna.model.regdna.ELEnumLiteral;
import org.eclipse.efbt.regdna.model.regdna.ELOperation;
import org.eclipse.efbt.regdna.model.regdna.ELPackage;
import org.eclipse.efbt.regdna.model.regdna.ELReference;
import org.eclipse.efbt.regdna.model.regdna.ELStringToStringMapEntry;
import org.eclipse.efbt.regdna.model.regdna.ELStructuralFeature;
import org.eclipse.efbt.regdna.model.regdna.Filter;
import org.eclipse.efbt.regdna.model.regdna.Import;
import org.eclipse.efbt.regdna.model.regdna.Report;
import org.eclipse.efbt.regdna.model.regdna.ReportCell;
import org.eclipse.efbt.regdna.model.regdna.ReportModule;
import org.eclipse.efbt.regdna.model.regdna.RuleForILTablePart;
import org.eclipse.efbt.regdna.model.regdna.RulesForILTable;
import org.eclipse.efbt.regdna.model.regdna.RulesForReport;
import org.eclipse.efbt.regdna.model.regdna.SelectColumn;
import org.eclipse.efbt.regdna.model.regdna.SelectColumnAttributeAs;
import org.eclipse.efbt.regdna.model.regdna.SelectColumnMemberAs;
import org.eclipse.efbt.regdna.model.regdna.SelectDerivedColumnAs;
import org.eclipse.efbt.regdna.model.regdna.SelectValueAs;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class RegdnaGenerator
extends AbstractGenerator {
    public void doGenerate(Resource resource, IFileSystemAccess2 fsa, IGeneratorContext context) {
        Iterable _filter = Iterables.filter((Iterable)IteratorExtensions.toIterable((Iterator)resource.getAllContents()), ELPackage.class);
        for (ELPackage elpackage : _filter) {
            this.processPackage(elpackage, fsa);
            this.createXCoreForPackage(elpackage, fsa, resource);
        }
        Iterable _filter_1 = Iterables.filter((Iterable)IteratorExtensions.toIterable((Iterator)resource.getAllContents()), RulesForReport.class);
        for (RulesForReport rulesForReport : _filter_1) {
            this.processRulesForReport(rulesForReport, fsa);
            this.createOutputTablesAmendment(rulesForReport, fsa);
        }
        Iterable _filter_2 = Iterables.filter((Iterable)IteratorExtensions.toIterable((Iterator)resource.getAllContents()), ReportModule.class);
        for (ReportModule reportModule : _filter_2) {
            this.processReportModule(reportModule, fsa);
        }
    }

    public void processReportModule(ReportModule reportModule, IFileSystemAccess2 fsa) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package report_cells");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import output_tables.*");
        _builder.newLine();
        _builder.append("import sdd_domains.* ");
        _builder.newLine();
        _builder.newLine();
        EList _reports = reportModule.getReports();
        for (Report report : _reports) {
            EList _reportCells = report.getReportCells();
            for (ReportCell cell : _reportCells) {
                _builder.append("class Cell_");
                String _name = report.getOutputLayer().getName();
                _builder.append(_name);
                _builder.append("_");
                String _name_1 = cell.getRow().getName();
                _builder.append(_name_1);
                _builder.append("_");
                String _name_2 = cell.getColumn().getName();
                _builder.append(_name_2);
                _builder.newLineIfNotEmpty();
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("refers ");
                String _name_3 = report.getOutputLayer().getName();
                _builder.append(_name_3, "\t");
                _builder.append("_Table ");
                String _giveSmallFirstLetter = this.giveSmallFirstLetter(report.getOutputLayer().getName());
                _builder.append(_giveSmallFirstLetter, "\t");
                _builder.append("_Table");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("refers ");
                String _name_4 = report.getOutputLayer().getName();
                _builder.append(_name_4, "\t");
                _builder.append("[] ");
                String _giveSmallFirstLetter_1 = this.giveSmallFirstLetter(report.getOutputLayer().getName());
                _builder.append(_giveSmallFirstLetter_1, "\t");
                _builder.append("s");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("op String metric_value() {");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("var metric_total = 0.0");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("for( ");
                String _name_5 = report.getOutputLayer().getName();
                _builder.append(_name_5, "\t\t\t");
                _builder.append(" item : ");
                String _giveSmallFirstLetter_2 = this.giveSmallFirstLetter(report.getOutputLayer().getName());
                _builder.append(_giveSmallFirstLetter_2, "\t\t\t");
                _builder.append("s) ");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t\t\t\t");
                _builder.append("var metric = item.");
                String _name_6 = cell.getMetric().getName();
                _builder.append(_name_6, "\t\t\t\t");
                _builder.append("()");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t\t");
                _builder.append("metric_total = metric_total + metric");
                _builder.newLine();
                _builder.append("\t\t\t\t");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("return Double.toString(metric_total)");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("op  void calc_referenced_items() {");
                _builder.newLine();
                _builder.append("\t\t\t\t");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("for( ");
                String _name_7 = report.getOutputLayer().getName();
                _builder.append(_name_7, "\t\t\t");
                _builder.append(" item : ");
                String _giveSmallFirstLetter_3 = this.giveSmallFirstLetter(report.getOutputLayer().getName());
                _builder.append(_giveSmallFirstLetter_3, "\t\t\t");
                _builder.append("_Table.");
                String _giveSmallFirstLetter_4 = this.giveSmallFirstLetter(report.getOutputLayer().getName());
                _builder.append(_giveSmallFirstLetter_4, "\t\t\t");
                _builder.append("s) ");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t\t\t\t");
                _builder.append("var filter_passed = true");
                _builder.newLine();
                EList _filters = cell.getFilters();
                for (Filter filter : _filters) {
                    boolean _greaterThan;
                    int _size = filter.getMember().size();
                    boolean bl = _greaterThan = _size > 0;
                    if (!_greaterThan) continue;
                    _builder.append("\t\t\t\t");
                    _builder.append("if (!(");
                    EList _member = filter.getMember();
                    boolean _hasElements = false;
                    for (ELEnumLiteral literal : _member) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)" || ", "\t\t\t\t");
                        }
                        _builder.append("(item.");
                        String _name_8 = filter.getOperation().getName();
                        _builder.append(_name_8, "\t\t\t\t");
                        _builder.append(".equals(sdd_domains.");
                        EObject _eContainer = literal.eContainer();
                        String _name_9 = ((ELEnum)_eContainer).getName();
                        _builder.append(_name_9, "\t\t\t\t");
                        _builder.append(".");
                        String _upperCase = literal.getName().toUpperCase();
                        _builder.append(_upperCase, "\t\t\t\t");
                        _builder.append(" ))");
                    }
                    _builder.append("))");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t\t\t");
                    _builder.append("\t");
                    _builder.append("filter_passed = false");
                    _builder.newLine();
                }
                _builder.append("\t\t\t\t");
                _builder.append("if (filter_passed)");
                _builder.newLine();
                _builder.append("\t\t\t\t\t");
                _builder.append("f_05_01_REF_OutputItems.add(item)");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("op String  init() {");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("org.eclipse.efbt.regpot_desktop.orchestrator.Orchestration.init(this)");
                _builder.newLine();
                _builder.append("\t\t \t");
                _builder.append("calc_referenced_items() ");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("return null");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
            }
        }
        _builder.newLine();
        fsa.generateFile("report_cells.xcore", (CharSequence)_builder);
    }

    public void createOutputTablesAmendment(RulesForReport rulesForReport, IFileSystemAccess2 fsa) {
        String _name = rulesForReport.getOutputLayerCube().getName();
        String _plus = String.valueOf(_name) + "_output_layer_amendment.xcore";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _name_1 = rulesForReport.getOutputLayerCube().getName();
        _builder.append(_name_1);
        _builder.append("_output_layer_amendment");
        _builder.newLineIfNotEmpty();
        _builder.append("import sdd_domains.*");
        _builder.newLine();
        _builder.append("import input_tables.*");
        _builder.newLine();
        _builder.append("import output_tables.*");
        _builder.newLine();
        _builder.append("import ");
        String _name_2 = rulesForReport.getOutputLayerCube().getName();
        _builder.append(_name_2);
        _builder.append("_Logic.*");
        _builder.newLineIfNotEmpty();
        _builder.append("class ");
        String _name_3 = rulesForReport.getOutputLayerCube().getName();
        _builder.append(_name_3);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("refers ");
        String _name_4 = rulesForReport.getOutputLayerCube().getName();
        _builder.append(_name_4, "\t");
        _builder.append("_UnionItem  unionOfLayers ");
        _builder.newLineIfNotEmpty();
        EList _eOperations = rulesForReport.getOutputLayerCube().getEOperations();
        for (ELOperation eloperation : _eOperations) {
            boolean _equals;
            _builder.newLine();
            if (!(eloperation instanceof ELOperation)) continue;
            _builder.append(" \top ");
            String _name_5 = eloperation.getEType().getName();
            _builder.append(_name_5);
            _builder.append(" ");
            int _upperBound = eloperation.getUpperBound();
            boolean bl = _equals = _upperBound == -1;
            if (_equals) {
                _builder.append("[]  ");
            } else {
                boolean _not;
                boolean bl2 = _not = eloperation.getLowerBound() != 0 || eloperation.getUpperBound() != 1 && eloperation.getUpperBound() != 0;
                if (_not) {
                    _builder.append("[");
                    int _lowerBound = eloperation.getLowerBound();
                    _builder.append((Object)_lowerBound);
                    _builder.append("..");
                    int _upperBound_1 = eloperation.getUpperBound();
                    _builder.append((Object)_upperBound_1);
                    _builder.append("]");
                }
            }
            _builder.append(" ");
            String _name_6 = eloperation.getName();
            _builder.append(_name_6);
            _builder.append("()");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("unionOfLayers.");
            String _name_7 = eloperation.getName();
            _builder.append(_name_7, "\t\t");
            _builder.append("()");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        _builder.append("class ");
        String _name_8 = rulesForReport.getOutputLayerCube().getName();
        _builder.append(_name_8);
        _builder.append("_Table {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("refers  ");
        String _name_9 = rulesForReport.getOutputLayerCube().getName();
        _builder.append(_name_9, "\t\t\t\t");
        _builder.append("_UnionTable  unionOfLayersTable");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("contains  ");
        String _name_10 = rulesForReport.getOutputLayerCube().getName();
        _builder.append(_name_10, "\t\t\t\t");
        _builder.append(" [] ");
        String _name_11 = rulesForReport.getOutputLayerCube().getName();
        _builder.append(_name_11, "\t\t\t\t");
        _builder.append("s ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("op  ");
        String _name_12 = rulesForReport.getOutputLayerCube().getName();
        _builder.append(_name_12, "\t\t\t\t");
        _builder.append(" [] calc_");
        String _name_13 = rulesForReport.getOutputLayerCube().getName();
        _builder.append(_name_13, "\t\t\t\t");
        _builder.append("s() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t");
        _builder.append("var items = new org.eclipse.emf.common.util.BasicEList<");
        String _name_14 = rulesForReport.getOutputLayerCube().getName();
        _builder.append(_name_14, "\t\t\t\t\t");
        _builder.append(">()");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("for( ");
        String _name_15 = rulesForReport.getOutputLayerCube().getName();
        _builder.append(_name_15, "\t\t\t\t");
        _builder.append("_UnionItem item : unionOfLayersTable.");
        String _name_16 = rulesForReport.getOutputLayerCube().getName();
        _builder.append(_name_16, "\t\t\t\t");
        _builder.append("_UnionItems)");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("var newItem = Output_tablesFactory.eINSTANCE.create");
        String _name_17 = rulesForReport.getOutputLayerCube().getName();
        _builder.append(_name_17, "\t\t\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t");
        _builder.append("newItem.unionOfLayers =  item");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("items.add(newItem)");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("return items");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("} ");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("op String  init() {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("org.eclipse.efbt.regpot_desktop.orchestrator.Orchestration.init(this)");
        _builder.newLine();
        _builder.append("\t\t\t\t ");
        _builder.append("this.");
        String _name_18 = rulesForReport.getOutputLayerCube().getName();
        _builder.append(_name_18, "\t\t\t\t ");
        _builder.append("s.addAll(calc_");
        String _name_19 = rulesForReport.getOutputLayerCube().getName();
        _builder.append(_name_19, "\t\t\t\t ");
        _builder.append("s()) ");
        _builder.newLineIfNotEmpty();
        _builder.append(" \t\t\t\t");
        _builder.append("return null");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("} ");
        _builder.newLine();
        _builder.newLine();
        fsa.generateFile(_plus, (CharSequence)_builder);
    }

    public void processRulesForReport(RulesForReport rulesForReport, IFileSystemAccess2 fsa) {
        String _name = rulesForReport.getOutputLayerCube().getName();
        String _plus = String.valueOf(_name) + "_Logic.xcore";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _name_1 = rulesForReport.getOutputLayerCube().getName();
        _builder.append(_name_1);
        _builder.append("_Logic");
        _builder.newLineIfNotEmpty();
        _builder.append("import sdd_domains.*");
        _builder.newLine();
        _builder.append("import input_tables.*");
        _builder.newLine();
        _builder.append("import output_tables.*");
        _builder.newLine();
        _builder.append("annotation \"dep\" as dep");
        _builder.newLine();
        _builder.append("class ");
        String _name_2 = rulesForReport.getOutputLayerCube().getName();
        _builder.append(_name_2);
        _builder.append("_UnionItem {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("refers ");
        String _name_3 = rulesForReport.getOutputLayerCube().getName();
        _builder.append(_name_3, "\t");
        _builder.append("_Base base ");
        _builder.newLineIfNotEmpty();
        EList _eOperations = rulesForReport.getOutputLayerCube().getEOperations();
        for (ELOperation eloperation : _eOperations) {
            boolean _equals;
            _builder.newLine();
            if (!(eloperation instanceof ELOperation)) continue;
            _builder.append("\t\t@dep (dep1=\"base.");
            String _name_4 = eloperation.getName();
            _builder.append(_name_4);
            _builder.append("\")");
            _builder.newLineIfNotEmpty();
            _builder.append(" \t");
            _builder.append("op ");
            String _name_5 = eloperation.getEType().getName();
            _builder.append(_name_5, " \t");
            _builder.append(" ");
            int _upperBound = eloperation.getUpperBound();
            boolean bl = _equals = _upperBound == -1;
            if (_equals) {
                _builder.append("[]  ");
            } else {
                boolean _not;
                boolean bl2 = _not = eloperation.getLowerBound() != 0 || eloperation.getUpperBound() != 1 && eloperation.getUpperBound() != 0;
                if (_not) {
                    _builder.append("[");
                    int _lowerBound = eloperation.getLowerBound();
                    _builder.append((Object)_lowerBound, " \t");
                    _builder.append("..");
                    int _upperBound_1 = eloperation.getUpperBound();
                    _builder.append((Object)_upperBound_1, " \t");
                    _builder.append("]");
                }
            }
            _builder.append(" ");
            String _name_6 = eloperation.getName();
            _builder.append(_name_6, " \t");
            _builder.append("()");
            _builder.newLineIfNotEmpty();
            _builder.append(" \t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("base.");
            String _name_7 = eloperation.getName();
            _builder.append(_name_7, "\t\t");
            _builder.append("()");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        _builder.append("class ");
        String _name_8 = rulesForReport.getOutputLayerCube().getName();
        _builder.append(_name_8);
        _builder.append("_Base {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        EList _eOperations_1 = rulesForReport.getOutputLayerCube().getEOperations();
        for (ELOperation eloperation_1 : _eOperations_1) {
            boolean _equals_1;
            _builder.append("\t\t");
            _builder.newLine();
            if (!(eloperation_1 instanceof ELOperation)) continue;
            _builder.append(" \top ");
            String _name_9 = eloperation_1.getEType().getName();
            _builder.append(_name_9);
            _builder.append(" ");
            int _upperBound_2 = eloperation_1.getUpperBound();
            boolean bl = _equals_1 = _upperBound_2 == -1;
            if (_equals_1) {
                _builder.append("[]  ");
            } else {
                boolean _not_1;
                boolean bl3 = _not_1 = eloperation_1.getLowerBound() != 0 || eloperation_1.getUpperBound() != 1 && eloperation_1.getUpperBound() != 0;
                if (_not_1) {
                    _builder.append("[");
                    int _lowerBound_1 = eloperation_1.getLowerBound();
                    _builder.append((Object)_lowerBound_1);
                    _builder.append("..");
                    int _upperBound_3 = eloperation_1.getUpperBound();
                    _builder.append((Object)_upperBound_3);
                    _builder.append("]");
                }
            }
            _builder.append("  ");
            String _name_10 = eloperation_1.getName();
            _builder.append(_name_10);
            _builder.append("()");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            String _name_11 = eloperation_1.getEType().getName();
            boolean _equals_2 = Objects.equal((Object)_name_11, (Object)"double");
            if (_equals_2) {
                _builder.append("return 0");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
            } else {
                String _name_12 = eloperation_1.getEType().getName();
                boolean _equals_3 = Objects.equal((Object)_name_12, (Object)"int");
                if (_equals_3) {
                    _builder.append("return 0");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                } else {
                    String _name_13 = eloperation_1.getEType().getName();
                    boolean _equals_4 = Objects.equal((Object)_name_13, (Object)"boolean");
                    if (_equals_4) {
                        _builder.append("return true");
                        _builder.newLineIfNotEmpty();
                    }
                }
            }
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("class ");
        String _name_14 = rulesForReport.getOutputLayerCube().getName();
        _builder.append(_name_14);
        _builder.append("_UnionTable {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t \t");
        _builder.append("contains  ");
        String _name_15 = rulesForReport.getOutputLayerCube().getName();
        _builder.append(_name_15, "\t\t\t \t");
        _builder.append("_UnionItem []   ");
        String _name_16 = rulesForReport.getOutputLayerCube().getName();
        _builder.append(_name_16, "\t\t\t \t");
        _builder.append("_UnionItems\t");
        _builder.newLineIfNotEmpty();
        EList _rulesForTable = rulesForReport.getRulesForTable();
        for (RulesForILTable tableRules : _rulesForTable) {
            EList _rulesForTablePart = tableRules.getRulesForTablePart();
            for (RuleForILTablePart tablePartRules : _rulesForTablePart) {
                _builder.append("\t\t\t \t");
                _builder.append("refers ");
                String _name_17 = tablePartRules.getName();
                _builder.append(_name_17, "\t\t\t \t");
                _builder.append("_Table  ");
                String _name_18 = tablePartRules.getName();
                _builder.append(_name_18, "\t\t\t \t");
                _builder.append("_Table");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("\t\t\t \t");
        _builder.append("op ");
        String _name_19 = rulesForReport.getOutputLayerCube().getName();
        _builder.append(_name_19, "\t\t\t \t");
        _builder.append("_UnionItem []   calc_");
        String _name_20 = rulesForReport.getOutputLayerCube().getName();
        _builder.append(_name_20, "\t\t\t \t");
        _builder.append("_UnionItems() ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t\t \t");
        _builder.append("var items = new org.eclipse.emf.common.util.BasicEList<");
        String _name_21 = rulesForReport.getOutputLayerCube().getName();
        _builder.append(_name_21, "\t\t\t\t \t");
        _builder.append("_UnionItem>()");
        _builder.newLineIfNotEmpty();
        EList _rulesForTable_1 = rulesForReport.getRulesForTable();
        for (RulesForILTable tableRules_1 : _rulesForTable_1) {
            EList _rulesForTablePart_1 = tableRules_1.getRulesForTablePart();
            for (RuleForILTablePart tablePartRules_1 : _rulesForTablePart_1) {
                _builder.append("for(");
                String _name_22 = tablePartRules_1.getName();
                _builder.append(_name_22);
                _builder.append(" item : ");
                String _giveSmallFirstLetter = this.giveSmallFirstLetter(tablePartRules_1.getName());
                _builder.append(_giveSmallFirstLetter);
                _builder.append("_Table.");
                String _giveSmallFirstLetter_1 = this.giveSmallFirstLetter(tablePartRules_1.getName());
                _builder.append(_giveSmallFirstLetter_1);
                _builder.append("s)");
                _builder.newLineIfNotEmpty();
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("var newItem = ");
                String _name_23 = rulesForReport.getOutputLayerCube().getName();
                _builder.append(_name_23, "\t");
                _builder.append("_LogicFactory.eINSTANCE.create");
                String _name_24 = rulesForReport.getOutputLayerCube().getName();
                _builder.append(_name_24, "\t");
                _builder.append("_UnionItem");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("newItem.base = item");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("items.add(newItem)");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
            }
        }
        _builder.append("\t\t\t\t \t");
        _builder.append("return items");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t \t");
        _builder.append("op String  init() ");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t\t \t");
        _builder.append("org.eclipse.efbt.regpot_desktop.orchestrator.Orchestration.init(this) ");
        _builder.newLine();
        _builder.append("\t \t \t\t\t");
        _builder.append("this.");
        String _giveSmallFirstLetter_2 = this.giveSmallFirstLetter(rulesForReport.getOutputLayerCube().getName());
        _builder.append(_giveSmallFirstLetter_2, "\t \t \t\t\t");
        _builder.append("_UnionItems.addAll(calc_");
        String _name_25 = rulesForReport.getOutputLayerCube().getName();
        _builder.append(_name_25, "\t \t \t\t\t");
        _builder.append("_UnionItems)");
        _builder.newLineIfNotEmpty();
        _builder.append("\t \t \t\t\t  ");
        _builder.append("return null");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        EList _rulesForTable_2 = rulesForReport.getRulesForTable();
        for (RulesForILTable tableRules_2 : _rulesForTable_2) {
            EList _rulesForTablePart_2 = tableRules_2.getRulesForTablePart();
            for (RuleForILTablePart tablePartRules_2 : _rulesForTablePart_2) {
                _builder.append("class ");
                String _name_26 = tablePartRules_2.getName();
                _builder.append(_name_26);
                _builder.append("  extends ");
                String _name_27 = rulesForReport.getOutputLayerCube().getName();
                _builder.append(_name_27);
                _builder.append("_Base {");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                EList _columns = tablePartRules_2.getColumns();
                for (SelectColumn column : _columns) {
                    if (!(column instanceof SelectColumnAttributeAs)) continue;
                    _builder.append("// remove any duplicates in these refers statements");
                    _builder.newLine();
                    _builder.append("refers ");
                    EObject _eContainer = ((SelectColumnAttributeAs)column).getAttribute().eContainer();
                    String _name_28 = ((ELClass)_eContainer).getName();
                    _builder.append(_name_28);
                    _builder.append(" ");
                    EObject _eContainer_1 = ((SelectColumnAttributeAs)column).getAttribute().eContainer();
                    String _giveSmallFirstLetter_3 = this.giveSmallFirstLetter(((ELClass)_eContainer_1).getName());
                    _builder.append(_giveSmallFirstLetter_3);
                    _builder.newLineIfNotEmpty();
                }
                EList _columns_1 = tablePartRules_2.getColumns();
                for (SelectColumn column_1 : _columns_1) {
                    if (column_1 instanceof SelectDerivedColumnAs) {
                        _builder.append("@dep (dep1=\"");
                        EObject _eContainer_2 = ((SelectDerivedColumnAs)column_1).getAttribute().eContainer();
                        String _name_29 = ((ELClass)_eContainer_2).getName();
                        _builder.append(_name_29);
                        _builder.append(".");
                        String _name_30 = ((SelectDerivedColumnAs)column_1).getAttribute().getName();
                        _builder.append(_name_30);
                        _builder.append("\")");
                        _builder.newLineIfNotEmpty();
                    }
                    if (column_1 instanceof SelectColumnAttributeAs) {
                        _builder.append("@dep (dep1=\"");
                        EObject _eContainer_3 = ((SelectColumnAttributeAs)column_1).getAttribute().eContainer();
                        String _name_31 = ((ELClass)_eContainer_3).getName();
                        _builder.append(_name_31);
                        _builder.append(".");
                        String _name_32 = ((SelectColumnAttributeAs)column_1).getAttribute().getName();
                        _builder.append(_name_32);
                        _builder.append("\")");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("op ");
                    String _name_33 = column_1.getAsAttribute().getEType().getName();
                    _builder.append(_name_33);
                    _builder.append("  ");
                    String _name_34 = column_1.getAsAttribute().getName();
                    _builder.append(_name_34);
                    _builder.append("() ");
                    _builder.newLineIfNotEmpty();
                    _builder.append("{");
                    _builder.newLine();
                    if (column_1 instanceof SelectColumnMemberAs) {
                        _builder.append("\t");
                        _builder.append("sdd_domains.");
                        String _name_35 = ((SelectColumnMemberAs)column_1).getAsAttribute().getEType().getName();
                        _builder.append(_name_35, "\t");
                        _builder.append(".");
                        String _upperCase = ((SelectColumnMemberAs)column_1).getMemberAsConstant().getName().toUpperCase();
                        _builder.append(_upperCase, "\t");
                        _builder.newLineIfNotEmpty();
                    } else if (column_1 instanceof SelectValueAs) {
                        _builder.append("\t");
                        _builder.append("\"");
                        String _value = ((SelectValueAs)column_1).getValue();
                        _builder.append(_value, "\t");
                        _builder.append("\"");
                        _builder.newLineIfNotEmpty();
                    } else if (column_1 instanceof SelectColumnAttributeAs) {
                        _builder.append("\t");
                        EObject _eContainer_4 = ((SelectColumnAttributeAs)column_1).getAttribute().eContainer();
                        String _name_36 = ((ELClass)_eContainer_4).getName();
                        _builder.append(_name_36, "\t");
                        _builder.append(".");
                        String _name_37 = ((SelectColumnAttributeAs)column_1).getAttribute().getName();
                        _builder.append(_name_37, "\t");
                        _builder.newLineIfNotEmpty();
                    } else if (column_1 instanceof SelectDerivedColumnAs) {
                        _builder.append("\t");
                        EObject _eContainer_5 = ((SelectDerivedColumnAs)column_1).getAttribute().eContainer();
                        String _name_38 = ((ELClass)_eContainer_5).getName();
                        _builder.append(_name_38, "\t");
                        _builder.append(".");
                        String _name_39 = ((SelectDerivedColumnAs)column_1).getAttribute().getName();
                        _builder.append(_name_39, "\t");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("}");
                    _builder.newLine();
                }
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("class ");
                String _name_40 = tablePartRules_2.getName();
                _builder.append(_name_40);
                _builder.append("_Table {");
                _builder.newLineIfNotEmpty();
                EList _columns_2 = tablePartRules_2.getColumns();
                for (SelectColumn column_2 : _columns_2) {
                    if (!(column_2 instanceof SelectColumnAttributeAs)) continue;
                    _builder.append("\t\t\t\t");
                    _builder.append("refers ");
                    EObject _eContainer_6 = ((SelectColumnAttributeAs)column_2).getAttribute().eContainer();
                    String _name_41 = ((ELClass)_eContainer_6).getName();
                    _builder.append(_name_41, "\t\t\t\t");
                    _builder.append("_Table ");
                    EObject _eContainer_7 = ((SelectColumnAttributeAs)column_2).getAttribute().eContainer();
                    String _giveSmallFirstLetter_4 = this.giveSmallFirstLetter(((ELClass)_eContainer_7).getName());
                    _builder.append(_giveSmallFirstLetter_4, "\t\t\t\t");
                    _builder.append("_Table");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t\t\t");
                    _builder.append("// remove any duplicates in these refers statements");
                    _builder.newLine();
                }
                _builder.append("\t\t\t \t");
                _builder.append("contains  ");
                String _name_42 = tablePartRules_2.getName();
                _builder.append(_name_42, "\t\t\t \t");
                _builder.append(" []   ");
                String _name_43 = tablePartRules_2.getName();
                _builder.append(_name_43, "\t\t\t \t");
                _builder.append("s\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t \t");
                _builder.append("op ");
                String _name_44 = tablePartRules_2.getName();
                _builder.append(_name_44, "\t\t\t \t");
                _builder.append(" []   calc_");
                String _name_45 = tablePartRules_2.getName();
                _builder.append(_name_45, "\t\t\t \t");
                _builder.append("s() ");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t\t");
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t\t\t\t \t");
                _builder.append("var items = new org.eclipse.emf.common.util.BasicEList<");
                String _name_46 = tablePartRules_2.getName();
                _builder.append(_name_46, "\t\t\t\t \t");
                _builder.append(">()");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t \t\t \t");
                _builder.append("//Join up any refered tables that you need to join");
                _builder.newLine();
                _builder.append("\t\t \t\t \t");
                _builder.append("//loop through the main table");
                _builder.newLine();
                _builder.append("\t\t \t\t \t");
                _builder.append("//create an item using var newItem = ");
                String _name_47 = rulesForReport.getOutputLayerCube().getName();
                _builder.append(_name_47, "\t\t \t\t \t");
                _builder.append("_LogicFactory.eINSTANCE.create");
                String _name_48 = tablePartRules_2.getName();
                _builder.append(_name_48, "\t\t \t\t \t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t \t\t \t");
                _builder.append("//set any references you want to on the new Item so that it can refer to themin operations");
                _builder.newLine();
                _builder.append("\t\t \t\t \t");
                _builder.append("return items");
                _builder.newLine();
                _builder.append("\t\t\t\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t\t\t \t");
                _builder.append("op String  init() ");
                _builder.newLine();
                _builder.append("\t\t\t\t");
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t\t\t\t \t");
                _builder.append("org.eclipse.efbt.regpot_desktop.orchestrator.Orchestration.init(this)");
                _builder.newLine();
                _builder.append("\t\t \t\t \t");
                _builder.append("this.");
                String _giveSmallFirstLetter_5 = this.giveSmallFirstLetter(tablePartRules_2.getName());
                _builder.append(_giveSmallFirstLetter_5, "\t\t \t\t \t");
                _builder.append("s.addAll(calc_");
                String _name_49 = tablePartRules_2.getName();
                _builder.append(_name_49, "\t\t \t\t \t");
                _builder.append("s) \t\t ");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t \t\t \t");
                _builder.append("return null");
                _builder.newLine();
                _builder.append("\t\t\t\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("}");
                _builder.newLine();
            }
        }
        _builder.newLine();
        fsa.generateFile(_plus, (CharSequence)_builder);
    }

    public String giveSmallFirstLetter(String string) {
        String firstLetter = string.substring(0, 1);
        String smallFirstLetter = firstLetter.toLowerCase();
        String _substring = string.substring(1, string.length());
        return String.valueOf(smallFirstLetter) + _substring;
    }

    public void createXCoreForPackage(ELPackage elpackage, IFileSystemAccess2 fsa, Resource resource) {
        boolean _notEquals;
        String _name = elpackage.getName();
        String _plus = String.valueOf(_name) + ".xcore";
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("package ");
        String _name_1 = elpackage.getName();
        _builder.append(_name_1);
        _builder.newLineIfNotEmpty();
        String _trim = elpackage.getName().trim();
        boolean bl = _notEquals = !Objects.equal((Object)_trim, (Object)"types");
        if (_notEquals) {
            EList _imports = elpackage.getImports();
            for (Import theImport : _imports) {
                boolean _notEquals_1;
                _builder.newLine();
                String _trim_1 = theImport.getImportedNamespace().trim();
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)_trim_1, (Object)"types.*");
                if (!_notEquals_1) continue;
                _builder.append("import ");
                String _importedNamespace = theImport.getImportedNamespace();
                _builder.append(_importedNamespace);
                _builder.append(" ");
                _builder.newLineIfNotEmpty();
            }
            EList _annotationDirectives = elpackage.getAnnotationDirectives();
            for (ELAnnotationDirective annotationDirective : _annotationDirectives) {
                _builder.append("annotation \"");
                String _sourceURI = annotationDirective.getSourceURI();
                _builder.append(_sourceURI);
                _builder.append("\" as ");
                String _name_2 = annotationDirective.getName();
                _builder.append(_name_2);
                _builder.newLineIfNotEmpty();
            }
            Iterable _filter = Iterables.filter((Iterable)elpackage.getEClassifiers(), ELClass.class);
            for (ELClass elclass : _filter) {
                boolean _notEquals_2;
                boolean _equals;
                EList _eAnnotations = elclass.getEAnnotations();
                for (ELAnnotation annotion : _eAnnotations) {
                    _builder.append("@");
                    String _name_3 = annotion.getSource().getName();
                    _builder.append(_name_3);
                    _builder.append(" (");
                    EList _details = annotion.getDetails();
                    boolean _hasElements = false;
                    for (Object detail : _details) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)",", "");
                        }
                        _builder.append(" ");
                        String _key = detail.getKey();
                        _builder.append(_key);
                        _builder.append("=\"");
                        String _value = detail.getValue();
                        _builder.append(_value);
                        _builder.append("\"");
                    }
                    _builder.append(")");
                    _builder.newLineIfNotEmpty();
                }
                boolean _isEAbstract = elclass.isEAbstract();
                if (_isEAbstract) {
                    _builder.append("abstract ");
                }
                _builder.append("class ");
                String _name_4 = elclass.getName();
                _builder.append(_name_4);
                _builder.append(" ");
                int _length = ((Object[])Conversions.unwrapArray((Object)elclass.getESuperTypes(), Object.class)).length;
                boolean bl3 = _equals = _length == 1;
                if (_equals) {
                    _builder.append(" extends ");
                    String _name_5 = ((ELClass)elclass.getESuperTypes().get(0)).getName();
                    _builder.append(_name_5);
                    _builder.append(" ");
                }
                _builder.append("{");
                _builder.newLineIfNotEmpty();
                EList _eStructuralFeatures = elclass.getEStructuralFeatures();
                for (ELStructuralFeature elmember : _eStructuralFeatures) {
                    Object detail;
                    EList _eAnnotations_1 = elmember.getEAnnotations();
                    detail = _eAnnotations_1.iterator();
                    while (detail.hasNext()) {
                        ELAnnotation annotion_1 = (ELAnnotation)detail.next();
                        _builder.append("\t@");
                        String _name_6 = annotion_1.getSource().getName();
                        _builder.append(_name_6);
                        _builder.append(" (");
                        EList _details_1 = annotion_1.getDetails();
                        boolean _hasElements_1 = false;
                        for (ELStringToStringMapEntry detail_1 : _details_1) {
                            if (!_hasElements_1) {
                                _hasElements_1 = true;
                            } else {
                                _builder.appendImmediate((Object)",", "");
                            }
                            _builder.append(" ");
                            String _key_1 = detail_1.getKey();
                            _builder.append(_key_1);
                            _builder.append("=\"");
                            String _value_1 = detail_1.getValue();
                            _builder.append(_value_1);
                            _builder.append("\"");
                        }
                        _builder.append(")");
                        _builder.newLineIfNotEmpty();
                    }
                    if (elmember instanceof ELAttribute) {
                        boolean _equals_1;
                        _builder.append(" \t");
                        boolean _isID = ((ELAttribute)elmember).isID();
                        if (_isID) {
                            _builder.append("id ");
                        }
                        String _name_7 = ((ELAttribute)elmember).getEAttributeType().getName();
                        _builder.append(_name_7);
                        _builder.append(" ");
                        int _upperBound = ((ELAttribute)elmember).getUpperBound();
                        boolean bl4 = _equals_1 = _upperBound == -1;
                        if (_equals_1) {
                            _builder.append("[]  ");
                        } else {
                            boolean _not;
                            boolean bl5 = _not = ((ELAttribute)elmember).getLowerBound() != 0 || ((ELAttribute)elmember).getUpperBound() != 1 && ((ELAttribute)elmember).getUpperBound() != 0;
                            if (_not) {
                                _builder.append("[");
                                int _lowerBound = ((ELAttribute)elmember).getLowerBound();
                                _builder.append((Object)_lowerBound);
                                _builder.append("..");
                                int _upperBound_1 = ((ELAttribute)elmember).getUpperBound();
                                _builder.append((Object)_upperBound_1);
                                _builder.append("]");
                            }
                        }
                        _builder.append(" ");
                        String _name_8 = ((ELAttribute)elmember).getName();
                        _builder.append(_name_8);
                        _builder.append(" ");
                    }
                    _builder.newLineIfNotEmpty();
                    if (elmember instanceof ELReference) {
                        boolean _equals_2;
                        _builder.append(" \t");
                        boolean _isContainment = ((ELReference)elmember).isContainment();
                        if (_isContainment) {
                            _builder.append("contains ");
                        } else {
                            _builder.append("refers");
                        }
                        _builder.append(" ");
                        String _name_9 = ((ELReference)elmember).getEType().getName();
                        _builder.append(_name_9);
                        _builder.append(" ");
                        int _upperBound_2 = ((ELReference)elmember).getUpperBound();
                        boolean bl6 = _equals_2 = _upperBound_2 == -1;
                        if (_equals_2) {
                            _builder.append("[]  ");
                        } else {
                            boolean _not_1;
                            boolean bl7 = _not_1 = ((ELReference)elmember).getLowerBound() != 0 || ((ELReference)elmember).getUpperBound() != 1 && ((ELReference)elmember).getUpperBound() != 0;
                            if (_not_1) {
                                _builder.append("[");
                                int _lowerBound_1 = ((ELReference)elmember).getLowerBound();
                                _builder.append((Object)_lowerBound_1);
                                _builder.append("..");
                                int _upperBound_3 = ((ELReference)elmember).getUpperBound();
                                _builder.append((Object)_upperBound_3);
                                _builder.append("]");
                            }
                        }
                        _builder.append(" ");
                        String _name_10 = ((ELReference)elmember).getName();
                        _builder.append(_name_10);
                    }
                    _builder.append("\t");
                    _builder.newLineIfNotEmpty();
                }
                EList _eOperations = elclass.getEOperations();
                for (ELOperation eloperation : _eOperations) {
                    boolean _tripleNotEquals;
                    boolean _equals_3;
                    EList _eAnnotations_2 = eloperation.getEAnnotations();
                    for (ELAnnotation annotion_2 : _eAnnotations_2) {
                        _builder.append("\t@");
                        String _name_11 = annotion_2.getSource().getName();
                        _builder.append(_name_11);
                        _builder.append(" (");
                        EList _details_2 = annotion_2.getDetails();
                        boolean _hasElements_2 = false;
                        for (ELStringToStringMapEntry detail_2 : _details_2) {
                            if (!_hasElements_2) {
                                _hasElements_2 = true;
                            } else {
                                _builder.appendImmediate((Object)",", "");
                            }
                            _builder.append(" ");
                            String _key_2 = detail_2.getKey();
                            _builder.append(_key_2);
                            _builder.append("=\"");
                            String _value_2 = detail_2.getValue();
                            _builder.append(_value_2);
                            _builder.append("\"");
                        }
                        _builder.append(")");
                        _builder.newLineIfNotEmpty();
                    }
                    if (!(eloperation instanceof ELOperation)) continue;
                    _builder.append(" \top ");
                    String _name_12 = eloperation.getEType().getName();
                    _builder.append(_name_12);
                    _builder.append(" ");
                    int _upperBound_4 = eloperation.getUpperBound();
                    boolean bl8 = _equals_3 = _upperBound_4 == -1;
                    if (_equals_3) {
                        _builder.append("[]  ");
                    } else {
                        boolean _not_2;
                        boolean bl9 = _not_2 = eloperation.getLowerBound() != 0 || eloperation.getUpperBound() != 1 && eloperation.getUpperBound() != 0;
                        if (_not_2) {
                            _builder.append("[");
                            int _lowerBound_2 = eloperation.getLowerBound();
                            _builder.append((Object)_lowerBound_2);
                            _builder.append("..");
                            int _upperBound_5 = eloperation.getUpperBound();
                            _builder.append((Object)_upperBound_5);
                            _builder.append("]");
                        }
                    }
                    _builder.append(" ");
                    String _name_13 = eloperation.getName();
                    _builder.append(_name_13);
                    _builder.append("()");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("{");
                    _builder.newLine();
                    String _body = eloperation.getBody();
                    boolean bl10 = _tripleNotEquals = _body != null;
                    if (_tripleNotEquals) {
                        _builder.append("          ");
                        String _findXCoreSubstring = this.findXCoreSubstring(eloperation.getBody());
                        _builder.append(_findXCoreSubstring);
                        _builder.newLineIfNotEmpty();
                    } else {
                        String _name_14 = eloperation.getEType().getName();
                        boolean _equals_4 = Objects.equal((Object)_name_14, (Object)"double");
                        if (_equals_4) {
                            _builder.append("        return 0");
                            _builder.newLineIfNotEmpty();
                        } else {
                            String _name_15 = eloperation.getEType().getName();
                            boolean _equals_5 = Objects.equal((Object)_name_15, (Object)"int");
                            if (_equals_5) {
                                _builder.append("        return 0");
                                _builder.newLineIfNotEmpty();
                            } else {
                                String _name_16 = eloperation.getEType().getName();
                                boolean _equals_6 = Objects.equal((Object)_name_16, (Object)"boolean");
                                if (_equals_6) {
                                    _builder.append("        return true");
                                    _builder.newLineIfNotEmpty();
                                }
                            }
                        }
                    }
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                }
                _builder.append("}");
                _builder.newLine();
                String _trim_2 = elpackage.getName().trim();
                boolean bl11 = _notEquals_2 = !Objects.equal((Object)_trim_2, (Object)"ldm_entities");
                if (!_notEquals_2) continue;
                _builder.append("class ");
                String _name_17 = elclass.getName();
                _builder.append(_name_17);
                _builder.append("_Table {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("contains  ");
                String _name_18 = elclass.getName();
                _builder.append(_name_18, "\t");
                _builder.append(" [] ");
                String _name_19 = elclass.getName();
                _builder.append(_name_19, "\t");
                _builder.append("s \t\t\t\t\t\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("} ");
                _builder.newLine();
            }
            Iterable _filter_1 = Iterables.filter((Iterable)elpackage.getEClassifiers(), ELEnum.class);
            for (ELEnum elEnum : _filter_1) {
                _builder.append("enum ");
                String _name_20 = elEnum.getName();
                _builder.append(_name_20);
                _builder.append(" {");
                EList _eLiterals = elEnum.getELiterals();
                for (ELEnumLiteral elliteral : _eLiterals) {
                    _builder.append("  ");
                    String _name_21 = elliteral.getName();
                    _builder.append(_name_21);
                    _builder.append("  as \"");
                    String _literal = elliteral.getLiteral();
                    _builder.append(_literal);
                    _builder.append("\"  = ");
                    int _value_3 = elliteral.getValue();
                    _builder.append((Object)_value_3);
                    _builder.append(" ");
                }
                _builder.append("}");
                _builder.newLineIfNotEmpty();
            }
            Iterable _iterable = IteratorExtensions.toIterable((Iterator)Iterators.filter((Iterator)resource.getAllContents(), ELDataType.class));
            for (ELDataType xDataType : _iterable) {
                if (!(xDataType instanceof ELEnum)) {
                    _builder.append("type  ");
                    String _name_22 = xDataType.getName();
                    _builder.append(_name_22);
                    _builder.append(" wraps ");
                    String _name_23 = xDataType.getName();
                    boolean _equals_7 = Objects.equal((Object)_name_23, (Object)"Date");
                    if (_equals_7) {
                        _builder.append("java.util.Date ");
                    } else {
                        String _name_24 = xDataType.getName();
                        _builder.append(_name_24);
                        _builder.append(" ");
                    }
                    _builder.append(" ");
                    _builder.newLineIfNotEmpty();
                }
                _builder.newLine();
            }
        }
        fsa.generateFile(_plus, (CharSequence)_builder);
    }

    public EPackage processPackage(ELPackage elpackage, IFileSystemAccess2 fsa) {
        try {
            EList _eOperations;
            EList _eStructuralFeatures;
            new BasicEList();
            BasicEList dependantEcorePackages = new BasicEList();
            BasicEList processedELPackages = new BasicEList();
            EPackage ecore_package = EcoreFactory.eINSTANCE.createEPackage();
            ecore_package.setName(elpackage.getName());
            String _nsURI = elpackage.getNsURI();
            String _plus = "http://www.eclipse.org/efbt/" + _nsURI;
            ecore_package.setNsURI(_plus);
            ecore_package.setNsPrefix(elpackage.getName());
            EList _eClassifiers = elpackage.getEClassifiers();
            for (ELClassifier classifier : _eClassifiers) {
                boolean _greaterThan;
                if (classifier instanceof ELEnum) {
                    EEnum e_enum = EcoreFactory.eINSTANCE.createEEnum();
                    e_enum.setName(((ELEnum)classifier).getName());
                    EList _eLiterals = ((ELEnum)classifier).getELiterals();
                    for (ELEnumLiteral literal : _eLiterals) {
                        EEnumLiteral e_enum_literal = EcoreFactory.eINSTANCE.createEEnumLiteral();
                        e_enum_literal.setName(literal.getName());
                        e_enum_literal.setValue(literal.getValue());
                        e_enum_literal.setLiteral(literal.getLiteral());
                        e_enum.getELiterals().add((Object)e_enum_literal);
                    }
                    ecore_package.getEClassifiers().add((Object)e_enum);
                    EList _eAnnotations = ((ELEnum)classifier).getEAnnotations();
                    for (ELAnnotation anno : _eAnnotations) {
                        EAnnotation annotation_copy = EcoreFactory.eINSTANCE.createEAnnotation();
                        annotation_copy.setSource(anno.getSource().getSourceURI());
                        EList _details = anno.getDetails();
                        for (ELStringToStringMapEntry item : _details) {
                            annotation_copy.getDetails().put((Object)item.getKey(), (Object)item.getValue());
                        }
                        e_enum.getEAnnotations().add((Object)annotation_copy);
                    }
                }
                if (!(classifier instanceof ELClass)) continue;
                Iterator e_class = EcoreFactory.eINSTANCE.createEClass();
                e_class.setName(((ELClass)classifier).getName());
                e_class.setAbstract(((ELClass)classifier).isEAbstract());
                int _size = ((ELClass)classifier).getESuperTypes().size();
                boolean bl = _greaterThan = _size > 0;
                if (_greaterThan) {
                    ELPackage superTypesPackage = ((ELClass)((ELClass)classifier).getESuperTypes().get(0)).getEPackage();
                    if (processedELPackages.indexOf((Object)superTypesPackage) == -1 && superTypesPackage != null && !Objects.equal((Object)superTypesPackage.getName(), (Object)"types") && !Objects.equal((Object)superTypesPackage, (Object)elpackage)) {
                        processedELPackages.add((Object)superTypesPackage);
                        dependantEcorePackages.add((Object)this.processPackage(superTypesPackage, fsa));
                    }
                    String superTypeName = ((ELClass)((ELClass)classifier).getESuperTypes().get(0)).getName();
                    Iterator annotation = EcoreFactory.eINSTANCE.createEAnnotation();
                    annotation.setSource("temp");
                    annotation.getDetails().put((Object)"superTypeName", (Object)superTypeName);
                    e_class.getEAnnotations().add((Object)annotation);
                    EList _eAnnotations_1 = ((ELClass)classifier).getEAnnotations();
                    for (ELAnnotation anno_1 : _eAnnotations_1) {
                        EAnnotation annotation_copy = EcoreFactory.eINSTANCE.createEAnnotation();
                        annotation_copy.setSource(anno_1.getSource().getSourceURI());
                        EList _details = anno_1.getDetails();
                        for (ELStringToStringMapEntry item : _details) {
                            annotation_copy.getDetails().put((Object)item.getKey(), (Object)item.getValue());
                        }
                        e_class.getEAnnotations().add((Object)annotation_copy);
                    }
                }
                _eStructuralFeatures = ((ELClass)classifier).getEStructuralFeatures();
                for (EStructuralFeature structural_feature : _eStructuralFeatures) {
                    boolean _notEquals_1;
                    if (structural_feature instanceof ELAttribute) {
                        ELDataType _eAttributeType;
                        boolean _notEquals;
                        EAttribute e_attribute = EcoreFactory.eINSTANCE.createEAttribute();
                        e_class.getEStructuralFeatures().add((Object)e_attribute);
                        e_attribute.setName(((ELAttribute)structural_feature).getName());
                        int _upperBound = ((ELAttribute)structural_feature).getUpperBound();
                        boolean bl2 = _notEquals = _upperBound != 0;
                        if (_notEquals) {
                            e_attribute.setUpperBound(((ELAttribute)structural_feature).getUpperBound());
                        } else {
                            e_attribute.setUpperBound(1);
                        }
                        e_attribute.setLowerBound(((ELAttribute)structural_feature).getLowerBound());
                        String type_name = ((ELAttribute)structural_feature).getEAttributeType().getName();
                        boolean _isID = ((ELAttribute)structural_feature).isID();
                        if (_isID) {
                            e_attribute.setID(true);
                        }
                        if ((_eAttributeType = ((ELAttribute)structural_feature).getEAttributeType()) instanceof ELEnum) {
                            String attribute_type_name = ((ELAttribute)structural_feature).getEAttributeType().getName();
                            ELPackage enumsPackage = ((ELAttribute)structural_feature).getEAttributeType().getEPackage();
                            if (processedELPackages.indexOf((Object)enumsPackage) == -1 && enumsPackage != null && !Objects.equal((Object)enumsPackage.getName(), (Object)"types") && !Objects.equal((Object)enumsPackage, (Object)elpackage)) {
                                processedELPackages.add((Object)enumsPackage);
                                dependantEcorePackages.add((Object)this.processPackage(enumsPackage, fsa));
                            }
                            EAnnotation annotation_1 = EcoreFactory.eINSTANCE.createEAnnotation();
                            annotation_1.setSource("temp");
                            annotation_1.getDetails().put((Object)"attribute_type_name", (Object)attribute_type_name);
                            e_attribute.getEAnnotations().add((Object)annotation_1);
                        } else {
                            boolean _equals = Objects.equal((Object)type_name, (Object)"double");
                            if (_equals) {
                                e_attribute.setEType((EClassifier)EcorePackage.Literals.EDOUBLE);
                            } else {
                                boolean _equals_1 = Objects.equal((Object)type_name, (Object)"String");
                                if (_equals_1) {
                                    e_attribute.setEType((EClassifier)EcorePackage.Literals.ESTRING);
                                } else {
                                    boolean _equals_2 = Objects.equal((Object)type_name, (Object)"String");
                                    if (_equals_2) {
                                        e_attribute.setEType((EClassifier)EcorePackage.Literals.ESTRING);
                                    } else {
                                        boolean _equals_3 = Objects.equal((Object)type_name, (Object)"int");
                                        if (_equals_3) {
                                            e_attribute.setEType((EClassifier)EcorePackage.Literals.EINT);
                                        } else {
                                            boolean _equals_4 = Objects.equal((Object)type_name, (Object)"Date");
                                            if (_equals_4) {
                                                e_attribute.setEType((EClassifier)EcorePackage.Literals.EDATE);
                                            } else {
                                                boolean _equals_5 = Objects.equal((Object)type_name, (Object)"boolean");
                                                if (_equals_5) {
                                                    e_attribute.setEType((EClassifier)EcorePackage.Literals.EBOOLEAN);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        EList _eAnnotations_2 = ((ELAttribute)structural_feature).getEAnnotations();
                        for (ELAnnotation anno_2 : _eAnnotations_2) {
                            EAnnotation annotation_copy = EcoreFactory.eINSTANCE.createEAnnotation();
                            annotation_copy.setSource(anno_2.getSource().getSourceURI());
                            EList _details = anno_2.getDetails();
                            for (ELStringToStringMapEntry item : _details) {
                                annotation_copy.getDetails().put((Object)item.getKey(), (Object)item.getValue());
                            }
                            e_attribute.getEAnnotations().add((Object)annotation_copy);
                        }
                    }
                    if (!(structural_feature instanceof ELReference)) continue;
                    Iterator e_reference = EcoreFactory.eINSTANCE.createEReference();
                    e_reference.setName(((ELReference)structural_feature).getName());
                    int _upperBound_1 = ((ELReference)structural_feature).getUpperBound();
                    boolean bl3 = _notEquals_1 = _upperBound_1 != 0;
                    if (_notEquals_1) {
                        e_reference.setUpperBound(((ELReference)structural_feature).getUpperBound());
                    } else {
                        e_reference.setUpperBound(1);
                    }
                    e_reference.setLowerBound(((ELReference)structural_feature).getLowerBound());
                    e_reference.setContainment(((ELReference)structural_feature).isContainment());
                    e_class.getEStructuralFeatures().add((Object)e_reference);
                    String type_name_1 = ((ELReference)structural_feature).getEType().getName();
                    ELPackage referenceTypePackage = ((ELReference)structural_feature).getEType().getEPackage();
                    if (processedELPackages.indexOf((Object)referenceTypePackage) == -1 && referenceTypePackage != null && !Objects.equal((Object)referenceTypePackage.getName(), (Object)"types") && !Objects.equal((Object)referenceTypePackage, (Object)elpackage)) {
                        processedELPackages.add((Object)referenceTypePackage);
                        dependantEcorePackages.add((Object)this.processPackage(referenceTypePackage, fsa));
                    }
                    EAnnotation annotation_2 = EcoreFactory.eINSTANCE.createEAnnotation();
                    annotation_2.setSource("temp");
                    annotation_2.getDetails().put((Object)"type", (Object)type_name_1);
                    e_reference.getEAnnotations().add((Object)annotation_2);
                    EList _eAnnotations_3 = ((ELReference)structural_feature).getEAnnotations();
                    for (ELAnnotation anno_3 : _eAnnotations_3) {
                        EAnnotation annotation_copy = EcoreFactory.eINSTANCE.createEAnnotation();
                        annotation_copy.setSource(anno_3.getSource().getSourceURI());
                        EList _details = anno_3.getDetails();
                        for (ELStringToStringMapEntry item : _details) {
                            annotation_copy.getDetails().put((Object)item.getKey(), (Object)item.getValue());
                        }
                        e_reference.getEAnnotations().add((Object)annotation_copy);
                    }
                }
                _eOperations = ((ELClass)classifier).getEOperations();
                for (EOperation operation : _eOperations) {
                    boolean _notEquals;
                    EOperation e_operation = EcoreFactory.eINSTANCE.createEOperation();
                    e_operation.setName(operation.getName());
                    int _upperBound = operation.getUpperBound();
                    boolean bl4 = _notEquals = _upperBound != 0;
                    if (_notEquals) {
                        e_operation.setUpperBound(operation.getUpperBound());
                    } else {
                        e_operation.setUpperBound(1);
                    }
                    e_class.getEOperations().add((Object)e_operation);
                    String type_name = operation.getEType().getName();
                    EAnnotation annotation_1 = EcoreFactory.eINSTANCE.createEAnnotation();
                    annotation_1.setSource("temp");
                    annotation_1.getDetails().put((Object)"type_name", (Object)type_name);
                    ELPackage types_package = operation.getEType().getEPackage();
                    if (processedELPackages.indexOf((Object)types_package) == -1 && types_package != null && !Objects.equal((Object)types_package.getName(), (Object)"types") && !Objects.equal((Object)types_package, (Object)elpackage)) {
                        processedELPackages.add((Object)types_package);
                        dependantEcorePackages.add((Object)this.processPackage(types_package, fsa));
                    }
                    e_operation.getEAnnotations().add((Object)annotation_1);
                    EList _eAnnotations_2 = operation.getEAnnotations();
                    for (ELAnnotation anno_2 : _eAnnotations_2) {
                        EAnnotation annotation_copy = EcoreFactory.eINSTANCE.createEAnnotation();
                        annotation_copy.setSource(anno_2.getSource().getSourceURI());
                        EList _details = anno_2.getDetails();
                        for (ELStringToStringMapEntry item : _details) {
                            annotation_copy.getDetails().put((Object)item.getKey(), (Object)item.getValue());
                        }
                        e_operation.getEAnnotations().add((Object)annotation_copy);
                    }
                }
                ecore_package.getEClassifiers().add((Object)e_class);
            }
            EList _eClassifiers_1 = ecore_package.getEClassifiers();
            for (EClassifier classifier_1 : _eClassifiers_1) {
                boolean _greaterThan;
                if (!(classifier_1 instanceof EClass)) continue;
                int _size = ((EClass)classifier_1).getEAnnotations().size();
                boolean bl = _greaterThan = _size > 0;
                if (_greaterThan) {
                    EAnnotation firstAnnotation = (EAnnotation)((EClass)classifier_1).getEAnnotations().get(0);
                    EMap details = firstAnnotation.getDetails();
                    String superTypeName = (String)details.get((Object)"superTypeName");
                    ((EClass)classifier_1).getESuperTypes().add((Object)this.findClass(ecore_package, (BasicEList<EPackage>)dependantEcorePackages, superTypeName));
                    ((EClass)classifier_1).getEAnnotations().remove(0);
                }
                _eStructuralFeatures = ((EClass)classifier_1).getEStructuralFeatures();
                for (EStructuralFeature structural_feature : _eStructuralFeatures) {
                    boolean _greaterThan_2;
                    if (structural_feature instanceof EAttribute) {
                        EAnnotation firstAttributeAnnotation;
                        EMap attributeDetails;
                        String attribute_type_name;
                        boolean _greaterThan_1;
                        int _size_1 = ((EAttribute)structural_feature).getEAnnotations().size();
                        boolean bl5 = _greaterThan_1 = _size_1 > 0;
                        if (_greaterThan_1 && (attribute_type_name = (String)(attributeDetails = (firstAttributeAnnotation = (EAnnotation)((EAttribute)structural_feature).getEAnnotations().get(0)).getDetails()).get((Object)"attribute_type_name")) != null) {
                            EEnum e_type = this.findEnum(ecore_package, (BasicEList<EPackage>)dependantEcorePackages, attribute_type_name);
                            ((EAttribute)structural_feature).setEType((EClassifier)e_type);
                            ((EAttribute)structural_feature).getEAnnotations().remove(0);
                        }
                    }
                    if (!(structural_feature instanceof EReference)) continue;
                    int _size_2 = ((EReference)structural_feature).getEAnnotations().size();
                    boolean bl6 = _greaterThan_2 = _size_2 > 0;
                    if (!_greaterThan_2) continue;
                    EAnnotation firstAttributeAnnotation_1 = (EAnnotation)((EReference)structural_feature).getEAnnotations().get(0);
                    EMap attributeDetails_1 = firstAttributeAnnotation_1.getDetails();
                    String reference_type_name = (String)attributeDetails_1.get((Object)"type");
                    ((EReference)structural_feature).setEType((EClassifier)this.findClass(ecore_package, (BasicEList<EPackage>)dependantEcorePackages, reference_type_name));
                    ((EReference)structural_feature).getEAnnotations().remove(0);
                }
                _eOperations = ((EClass)classifier_1).getEOperations();
                for (EOperation operation : _eOperations) {
                    EAnnotation firstOperationAnnotation = (EAnnotation)operation.getEAnnotations().get(0);
                    EMap attributeDetails = firstOperationAnnotation.getDetails();
                    String operationTypeName = (String)attributeDetails.get((Object)"type_name");
                    EClass operationTypesClass = this.findClass(ecore_package, (BasicEList<EPackage>)dependantEcorePackages, operationTypeName);
                    if (operationTypesClass != null) {
                        operation.setEType((EClassifier)operationTypesClass);
                    } else {
                        boolean _equals = Objects.equal((Object)operationTypeName, (Object)"double");
                        if (_equals) {
                            operation.setEType((EClassifier)EcorePackage.Literals.EDOUBLE);
                        } else {
                            boolean _equals_1 = Objects.equal((Object)operationTypeName, (Object)"String");
                            if (_equals_1) {
                                operation.setEType((EClassifier)EcorePackage.Literals.ESTRING);
                            } else {
                                boolean _equals_2 = Objects.equal((Object)operationTypeName, (Object)"String");
                                if (_equals_2) {
                                    operation.setEType((EClassifier)EcorePackage.Literals.ESTRING);
                                } else {
                                    boolean _equals_3 = Objects.equal((Object)operationTypeName, (Object)"int");
                                    if (_equals_3) {
                                        operation.setEType((EClassifier)EcorePackage.Literals.EINT);
                                    } else {
                                        boolean _equals_4 = Objects.equal((Object)operationTypeName, (Object)"Date");
                                        if (_equals_4) {
                                            operation.setEType((EClassifier)EcorePackage.Literals.EDATE);
                                        } else {
                                            boolean _equals_5 = Objects.equal((Object)operationTypeName, (Object)"boolean");
                                            if (_equals_5) {
                                                operation.setEType((EClassifier)EcorePackage.Literals.EBOOLEAN);
                                            } else {
                                                EEnum eEnum = this.findEnum(ecore_package, (BasicEList<EPackage>)dependantEcorePackages, operationTypeName);
                                                operation.setEType((EClassifier)eEnum);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    operation.getEAnnotations().remove(0);
                    EList _eParameters = operation.getEParameters();
                    for (EParameter param : _eParameters) {
                        EAnnotation firstParamAnnotation = (EAnnotation)param.getEAnnotations().get(0);
                        EMap paramAttributeDetails = firstParamAnnotation.getDetails();
                        String paramTypeName = (String)paramAttributeDetails.get((Object)"type_name");
                        EClass paramTypesClass = this.findClass(ecore_package, (BasicEList<EPackage>)dependantEcorePackages, paramTypeName);
                        if (paramTypesClass != null) {
                            param.setEType((EClassifier)paramTypesClass);
                            continue;
                        }
                        boolean _equals_6 = Objects.equal((Object)paramTypeName, (Object)"double");
                        if (_equals_6) {
                            param.setEType((EClassifier)EcorePackage.Literals.EDOUBLE);
                            continue;
                        }
                        boolean _equals_7 = Objects.equal((Object)paramTypeName, (Object)"String");
                        if (_equals_7) {
                            param.setEType((EClassifier)EcorePackage.Literals.ESTRING);
                            continue;
                        }
                        boolean _equals_8 = Objects.equal((Object)paramTypeName, (Object)"String");
                        if (_equals_8) {
                            param.setEType((EClassifier)EcorePackage.Literals.ESTRING);
                            continue;
                        }
                        boolean _equals_9 = Objects.equal((Object)paramTypeName, (Object)"int");
                        if (_equals_9) {
                            param.setEType((EClassifier)EcorePackage.Literals.EINT);
                            continue;
                        }
                        boolean _equals_10 = Objects.equal((Object)paramTypeName, (Object)"Date");
                        if (_equals_10) {
                            param.setEType((EClassifier)EcorePackage.Literals.EDATE);
                            continue;
                        }
                        boolean _equals_11 = Objects.equal((Object)paramTypeName, (Object)"boolean");
                        if (_equals_11) {
                            param.setEType((EClassifier)EcorePackage.Literals.EBOOLEAN);
                            continue;
                        }
                        EEnum eEnum_1 = this.findEnum(ecore_package, (BasicEList<EPackage>)dependantEcorePackages, paramTypeName);
                        param.setEType((EClassifier)eEnum_1);
                        param.getEAnnotations().remove(0);
                    }
                }
            }
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            if (dependantEcorePackages != null) {
                for (EPackage dependantEcorePackage : dependantEcorePackages) {
                    String _name = dependantEcorePackage.getName();
                    String _plus_1 = String.valueOf(_name) + ".ecore";
                    Resource dependentEcoreResource = resourceSet.createResource(URI.createFileURI((String)_plus_1));
                    dependentEcoreResource.getContents().add((Object)dependantEcorePackage);
                    dependentEcoreResource.save(null);
                }
            }
            String _name = ecore_package.getName();
            String _plus_1 = String.valueOf(_name) + ".ecore";
            Resource ecoreResource = resourceSet.createResource(URI.createFileURI((String)_plus_1));
            ecoreResource.getContents().add((Object)ecore_package);
            ecoreResource.save(null);
            String _name_1 = ecore_package.getName();
            String _plus_2 = String.valueOf(_name_1) + ".ecore";
            Path filePath = Path.of(_plus_2, new String[0]);
            String content = Files.readString(filePath);
            String _name_2 = ecore_package.getName();
            String _plus_3 = String.valueOf(_name_2) + ".ecore";
            fsa.generateFile(_plus_3, (CharSequence)content);
            return ecore_package;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public String findXCoreSubstring(String string) {
        int startIndex = string.indexOf("<xcore>");
        int endIndex = string.indexOf("</xcore>");
        String returnString = string;
        if (endIndex > 0 && startIndex > -1) {
            returnString = string.substring(startIndex + 7, endIndex);
        }
        return returnString;
    }

    public EEnum findEnum(EPackage thePackage, BasicEList<EPackage> dependantPackages, String enumName) {
        EEnum returnEnum = null;
        EList _eClassifiers = thePackage.getEClassifiers();
        for (EClassifier classifier : _eClassifiers) {
            String _name;
            boolean _equals;
            if (!(classifier instanceof EEnum) || !(_equals = Objects.equal((Object)(_name = ((EEnum)classifier).getName()), (Object)enumName))) continue;
            returnEnum = (EEnum)classifier;
        }
        if (returnEnum == null) {
            for (EPackage dependantPackage : dependantPackages) {
                if (dependantPackage == null) continue;
                EList _eClassifiers_1 = dependantPackage.getEClassifiers();
                for (EClassifier classifier_1 : _eClassifiers_1) {
                    String _name_1;
                    boolean _equals_1;
                    if (!(classifier_1 instanceof EEnum) || !(_equals_1 = Objects.equal((Object)(_name_1 = ((EEnum)classifier_1).getName()), (Object)enumName))) continue;
                    returnEnum = (EEnum)classifier_1;
                }
            }
        }
        return returnEnum;
    }

    public EClass findClass(EPackage thePackage, BasicEList<EPackage> dependantPackages, String className) {
        EClass returnClass = null;
        EList _eClassifiers = thePackage.getEClassifiers();
        for (EClassifier classifier : _eClassifiers) {
            String _name;
            boolean _equals;
            if (!(classifier instanceof EClass) || !(_equals = Objects.equal((Object)(_name = ((EClass)classifier).getName()), (Object)className))) continue;
            returnClass = (EClass)classifier;
        }
        if (returnClass == null) {
            for (EPackage dependantPackage : dependantPackages) {
                if (dependantPackage == null) continue;
                EList _eClassifiers_1 = dependantPackage.getEClassifiers();
                for (EClassifier classifier_1 : _eClassifiers_1) {
                    String _name_1;
                    boolean _equals_1;
                    if (!(classifier_1 instanceof EClass) || !(_equals_1 = Objects.equal((Object)(_name_1 = ((EClass)classifier_1).getName()), (Object)className))) continue;
                    returnClass = (EClass)classifier_1;
                }
            }
        }
        return returnClass;
    }
}

