/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.sourcelookup;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.InstructionPointerManager;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupResult;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.launch.DecorationManager;
import org.eclipse.debug.internal.ui.views.launch.SourceNotFoundEditorInput;
import org.eclipse.debug.internal.ui.views.launch.StandardDecoration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugEditorPresentation;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IInstructionPointerPresentation;
import org.eclipse.debug.ui.ISourcePresentation;
import org.eclipse.debug.ui.sourcelookup.CommonSourceNotFoundEditorInput;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class SourceLookupFacility
implements IPageListener,
IPartListener2,
IPropertyChangeListener,
IDebugEventSetListener {
    private static SourceLookupFacility fgDefault;
    private final Map<IWorkbenchPage, IEditorPart> fEditorsByPage;
    private final Map<Object, SourceLookupResult> fLookupResults = Collections.synchronizedMap(new LRU(10));
    private final IInstructionPointerPresentation fPresentation = (IInstructionPointerPresentation)DebugUITools.newDebugModelPresentation();
    private boolean fReuseEditor = DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.reuse_editor");
    private final SourceLookupJob sourceLookupJob;

    public static SourceLookupFacility getDefault() {
        if (fgDefault == null) {
            fgDefault = new SourceLookupFacility();
        }
        return fgDefault;
    }

    public static void shutdown() {
        if (fgDefault != null) {
            fgDefault.dispose();
        }
    }

    private SourceLookupFacility() {
        this.fEditorsByPage = new HashMap<IWorkbenchPage, IEditorPart>();
        this.sourceLookupJob = new SourceLookupJob();
        DebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        IStackFrame frame = null;
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            final DebugEvent event = debugEventArray[n2];
            switch (event.getKind()) {
                case 1: 
                case 8: {
                    if (event.isEvaluation()) break;
                    UIJob uijob = new UIJob("clear source selection"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            SourceLookupFacility.this.clearSourceSelection(event.getSource());
                            return Status.OK_STATUS;
                        }
                    };
                    uijob.setSystem(true);
                    uijob.schedule();
                    break;
                }
                case 16: {
                    if (!(event.getSource() instanceof IStackFrame) || event.getDetail() != 512) break;
                    frame = (IStackFrame)event.getSource();
                    this.fLookupResults.remove(new ArtifactWithLocator(frame, frame.getLaunch().getSourceLocator()));
                    break;
                }
            }
            ++n2;
        }
    }

    public SourceLookupResult lookup(Object artifact, ISourceLocator locator, boolean force) {
        ISourceLocator localLocator;
        SourceLookupResult result = null;
        ArtifactWithLocator key = new ArtifactWithLocator(artifact, locator);
        if (!force && (result = this.fLookupResults.get(key)) != null) {
            return result;
        }
        IDebugElement debugElement = null;
        if (artifact instanceof IDebugElement) {
            debugElement = (IDebugElement)artifact;
        }
        if ((localLocator = locator) == null) {
            ILaunch launch = null;
            if (debugElement != null) {
                launch = debugElement.getLaunch();
            }
            if (launch != null) {
                localLocator = launch.getSourceLocator();
            }
        }
        if (localLocator == null) {
            return new SourceLookupResult(artifact, null, null, null);
        }
        String editorId = null;
        PlatformObject editorInput = null;
        Object sourceElement = null;
        if (localLocator instanceof ISourceLookupDirector) {
            ISourceLookupDirector director = (ISourceLookupDirector)localLocator;
            sourceElement = director.getSourceElement(artifact);
        } else if (artifact instanceof IStackFrame) {
            sourceElement = localLocator.getSourceElement((IStackFrame)artifact);
        }
        if (sourceElement == null) {
            if (localLocator instanceof AbstractSourceLookupDirector) {
                editorInput = new CommonSourceNotFoundEditorInput(artifact);
                editorId = "org.eclipse.debug.ui.sourcelookup.CommonSourceNotFoundEditor";
            } else if (artifact instanceof IStackFrame) {
                IStackFrame frame = (IStackFrame)artifact;
                editorInput = new SourceNotFoundEditorInput(frame);
                editorId = "org.eclipse.debug.ui.NoSourceFoundEditor";
            }
        } else {
            ISourcePresentation presentation = null;
            if (localLocator instanceof ISourcePresentation) {
                presentation = (ISourcePresentation)localLocator;
            } else if (debugElement != null) {
                presentation = this.getPresentation(debugElement.getModelIdentifier());
            }
            if (presentation != null) {
                editorInput = presentation.getEditorInput(sourceElement);
            }
            if (editorInput != null && presentation != null) {
                editorId = presentation.getEditorId((IEditorInput)editorInput, sourceElement);
            }
        }
        result = new SourceLookupResult(artifact, sourceElement, editorId, (IEditorInput)editorInput);
        this.fLookupResults.put(key, result);
        return result;
    }

    protected IDebugModelPresentation getPresentation(String id) {
        return ((DelegatingModelPresentation)DebugUIPlugin.getModelPresentation()).getPresentation(id);
    }

    protected IDebugEditorPresentation getEditorPresentation() {
        return (DelegatingModelPresentation)DebugUIPlugin.getModelPresentation();
    }

    public void display(ISourceLookupResult result, IWorkbenchPage page) {
        IEditorPart editor = this.openEditor(result, page);
        if (editor == null) {
            return;
        }
        IStackFrame frame = null;
        if (result.getArtifact() instanceof IStackFrame) {
            frame = (IStackFrame)result.getArtifact();
        }
        if (frame != null) {
            IDebugEditorPresentation editorPresentation = this.getEditorPresentation();
            if (editorPresentation.addAnnotations(editor, frame)) {
                StandardDecoration decoration = new StandardDecoration(editorPresentation, editor, frame.getThread());
                DecorationManager.addDecoration(decoration);
            } else {
                ITextEditor textEditor = null;
                textEditor = editor instanceof ITextEditor ? (ITextEditor)editor : (ITextEditor)editor.getAdapter(ITextEditor.class);
                if (textEditor != null) {
                    this.positionEditor(textEditor, frame);
                    InstructionPointerManager.getDefault().removeAnnotations(textEditor);
                    Annotation annotation = this.fPresentation.getInstructionPointerAnnotation((IEditorPart)textEditor, frame);
                    if (annotation != null) {
                        InstructionPointerManager.getDefault().addAnnotation(textEditor, frame, annotation);
                    }
                }
            }
        }
    }

    private IEditorPart openEditor(ISourceLookupResult result, IWorkbenchPage page) {
        IEditorPart editor = null;
        IEditorInput input = result.getEditorInput();
        String id = result.getEditorId();
        if (input == null || id == null) {
            return null;
        }
        if (this.fReuseEditor) {
            IEditorReference[] references = page.findEditors(input, id, 3);
            if (references.length > 0) {
                IEditorPart refEditor;
                editor = refEditor = references[0].getEditor(false);
                page.bringToTop((IWorkbenchPart)editor);
            }
            if (editor == null) {
                IEditorPart editorForPage = this.getEditor(page);
                if (editorForPage == null || editorForPage.isDirty() || page.isEditorPinned(editorForPage)) {
                    editorForPage = editor = this.openEditor(page, input, id);
                } else if (SourceLookupFacility.canReuseEditor(input, id, editorForPage)) {
                    page.reuseEditor((IReusableEditor)editorForPage, input);
                    editor = editorForPage;
                    if (!page.isPartVisible((IWorkbenchPart)editor)) {
                        page.bringToTop((IWorkbenchPart)editor);
                    }
                } else {
                    editor = this.openEditor(page, input, id);
                    if (editor != editorForPage) {
                        page.closeEditor(editorForPage, false);
                        editorForPage = editor;
                    }
                }
                this.setEditor(page, editorForPage);
            }
        } else {
            editor = this.openEditor(page, input, id);
        }
        return editor;
    }

    private static boolean canReuseEditor(IEditorInput input, String id, IEditorPart editorForPage) {
        if (!(editorForPage instanceof IReusableEditor)) {
            return false;
        }
        IWorkbenchPartSite site = editorForPage.getSite();
        if (site == null) {
            return false;
        }
        if (site.getId().equals(id)) {
            return true;
        }
        IEditorInput editorInput = editorForPage.getEditorInput();
        return editorInput != null && input.equals(editorInput);
    }

    private void positionEditor(ITextEditor editor, IStackFrame frame) {
        try {
            IRegion region;
            int charStart = frame.getCharStart();
            if (charStart >= 0) {
                editor.selectAndReveal(charStart, 0);
                return;
            }
            int lineNumber = frame.getLineNumber();
            if ((region = this.getLineInformation(editor, --lineNumber)) != null) {
                editor.selectAndReveal(region.getOffset(), 0);
            }
        }
        catch (DebugException debugException) {}
    }

    private IRegion getLineInformation(ITextEditor editor, int lineNumber) {
        IDocumentProvider provider = editor.getDocumentProvider();
        if (provider == null) {
            return null;
        }
        IEditorInput input = editor.getEditorInput();
        try {
            provider.connect((Object)input);
        }
        catch (CoreException coreException) {
            return null;
        }
        try {
            IDocument document = provider.getDocument((Object)input);
            if (document != null) {
                IRegion iRegion = document.getLineInformation(lineNumber);
                return iRegion;
            }
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            provider.disconnect((Object)input);
        }
        return null;
    }

    private IEditorPart openEditor(IWorkbenchPage page, IEditorInput input, String id) {
        IEditorPart[] editor = new IEditorPart[1];
        Runnable r = () -> {
            if (!this.isClosing(page)) {
                try {
                    iEditorPartArray[0] = page.openEditor(input, id, false, 3);
                }
                catch (PartInitException e) {
                    DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), DebugUIViewsMessages.LaunchView_Error_1, DebugUIViewsMessages.LaunchView_Exception_occurred_opening_editor_for_debugger__2, e);
                }
            }
        };
        BusyIndicator.showWhile((Display)DebugUIPlugin.getStandardDisplay(), (Runnable)r);
        return editor[0];
    }

    private boolean isClosing(IWorkbenchPage page) {
        IWorkbenchWindow pageWindow = page.getWorkbenchWindow();
        boolean isWorkbenchClosing = pageWindow.getWorkbench().isClosing();
        if (isWorkbenchClosing) {
            return true;
        }
        boolean isWorkbenchPageWindowClosing = pageWindow.isClosing();
        return isWorkbenchPageWindowClosing;
    }

    public void pageActivated(IWorkbenchPage page) {
    }

    public void pageClosed(IWorkbenchPage page) {
        this.fEditorsByPage.remove(page);
        page.removePartListener((IPartListener2)this);
    }

    public void pageOpened(IWorkbenchPage page) {
        page.addPartListener((IPartListener2)this);
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        IWorkbenchPage page = partRef.getPage();
        IEditorPart editor = this.getEditor(page);
        IWorkbenchPart part = partRef.getPart(false);
        if (part != null && part.equals(editor)) {
            this.fEditorsByPage.remove(page);
        }
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals("org.eclipse.debug.ui.reuse_editor")) {
            this.fReuseEditor = DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.reuse_editor");
        }
    }

    protected IEditorPart getEditor(IWorkbenchPage page) {
        return this.fEditorsByPage.get(page);
    }

    protected void setEditor(IWorkbenchPage page, IEditorPart editorPart) {
        if (editorPart == null) {
            this.fEditorsByPage.remove(page);
        } else {
            this.fEditorsByPage.put(page, editorPart);
        }
        page.addPartListener((IPartListener2)this);
        page.getWorkbenchWindow().addPageListener((IPageListener)this);
    }

    protected void dispose() {
        DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        this.fEditorsByPage.clear();
        this.fPresentation.dispose();
        this.fLookupResults.clear();
        this.sourceLookupJob.cancel();
    }

    public void displaySource(Object context, IWorkbenchPage page, boolean force) {
        IStackFrame frame = (IStackFrame)context;
        SourceLookupTask slj = new SourceLookupTask(frame, frame.getLaunch().getSourceLocator(), page, force);
        this.sourceLookupJob.schedule(slj);
    }

    private void clearSourceSelection(Object source) {
        if (source instanceof IThread) {
            IThread thread = (IThread)source;
            DecorationManager.removeDecorations(thread);
            InstructionPointerManager.getDefault().removeAnnotations(thread);
        } else if (source instanceof IDebugTarget) {
            IDebugTarget target = (IDebugTarget)source;
            DecorationManager.removeDecorations(target);
            InstructionPointerManager.getDefault().removeAnnotations(target);
        }
    }

    private static class ArtifactWithLocator {
        public final Object artifact;
        public final ISourceLocator locator;

        public ArtifactWithLocator(Object artifact, ISourceLocator locator) {
            this.artifact = artifact;
            this.locator = locator;
        }

        public int hashCode() {
            return 31 + Objects.hash(this.artifact, this.locator);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ArtifactWithLocator)) {
                return false;
            }
            ArtifactWithLocator other = (ArtifactWithLocator)obj;
            return Objects.equals(this.artifact, other.artifact) && Objects.equals(this.locator, other.locator);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ArtifactWithLocator [");
            if (this.artifact != null) {
                builder.append("artifact=");
                builder.append(this.artifact);
                builder.append(", ");
            }
            if (this.locator != null) {
                builder.append("locator=");
                builder.append(this.locator);
            }
            builder.append("]");
            return builder.toString();
        }
    }

    static class LRU
    extends LinkedHashMap<Object, SourceLookupResult> {
        private static final long serialVersionUID = 1L;
        int fSize;

        LRU(int size) {
            super(size, 0.75f, true);
            this.fSize = size;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Object, SourceLookupResult> eldest) {
            return this.size() > this.fSize;
        }
    }

    class SourceDisplayJob
    extends UIJob {
        private final LinkedHashSet<SourceDisplayRequest> queue;

        public SourceDisplayJob() {
            super("Debug Source Display");
            this.setSystem(true);
            this.setPriority(10);
            this.queue = new LinkedHashSet();
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            SourceDisplayRequest next;
            while ((next = this.poll()) != null) {
                IWorkbenchPage page = next.fPage;
                if (page.getWorkbenchWindow() == null) continue;
                SourceLookupResult result = next.fResult;
                if (!monitor.isCanceled()) {
                    SourceLookupFacility.this.display(result, page);
                    continue;
                }
                Object artifact = result.getArtifact();
                if (!(artifact instanceof IStackFrame)) continue;
                SourceLookupFacility.this.clearSourceSelection(((IStackFrame)artifact).getThread());
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SourceDisplayRequest poll() {
            SourceDisplayRequest next = null;
            LinkedHashSet<SourceDisplayRequest> linkedHashSet = this.queue;
            synchronized (linkedHashSet) {
                if (!this.queue.isEmpty()) {
                    Iterator iterator = this.queue.iterator();
                    next = (SourceDisplayRequest)iterator.next();
                    iterator.remove();
                }
            }
            return next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void schedule(SourceDisplayRequest task) {
            LinkedHashSet<SourceDisplayRequest> linkedHashSet = this.queue;
            synchronized (linkedHashSet) {
                boolean added = this.queue.add(task);
                if (added) {
                    this.schedule(100L);
                }
            }
        }

        public boolean belongsTo(Object family) {
            return family instanceof SourceLookupFacility;
        }
    }

    static class SourceDisplayRequest {
        final SourceLookupResult fResult;
        final IWorkbenchPage fPage;

        public SourceDisplayRequest(SourceLookupResult result, IWorkbenchPage page) {
            this.fResult = result;
            this.fPage = page;
        }

        public int hashCode() {
            return Objects.hash(this.fPage, this.fResult);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SourceDisplayRequest)) {
                return false;
            }
            SourceDisplayRequest other = (SourceDisplayRequest)obj;
            return Objects.equals(this.fPage, other.fPage) && Objects.equals(this.fResult, other.fResult);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SourceDisplayRequest [");
            if (this.fResult != null) {
                builder.append("result=");
                builder.append(this.fResult);
                builder.append(", ");
            }
            if (this.fPage != null) {
                builder.append("page=");
                builder.append(this.fPage);
            }
            builder.append("]");
            return builder.toString();
        }
    }

    final class SourceLookupJob
    extends Job {
        private final LinkedHashSet<SourceLookupTask> queue;
        private final SourceDisplayJob sourceDisplayJob;

        public SourceLookupJob() {
            super("Debug Source Lookup");
            this.sourceDisplayJob = new SourceDisplayJob();
            this.queue = new LinkedHashSet();
            this.setSystem(true);
            this.setPriority(10);
        }

        public boolean belongsTo(Object family) {
            return family instanceof SourceLookupFacility;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            SourceLookupTask next;
            while ((next = this.poll()) != null && !monitor.isCanceled()) {
                SourceDisplayRequest uiTask = next.run(monitor);
                if (uiTask == null) continue;
                this.sourceDisplayJob.schedule(uiTask);
            }
            LinkedHashSet<SourceLookupTask> linkedHashSet = this.queue;
            synchronized (linkedHashSet) {
                if (monitor.isCanceled()) {
                    this.queue.clear();
                    return Status.CANCEL_STATUS;
                }
                if (!this.queue.isEmpty()) {
                    this.schedule(100L);
                }
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SourceLookupTask poll() {
            SourceLookupTask next = null;
            LinkedHashSet<SourceLookupTask> linkedHashSet = this.queue;
            synchronized (linkedHashSet) {
                if (!this.queue.isEmpty()) {
                    Iterator iterator = this.queue.iterator();
                    next = (SourceLookupTask)iterator.next();
                    iterator.remove();
                }
            }
            return next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void schedule(SourceLookupTask task) {
            LinkedHashSet<SourceLookupTask> linkedHashSet = this.queue;
            synchronized (linkedHashSet) {
                boolean added = this.queue.add(task);
                if (added) {
                    this.schedule(100L);
                }
            }
        }
    }

    class SourceLookupTask {
        final IStackFrame fTarget;
        final ISourceLocator fLocator;
        final IWorkbenchPage fPage;
        final boolean fForce;

        public SourceLookupTask(IStackFrame frame, ISourceLocator locator, IWorkbenchPage page, boolean force) {
            this.fTarget = frame;
            this.fLocator = locator;
            this.fPage = page;
            this.fForce = force;
        }

        protected SourceDisplayRequest run(IProgressMonitor monitor) {
            if (!monitor.isCanceled() && !this.fTarget.isTerminated()) {
                SourceLookupResult result = SourceLookupFacility.this.lookup(this.fTarget, this.fLocator, this.fForce);
                if (!monitor.isCanceled() && !this.fTarget.isTerminated() && this.fPage != null && result != null) {
                    return new SourceDisplayRequest(result, this.fPage);
                }
            }
            return null;
        }

        public int hashCode() {
            return 31 + Objects.hash(this.fForce, this.fLocator, this.fPage, this.fTarget);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SourceLookupTask)) {
                return false;
            }
            SourceLookupTask other = (SourceLookupTask)obj;
            return this.fForce == other.fForce && Objects.equals(this.fPage, other.fPage) && Objects.equals(this.fLocator, other.fLocator) && Objects.equals(this.fTarget, other.fTarget);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SourceLookupTask [");
            if (this.fTarget != null) {
                builder.append("target=");
                builder.append(this.fTarget);
                builder.append(", ");
            }
            builder.append("force=");
            builder.append(this.fForce);
            builder.append(", ");
            if (this.fLocator != null) {
                builder.append("locator=");
                builder.append(this.fLocator);
                builder.append(", ");
            }
            if (this.fPage != null) {
                builder.append("page=");
                builder.append(this.fPage);
            }
            builder.append("]");
            return builder.toString();
        }
    }
}

