/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.datatransfer;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.datatransfer.BuildFileCreator;
import org.eclipse.ant.internal.ui.datatransfer.DataTransferMessages;
import org.eclipse.ant.internal.ui.datatransfer.ExportUtil;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class AntBuildfileExportPage
extends WizardPage {
    private CheckboxTableViewer fTableViewer;
    private final List<IJavaProject> fSelectedJavaProjects = new ArrayList<IJavaProject>();
    private Button compatibilityCheckbox;
    private Button compilerCheckbox;
    private Text buildfilenameText;
    private Text junitdirText;

    public AntBuildfileExportPage() {
        super("AntBuildfileExportWizardPage");
        this.setPageComplete(false);
        this.setTitle(DataTransferMessages.AntBuildfileExportPage_0);
        this.setDescription(DataTransferMessages.AntBuildfileExportPage_1);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        Label titel = new Label(workArea, 0);
        titel.setText(DataTransferMessages.AntBuildfileExportPage_2);
        Composite listComposite = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        listComposite.setLayout((Layout)layout);
        listComposite.setLayoutData((Object)new GridData(1808));
        Table table = new Table(listComposite, 2848);
        this.fTableViewer = new CheckboxTableViewer(table);
        table.setLayout((Layout)new TableLayout());
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 300;
        table.setLayoutData((Object)data);
        this.fTableViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider(){

            public Object[] getElements(Object element) {
                if (element instanceof IJavaProject[]) {
                    return (IJavaProject[])element;
                }
                return null;
            }
        });
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.fTableViewer.addCheckStateListener(event -> {
            if (event.getChecked()) {
                this.fSelectedJavaProjects.add((IJavaProject)event.getElement());
            } else {
                this.fSelectedJavaProjects.remove(event.getElement());
            }
            this.updateEnablement();
        });
        this.initializeProjects();
        this.createSelectionButtons(listComposite);
        this.createCheckboxes(workArea);
        this.createTextFields(workArea);
        this.setControl((Control)workArea);
        this.updateEnablement();
        Dialog.applyDialogFont((Control)parent);
    }

    private void createSelectionButtons(Composite composite) {
        Composite buttonsComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)layout);
        buttonsComposite.setLayoutData((Object)new GridData(2));
        Button selectAll = new Button(buttonsComposite, 8);
        selectAll.setText(DataTransferMessages.AntBuildfileExportPage_11);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < AntBuildfileExportPage.this.fTableViewer.getTable().getItemCount()) {
                    AntBuildfileExportPage.this.fSelectedJavaProjects.add((IJavaProject)AntBuildfileExportPage.this.fTableViewer.getElementAt(i));
                    ++i;
                }
                AntBuildfileExportPage.this.fTableViewer.setAllChecked(true);
                AntBuildfileExportPage.this.updateEnablement();
            }
        });
        this.setButtonLayoutData(selectAll);
        Button deselectAll = new Button(buttonsComposite, 8);
        deselectAll.setText(DataTransferMessages.AntBuildfileExportPage_12);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AntBuildfileExportPage.this.fSelectedJavaProjects.clear();
                AntBuildfileExportPage.this.fTableViewer.setAllChecked(false);
                AntBuildfileExportPage.this.updateEnablement();
            }
        });
        this.setButtonLayoutData(deselectAll);
    }

    private void createCheckboxes(Composite composite) {
        this.compatibilityCheckbox = new Button(composite, 32);
        this.compatibilityCheckbox.setSelection(true);
        this.compatibilityCheckbox.setText(DataTransferMessages.AntBuildfileExportPage_13);
        this.compatibilityCheckbox.setToolTipText(DataTransferMessages.AntBuildfileExportPage_14);
        this.compilerCheckbox = new Button(composite, 32);
        this.compilerCheckbox.setSelection(true);
        this.compilerCheckbox.setText(DataTransferMessages.AntBuildfileExportPage_15);
    }

    private void createTextFields(Composite composite) {
        Composite containerGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        containerGroup.setLayout((Layout)layout);
        containerGroup.setLayoutData((Object)new GridData(768));
        Label buildfilenameLabel = new Label(containerGroup, 0);
        buildfilenameLabel.setText(DataTransferMessages.AntBuildfileExportPage_16);
        this.buildfilenameText = new Text(containerGroup, 2052);
        this.buildfilenameText.setText("build.xml");
        GridData data = new GridData(768);
        this.buildfilenameText.setLayoutData((Object)data);
        Label junitdirLabel = new Label(containerGroup, 0);
        junitdirLabel.setText(DataTransferMessages.AntBuildfileExportPage_17);
        this.junitdirText = new Text(containerGroup, 2052);
        this.junitdirText.setText("junit");
        this.junitdirText.setLayoutData((Object)data);
        ModifyListener listener = e -> this.updateEnablement();
        this.buildfilenameText.addModifyListener(listener);
        this.junitdirText.addModifyListener(listener);
    }

    private void initializeProjects() {
        IJavaProject[] javaProjects;
        IWorkspaceRoot rootWorkspace = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)rootWorkspace);
        try {
            javaProjects = javaModel.getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            javaProjects = new IJavaProject[]{};
        }
        this.fTableViewer.setInput((Object)javaProjects);
        if (this.fSelectedJavaProjects != null) {
            this.fTableViewer.setCheckedElements((Object[])this.fSelectedJavaProjects.toArray(new IJavaProject[this.fSelectedJavaProjects.size()]));
        }
    }

    private void updateEnablement() {
        boolean complete = true;
        if (this.fSelectedJavaProjects.isEmpty()) {
            this.setErrorMessage(DataTransferMessages.AntBuildfileExportPage_18);
            complete = false;
        }
        try {
            ArrayList<String> projectsWithErrors = new ArrayList<String>();
            ArrayList<String> projectsWithWarnings = new ArrayList<String>();
            this.findCyclicProjects(this.getProjects(false), projectsWithErrors, projectsWithWarnings);
            if (projectsWithErrors.size() > 0) {
                String message = DataTransferMessages.AntBuildfileExportPage_cycle_error_in_projects;
                if (projectsWithErrors.size() == 1) {
                    message = DataTransferMessages.AntBuildfileExportPage_cycle_error_in_project;
                }
                this.setErrorMessage(MessageFormat.format(message, ExportUtil.toString(projectsWithErrors, ", ")));
                complete = false;
            } else if (projectsWithWarnings.size() > 0) {
                String message = DataTransferMessages.AntBuildfileExportPage_cycle_warning_in_projects;
                if (projectsWithWarnings.size() == 1) {
                    message = DataTransferMessages.AntBuildfileExportPage_cycle_warning_in_project;
                }
                this.setMessage(MessageFormat.format(message, ExportUtil.toString(projectsWithWarnings, ", ")), 2);
            } else {
                this.setMessage(null);
            }
        }
        catch (CoreException coreException) {}
        if (this.buildfilenameText.getText().length() == 0) {
            this.setErrorMessage(DataTransferMessages.AntBuildfileExportPage_19);
            complete = false;
        }
        if (this.junitdirText.getText().length() == 0) {
            this.setErrorMessage(DataTransferMessages.AntBuildfileExportPage_20);
            complete = false;
        }
        if (complete) {
            this.setErrorMessage(null);
        }
        this.setPageComplete(complete);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fTableViewer.getTable().setFocus();
        }
    }

    protected void setSelectedProjects(List<IJavaProject> selectedJavaProjects) {
        this.fSelectedJavaProjects.addAll(selectedJavaProjects);
    }

    public boolean generateBuildfiles() {
        Set<IJavaProject> projects;
        this.setErrorMessage(null);
        ArrayList projectNames = new ArrayList();
        try {
            projects = this.getProjects(true);
            if (projects.isEmpty()) {
                return false;
            }
        }
        catch (JavaModelException e) {
            AntUIPlugin.log(e);
            this.setErrorMessage(MessageFormat.format(DataTransferMessages.AntBuildfileExportPage_10, e.toString()));
            return false;
        }
        IRunnableWithProgress runnable = pm -> {
            SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)pm, (String)DataTransferMessages.AntBuildfileExportPage_creating_build_files, (int)projects.size());
            Throwable problem = null;
            try {
                BuildFileCreator.setOptions(this.buildfilenameText.getText(), this.junitdirText.getText(), this.compatibilityCheckbox.getSelection(), this.compilerCheckbox.getSelection());
                projectNames.addAll(BuildFileCreator.createBuildFiles(projects, this.getShell(), (IProgressMonitor)localmonitor.newChild(projects.size())));
            }
            catch (JavaModelException e1) {
                problem = e1;
            }
            catch (TransformerConfigurationException e2) {
                problem = e2;
            }
            catch (ParserConfigurationException e3) {
                problem = e3;
            }
            catch (TransformerException e4) {
                problem = e4;
            }
            catch (IOException e5) {
                problem = e5;
            }
            catch (CoreException e6) {
                problem = e6;
            }
            if (problem != null) {
                AntUIPlugin.log(problem);
                this.setErrorMessage(MessageFormat.format(DataTransferMessages.AntBuildfileExportPage_10, problem.toString()));
            }
        };
        try {
            this.getContainer().run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            AntUIPlugin.log(e);
            return false;
        }
        catch (InterruptedException e) {
            AntUIPlugin.log(e);
            return false;
        }
        return this.getErrorMessage() == null;
    }

    private Set<IJavaProject> getProjects(boolean displayConfirmation) throws JavaModelException {
        TreeSet<IJavaProject> projects = new TreeSet<IJavaProject>(ExportUtil.getJavaProjectComparator());
        for (IJavaProject javaProject : this.fSelectedJavaProjects) {
            projects.addAll(ExportUtil.getClasspathProjectsRecursive(javaProject));
            projects.add(javaProject);
        }
        List<String> confirmOverwrite = this.getConfirmOverwriteSet(projects);
        if (displayConfirmation && confirmOverwrite.size() > 0) {
            String message = DataTransferMessages.AntBuildfileExportPage_3 + ExportUtil.NEWLINE + ExportUtil.toString(confirmOverwrite, ExportUtil.NEWLINE);
            if (!MessageDialog.openQuestion((Shell)this.getShell(), (String)DataTransferMessages.AntBuildfileExportPage_4, (String)message)) {
                return new TreeSet<IJavaProject>(ExportUtil.getJavaProjectComparator());
            }
        }
        return projects;
    }

    private void findCyclicProjects(Set<IJavaProject> projects, List<String> errors, List<String> warnings) throws CoreException {
        for (IJavaProject javaProject : projects) {
            Integer severityAttr;
            IMarker marker = ExportUtil.getCyclicDependencyMarker(javaProject);
            if (marker == null || (severityAttr = (Integer)marker.getAttribute("severity")) == null) continue;
            switch (severityAttr) {
                case 2: {
                    errors.add(javaProject.getProject().getName());
                    break;
                }
                case 1: {
                    warnings.add(javaProject.getProject().getName());
                    break;
                }
            }
        }
    }

    private List<String> getConfirmOverwriteSet(Set<IJavaProject> javaProjects) {
        ArrayList<String> result = new ArrayList<String>(javaProjects.size());
        for (IJavaProject project : javaProjects) {
            String projectRoot = ExportUtil.getProjectRoot(project);
            if (!ExportUtil.existsUserFile(projectRoot + this.buildfilenameText.getText())) continue;
            result.add(project.getProject().getName());
        }
        return result;
    }
}

