/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.jaxrs21.ee.client.executor;

import ee.jakarta.tck.ws.rs.ee.rs.core.request.JAXRSClientIT;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.core.Response;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public interface ExecutorServiceChecker
extends Closeable {
    public static final String THREADPREFIX = "JAXRS_TCK_THREAD";
    public static final ThreadFactory THREAD_FACTORY = new ThreadFactory(){
        AtomicInteger ai = new AtomicInteger();

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, ExecutorServiceChecker.THREADPREFIX + this.ai.incrementAndGet());
        }
    };
    public static final ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(5, THREAD_FACTORY);

    default public Client createClient() {
        Client c = ClientBuilder.newBuilder().executorService(EXECUTOR_SERVICE).build();
        c.register((Object)this.threadNameChecker());
        return c;
    }

    default public ClientRequestFilter threadNameChecker() {
        return new ClientRequestFilter(){

            public void filter(ClientRequestContext requestContext) throws IOException {
                Thread t = Thread.currentThread();
                if (!t.getName().startsWith(ExecutorServiceChecker.THREADPREFIX)) {
                    requestContext.abortWith(Response.notAcceptable(null).entity((Object)"ThreadExecutor check failed").build());
                }
                JAXRSClientIT.logMsg("[Client EXECUTOR SERVICE check]: running from thread", t.getName());
            }
        };
    }

    @Override
    default public void close() throws IOException {
        EXECUTOR_SERVICE.shutdown();
    }
}

