/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.Resource;
import org.apache.felix.bundlerepository.impl.Referral;
import org.apache.felix.bundlerepository.impl.ResourceComparator;
import org.apache.felix.bundlerepository.impl.ResourceImpl;

public class RepositoryImpl
implements Repository {
    private String m_name = null;
    private long m_lastmodified = System.currentTimeMillis();
    private String m_uri = null;
    private Resource[] m_resources = null;
    private Referral[] m_referrals = null;
    private Set m_resourceSet = new HashSet();

    public RepositoryImpl() {
    }

    public RepositoryImpl(Resource[] resources) {
        this.m_resources = resources;
    }

    public String getURI() {
        return this.m_uri;
    }

    protected void setURI(String uri) {
        this.m_uri = uri;
    }

    public Resource[] getResources() {
        if (this.m_resources == null) {
            this.m_resources = this.m_resourceSet.toArray(new Resource[this.m_resourceSet.size()]);
            Arrays.sort(this.m_resources, new ResourceComparator());
        }
        return this.m_resources;
    }

    public void addResource(Resource resource) {
        if (resource instanceof ResourceImpl) {
            ((ResourceImpl)resource).setRepository(this);
        }
        this.m_resourceSet.remove(resource);
        this.m_resourceSet.add(resource);
        this.m_resources = null;
    }

    public Referral[] getReferrals() {
        return this.m_referrals;
    }

    public void addReferral(Referral referral) throws Exception {
        if (this.m_referrals == null) {
            this.m_referrals = new Referral[]{referral};
        } else {
            Referral[] newResources = new Referral[this.m_referrals.length + 1];
            System.arraycopy(this.m_referrals, 0, newResources, 0, this.m_referrals.length);
            newResources[this.m_referrals.length] = referral;
            this.m_referrals = newResources;
        }
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public long getLastModified() {
        return this.m_lastmodified;
    }

    public void setLastModified(long lastModified) {
        this.m_lastmodified = lastModified;
    }

    public void setLastModified(String s) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddhhmmss.SSS");
        try {
            this.m_lastmodified = format.parse(s).getTime();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    protected Object put(Object key, Object value) {
        return null;
    }
}

