/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.jce;

import com.jcraft.jsch.KEM;
import com.jcraft.jsch.KeyPair;
import java.security.KeyPairGenerator;
import java.security.spec.NamedParameterSpec;
import javax.crypto.KEM;

abstract class MLKEM
implements KEM {
    protected NamedParameterSpec params;
    protected byte[] algorithmIdentifier;
    protected int publicKeyLen;
    KEM.Decapsulator decapsulator;
    byte[] publicKey;

    MLKEM() {
    }

    @Override
    public void init() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("ML-KEM");
        kpg.initialize(this.params);
        java.security.KeyPair kp = kpg.generateKeyPair();
        javax.crypto.KEM kem = javax.crypto.KEM.getInstance("ML-KEM");
        this.decapsulator = kem.newDecapsulator(kp.getPrivate());
        this.publicKey = KeyPair.extractX509SubjectPublicKeyInfo(kp.getPublic().getEncoded(), this.algorithmIdentifier, this.publicKeyLen);
    }

    @Override
    public byte[] getPublicKey() throws Exception {
        return this.publicKey;
    }

    @Override
    public byte[] decapsulate(byte[] encapsulation) throws Exception {
        return this.decapsulator.decapsulate(encapsulation).getEncoded();
    }
}

