/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.asyncqueue;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.asyncqueue.AsyncQueueRecord;

public final class TaskQueue<E extends AsyncQueueRecord> {
    private volatile boolean isClosed;
    private final Queue<E> queue;
    private static final AtomicReferenceFieldUpdater<TaskQueue, AsyncQueueRecord> currentElementUpdater = AtomicReferenceFieldUpdater.newUpdater(TaskQueue.class, AsyncQueueRecord.class, "currentElement");
    private volatile E currentElement;
    private static final AtomicIntegerFieldUpdater<TaskQueue> spaceInBytesUpdater = AtomicIntegerFieldUpdater.newUpdater(TaskQueue.class, "spaceInBytes");
    private volatile int spaceInBytes;
    private final MutableMaxQueueSize maxQueueSizeHolder;
    private static final AtomicIntegerFieldUpdater<TaskQueue> writeHandlersCounterUpdater = AtomicIntegerFieldUpdater.newUpdater(TaskQueue.class, "writeHandlersCounter");
    private volatile int writeHandlersCounter;
    protected final Queue<WriteHandler> writeHandlersQueue = new ConcurrentLinkedQueue<WriteHandler>();

    protected TaskQueue(MutableMaxQueueSize maxQueueSizeHolder) {
        this.maxQueueSizeHolder = maxQueueSizeHolder;
        this.queue = new ConcurrentLinkedQueue();
    }

    public static <E extends AsyncQueueRecord> TaskQueue<E> createTaskQueue(MutableMaxQueueSize maxQueueSizeHolder) {
        return new TaskQueue<E>(maxQueueSizeHolder);
    }

    public int size() {
        return this.spaceInBytes;
    }

    public E poll() {
        AsyncQueueRecord current = currentElementUpdater.getAndSet(this, null);
        return (E)(current == null ? (AsyncQueueRecord)this.queue.poll() : current);
    }

    public E peek() {
        Object current = this.currentElement;
        if (current == null && (current = (AsyncQueueRecord)this.queue.poll()) != null) {
            this.currentElement = current;
        }
        if (current != null && this.isClosed && currentElementUpdater.compareAndSet(this, (AsyncQueueRecord)current, (AsyncQueueRecord)null)) {
            ((AsyncQueueRecord)current).notifyFailure(new IOException("Connection closed"));
            return null;
        }
        return current;
    }

    public int reserveSpace(int amount) {
        return spaceInBytesUpdater.addAndGet(this, amount);
    }

    public int releaseSpace(int amount) {
        return spaceInBytesUpdater.addAndGet(this, -amount);
    }

    public int releaseSpaceAndNotify(int amount) {
        int space = this.releaseSpace(amount);
        this.doNotify();
        return space;
    }

    public int spaceInBytes() {
        return this.spaceInBytes;
    }

    public Queue<E> getQueue() {
        return this.queue;
    }

    public void notifyWritePossible(WriteHandler writeHandler) {
        this.notifyWritePossible(writeHandler, this.maxQueueSizeHolder.getMaxQueueSize());
    }

    public void notifyWritePossible(WriteHandler writeHandler, int maxQueueSize) {
        if (writeHandler == null) {
            return;
        }
        if (this.isClosed) {
            writeHandler.onError(new IOException("Connection is closed"));
            return;
        }
        if (maxQueueSize < 0 || this.spaceInBytes() < maxQueueSize) {
            try {
                writeHandler.onWritePossible();
            }
            catch (Throwable e) {
                writeHandler.onError(e);
            }
            return;
        }
        this.offerWriteHandler(writeHandler);
        if (this.spaceInBytes() < maxQueueSize && this.removeWriteHandler(writeHandler)) {
            try {
                writeHandler.onWritePossible();
            }
            catch (Throwable e) {
                writeHandler.onError(e);
            }
        } else {
            this.checkWriteHandlerOnClose(writeHandler);
        }
    }

    public boolean forgetWritePossible(WriteHandler writeHandler) {
        return this.removeWriteHandler(writeHandler);
    }

    private void checkWriteHandlerOnClose(WriteHandler writeHandler) {
        if (this.isClosed && this.removeWriteHandler(writeHandler)) {
            writeHandler.onError(new IOException("Connection is closed"));
        }
    }

    public void doNotify() {
        if (this.maxQueueSizeHolder == null || this.writeHandlersCounter == 0) {
            return;
        }
        int maxQueueSize = this.maxQueueSizeHolder.getMaxQueueSize();
        while (this.spaceInBytes() < maxQueueSize) {
            WriteHandler writeHandler = this.pollWriteHandler();
            if (writeHandler == null) {
                return;
            }
            try {
                writeHandler.onWritePossible();
            }
            catch (Throwable e) {
                writeHandler.onError(e);
            }
        }
    }

    public void setCurrentElement(E task) {
        this.currentElement = task;
        if (task != null && this.isClosed && currentElementUpdater.compareAndSet(this, (AsyncQueueRecord)task, (AsyncQueueRecord)null)) {
            ((AsyncQueueRecord)task).notifyFailure(new IOException("Connection closed"));
        }
    }

    public boolean compareAndSetCurrentElement(E expected, E newValue) {
        if (currentElementUpdater.compareAndSet(this, (AsyncQueueRecord)expected, (AsyncQueueRecord)newValue)) {
            if (newValue != null && this.isClosed && currentElementUpdater.compareAndSet(this, (AsyncQueueRecord)newValue, (AsyncQueueRecord)null)) {
                ((AsyncQueueRecord)newValue).notifyFailure(new IOException("Connection closed"));
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean remove(E task) {
        return this.queue.remove(task);
    }

    public void offer(E task) {
        this.queue.offer(task);
        if (this.isClosed && this.queue.remove(task)) {
            ((AsyncQueueRecord)task).notifyFailure(new IOException("Connection closed"));
        }
    }

    public boolean isEmpty() {
        return this.spaceInBytes == 0;
    }

    public void onClose() {
        this.onClose(null);
    }

    public void onClose(Throwable cause) {
        WriteHandler writeHandler;
        this.isClosed = true;
        IOException error = null;
        if (!this.isEmpty()) {
            E record;
            if (error == null) {
                error = new IOException("Connection closed", cause);
            }
            while ((record = this.poll()) != null) {
                ((AsyncQueueRecord)record).notifyFailure(error);
            }
        }
        while ((writeHandler = this.pollWriteHandler()) != null) {
            if (error == null) {
                error = new IOException("Connection closed", cause);
            }
            writeHandler.onError(error);
        }
    }

    private void offerWriteHandler(WriteHandler writeHandler) {
        writeHandlersCounterUpdater.incrementAndGet(this);
        this.writeHandlersQueue.offer(writeHandler);
    }

    private boolean removeWriteHandler(WriteHandler writeHandler) {
        if (this.writeHandlersQueue.remove(writeHandler)) {
            writeHandlersCounterUpdater.decrementAndGet(this);
            return true;
        }
        return false;
    }

    private WriteHandler pollWriteHandler() {
        WriteHandler record = this.writeHandlersQueue.poll();
        if (record != null) {
            writeHandlersCounterUpdater.decrementAndGet(this);
            return record;
        }
        return null;
    }

    public static interface MutableMaxQueueSize {
        public int getMaxQueueSize();
    }
}

